/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.client.admin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseTariffGroup;
import ru.bitel.bgbilling.modules.license.common.service.LicenseService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBoxRefresh;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;

public class LicenseTariffGroupPanel
extends BGUPanel {
    private BGDataSourceTableModel tableModel = new BGDataSourceTableModel("TariffGroup");
    private BGUPanel.WebServiceHolder<LicenseService> licenseService = new BGUPanel.WebServiceHolder((BGUPanel)this, LicenseService.class);

    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable((TableModel)this.tableModel);
        table.setSelectionMode(0);
        BGSwingUtilites.handleEdit((JTable)table, (AbstractBGUPanel)this);
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            BGUTableParams tableParams = new BGUTableParams();
            this.tableModel.loadData((ClientContext)this.getContext(), tableParams);
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new TariffGroupEditor("\u041d\u043e\u0432\u0430\u044f \u0442\u0430\u0440\u0438\u0444\u043d\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430", new Id()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.tableModel.optSelectRow(Id.class).ifPresentOrElse(id -> new TariffGroupEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b", (Id)id).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0433\u0440\u0443\u043f\u043f\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f")));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> this.tableModel.optSelectRow(Id.class).ifPresentOrElse(id -> this.deleteTariffGroup(id.getId()), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0433\u0440\u0443\u043f\u043f\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f")));
    }

    private void deleteTariffGroup(int id) {
        this.tryCall(() -> {
            LicenseTariffGroup tariffGroup = ((LicenseService)this.licenseService.get()).licenseTariffGroupGet(id);
            if (tariffGroup != null && ClientUtils.confirmDelete((Object)tariffGroup.getTitle())) {
                ((LicenseService)this.licenseService.get()).licenseTariffGroupDelete(id);
                this.performAction("refresh");
            }
        });
    }

    class TariffGroupEditor
    extends BGEditorDialog<Id> {
        private BGTextField title;
        private LicenseTariffGroup tariffGroup;
        private BGUComboBoxRefresh<IdTitle> ranges;

        public TariffGroupEditor(String title, Id data) {
            super(title, (Object)data);
            this.title = new BGTextField(40);
            this.tariffGroup = new LicenseTariffGroup();
            this.ranges = new BGUComboBoxRefresh();
        }

        public void doDialogPanel() {
            this.addFieldV("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:", (JComponent)this.title);
            this.addFieldV("\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d:", (JComponent)this.ranges);
            if (((Id)this.data).getId() > 0) {
                this.tryCall(() -> {
                    this.tariffGroup = ((LicenseService)LicenseTariffGroupPanel.this.licenseService.get()).licenseTariffGroupGet(((Id)this.data).getId());
                });
            }
            this.ranges.setSupplier(() -> {
                List titles = ((LicenseService)LicenseTariffGroupPanel.this.licenseService.get()).licenseTariffRangeTitles();
                titles.add(0, new IdTitle(0, "unlim"));
                return titles;
            });
            this.ranges.refresh();
            this.title.setText(this.tariffGroup.getTitle());
            this.ranges.setSelectedItem((Object)new Id().setId(this.tariffGroup.getTariffRangeId()));
        }

        public boolean doApply() throws Exception {
            if (this.title.getText().isBlank()) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            this.tariffGroup.setId(((Id)this.data).getId());
            this.tariffGroup.setTitle(this.title.getText().trim());
            this.tariffGroup.setTariffRangeId(((IdTitle)this.ranges.getSelectedItem()).getId());
            return this.tryCallBoolean(() -> {
                ((LicenseService)LicenseTariffGroupPanel.this.licenseService.get()).licenseTariffGroupUpdate(this.tariffGroup);
                LicenseTariffGroupPanel.this.performAction("refresh");
            });
        }
    }
}

