/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountPort;
import ru.bitel.common.model.Id;

public class VoiceAccountPortDao
extends AbstractIdDao<VoiceAccountPort> {
    public VoiceAccountPortDao(Connection con, int moduleId) {
        super(con, moduleId, "voice_account_port");
    }

    protected VoiceAccountPort getFromRS(ResultSet rs) throws SQLException {
        return VoiceAccountPort.builder().setId(rs.getInt("id")).setAccountId(rs.getInt("accountId")).setPort(rs.getString("port")).setOut(rs.getBoolean("is_out")).build();
    }

    protected void updateImpl(VoiceAccountPort voiceAccountPort) throws SQLException {
        String querySet = "accountId=?, port=?, is_out=?";
        try (PreparedStatement ps = this.prepareStatement((Id)voiceAccountPort, querySet);){
            int i = this.setParams(voiceAccountPort, ps, 1);
            this.executeUpdate((Id)voiceAccountPort, i, ps);
        }
    }

    private int setParams(VoiceAccountPort b, PreparedStatement ps, int index) throws SQLException {
        ps.setInt(index++, b.getAccountId());
        ps.setString(index++, b.getPort());
        ps.setBoolean(index++, b.isOut());
        return index;
    }

    public List<VoiceAccountPort> list(int accountId) throws SQLException {
        return this.list("accountId=?", "port", new Object[]{accountId});
    }

    public List<VoiceAccountPort> list(int accountId, boolean out) throws SQLException {
        return this.list("accountId=? AND is_out=?", "port", new Object[]{accountId, out});
    }

    public void update(int accountId, List<VoiceAccountPort> ports) throws SQLException {
        this.delete("accountId=?", new Object[]{accountId});
        if (ports.size() == 0) {
            return;
        }
        StringBuffer query = new StringBuffer(ports.size() * 4).append("INSERT INTO " + this.tableName + "( accountId, port, is_out ) VALUES ").append(ports.stream().map(v -> " ( ?, ?, ? )").collect(Collectors.joining(",")));
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int idx = 1;
            for (VoiceAccountPort port : ports) {
                port.setAccountId(accountId);
                idx = this.setParams(port, ps, idx);
            }
            ps.executeUpdate();
        }
    }
}

