/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.ext.dhcp;

import bitel.billing.server.ext.ExtAdminSocketListener;
import bitel.billing.server.ext.ExtServer;
import bitel.billing.server.ext.dhcp.DHCPAdminSocketThread;
import bitel.billing.server.ext.dhcp.DHCPProcessor;
import bitel.billing.server.ext.dhcp.DHCPSetup;
import bitel.billing.server.ext.dhcp.DHCPSocketListener;

public class DHCP
extends ExtServer {
    @Override
    protected DHCPSetup newSetup() {
        return new DHCPSetup();
    }

    public void start() throws ClassNotFoundException {
        DHCPSetup setup = this.newSetup();
        setup.initLogging();
        String _clazz = setup.get("processor.class", null);
        Class<DHCPProcessor> clazz = Class.forName(_clazz).asSubclass(DHCPProcessor.class);
        int port = setup.getInt("dhcp.port", 67);
        String host = setup.get("dhcp.host", null);
        int adminPort = setup.getInt("admin.port", 1855);
        int threadCount = setup.getInt("dhcp.thread.count", 10);
        DHCPSocketListener socketListener = new DHCPSocketListener(setup, port, host, threadCount, true, clazz);
        new ExtAdminSocketListener(this.getLogger(), adminPort, setup, DHCPAdminSocketThread.newFactory(socketListener.getProcessor())).start();
        socketListener.start();
    }

    public void startRelayProcessor() throws ClassNotFoundException {
        DHCPSetup setup = this.newSetup();
        setup.initLogging();
        String _clazz = "bitel.billing.server.ext.dhcp.DHCPRelayProcessor";
        Class<DHCPProcessor> clazz = Class.forName(_clazz).asSubclass(DHCPProcessor.class);
        int port = setup.getInt("dhcp.port", 67);
        String host = setup.get("dhcp.host", null);
        int adminPort = setup.getInt("admin.port", 1855);
        int threadCount = setup.getInt("dhcp.thread.count", 10);
        DHCPSocketListener socketListener = new DHCPSocketListener(setup, port, host, threadCount, true, clazz);
        new ExtAdminSocketListener(this.getLogger(), adminPort, setup, DHCPAdminSocketThread.newFactory(socketListener.getProcessor())).start();
        socketListener.start();
    }

    public static void main(String[] args) {
        try {
            if (args != null && args.length > 0) {
                if (args[0].equals("start")) {
                    new DHCP().start();
                } else {
                    new DHCP().parseParams(args);
                }
            } else {
                new DHCP().showHelp();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void sendCommand(String args) {
        if ("stop".equals(args.trim())) {
            args = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><stop/>";
        } else if ("status".equals(args.trim())) {
            args = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><status/>";
        }
        super.sendCommand(args);
    }

    @Override
    public void showHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nUsage: [start|stop|help]");
        sb.append("\nParametrs:");
        sb.append("\n\t help|?    - show this help");
        sb.append("\n\t start     - starting DHCP server");
        sb.append("\n\t stop      - stopping DHCP server");
        System.out.println(sb.toString());
    }

    public static <N> N newInstance(Class<N> clazz, String name) throws Exception {
        Class<N> _clazz = Class.forName(name).asSubclass(clazz);
        return _clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

