/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPatternNamedNumber;
import ru.bitel.bgbilling.kernel.contract.pattern.common.service.ContractPatternService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;

public class NumberPatternEditor
extends BGPanel {
    private ContractPatternService contractPatternService = null;
    private ContractPatternNamedNumberTableModel model = new ContractPatternNamedNumberTableModel();

    public NumberPatternEditor() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void jbInit() throws Exception {
        BGUTable table = new BGUTable(this.model);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() == 2) {
                    NumberPatternEditor.this.editItem();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
    }

    @Override
    public void setData() {
        try {
            this.model.setData(this.getContractPatternService().numedNumberPatternList());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public void newItem() {
        new Editor("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0438\u043c\u0435\u043d\u043d\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043d\u043e\u043c\u0435\u0440\u043e\u0432 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432", new ContractPatternNamedNumber()).open();
    }

    @Override
    public void editItem() {
        this.model.optSelectedRow().ifPresentOrElse(namedNumber -> new Editor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0438\u043c\u0435\u043d\u043d\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043d\u043e\u043c\u0435\u0440\u043e\u0432 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432", (ContractPatternNamedNumber)namedNumber).open(), () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f"));
    }

    @Override
    public void deleteItem() {
        ContractPatternNamedNumber namedNumber = (ContractPatternNamedNumber)this.model.getSelectedRow();
        if (namedNumber != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432?", "", 0, 3) == 0) {
            try {
                this.getContractPatternService().deleteNamedNumber(namedNumber.getId());
                this.setData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    private ContractPatternService getContractPatternService() {
        if (this.contractPatternService == null) {
            this.contractPatternService = this.getContext().getPort(ContractPatternService.class);
        }
        return this.contractPatternService;
    }

    class ContractPatternNamedNumberTableModel
    extends BGTableModel<ContractPatternNamedNumber> {
        public ContractPatternNamedNumberTableModel() {
            super(ContractPatternNamedNumberTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 150, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, 150, -1, "comment", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0418\u043d\u0434\u0435\u043a\u0441", -1, 150, -1, "index", true, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041a\u043e\u043b-\u0432\u043e \u0446\u0438\u0444\u0440", -1, 150, -1, "countNumber", true, DecimalTableCellRenderer.INTEGER());
        }
    }

    class Editor
    extends BGEditorDialog<ContractPatternNamedNumber> {
        private BGTextField fieldName;
        private BGTextField fieldComment;
        private IntTextField fieldIndex;
        private IntTextField fieldCount;

        public Editor(String title, ContractPatternNamedNumber data) {
            super(title, data);
            this.fieldName = new BGTextField(50);
            this.fieldComment = new BGTextField();
            this.fieldIndex = new IntTextField(0);
            this.fieldCount = new IntTextField(0);
        }

        @Override
        public void doDialogPanel() {
            this.addFieldV("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:", this.fieldName);
            this.addFieldV("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:", this.fieldComment);
            this.addFieldV("\u0418\u043d\u0434\u0435\u043a\u0441:", this.fieldIndex);
            this.addFieldV("\u041a\u043e\u043b-\u0432\u043e \u0446\u0438\u0444\u0440:", this.fieldCount);
            this.fieldName.setText(((ContractPatternNamedNumber)this.data).getTitle());
            this.fieldComment.setText(((ContractPatternNamedNumber)this.data).getComment());
            this.fieldIndex.setMaxValue(Integer.MAX_VALUE);
            this.fieldIndex.setValue(((ContractPatternNamedNumber)this.data).getIndex());
            this.fieldIndex.setEnabled(((ContractPatternNamedNumber)this.data).getId() < 1);
            this.fieldCount.setMaxValue(10L);
            this.fieldCount.setValue(((ContractPatternNamedNumber)this.data).getCountNumber());
            this.fieldCount.setEnabled(((ContractPatternNamedNumber)this.data).getId() < 1);
        }

        @Override
        public boolean doApply() throws Exception {
            if (this.fieldName.getText().trim().length() == 0) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            ((ContractPatternNamedNumber)this.data).setTitle(this.fieldName.getText());
            ((ContractPatternNamedNumber)this.data).setComment(this.fieldComment.getText());
            ((ContractPatternNamedNumber)this.data).setIndex(Utils.parseInt(this.fieldIndex.getText()));
            ((ContractPatternNamedNumber)this.data).setCountNumber(Utils.parseInt(this.fieldCount.getText()));
            NumberPatternEditor.this.getContractPatternService().updateNamedNumber((ContractPatternNamedNumber)this.data);
            NumberPatternEditor.this.setData();
            return true;
        }
    }
}

