/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.pattern.editors;

import bitel.billing.module.common.BGComboBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.BGDialog;

public abstract class ConfigBaseEditor
extends BGDialog {
    protected BGButtonPanelRestoreOkCancelHelp okPanel = new BGButtonPanelRestoreOkCancelHelp();
    protected JCheckBox checkBox = new JCheckBox("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
    protected String originalValue = new String();
    protected String resultValue = new String();
    protected String lastEditText = new String();
    protected String defaultValue = new String();
    private Color colRed = new Color(255, 133, 133);

    public ConfigBaseEditor() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setModal(true);
        this.setTitle("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440");
        this.setMinimumSize(new Dimension(300, 130));
        this.moveWindowToCenterScreen();
        this.setDefaultCloseOperation(2);
    }

    public boolean isReset() {
        return this.checkBox.isSelected();
    }

    public String getResult() {
        return this.resultValue;
    }

    protected void addComp(JComponent comp) {
        this.add((Component)comp, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(15, 15, 5, 15), 0, 0));
        this.add((Component)this.checkBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 5, 15), 0, 0));
        this.add((Component)this.okPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 15, 15, 15), 0, 0));
        this.pack();
        if (comp instanceof BGTextField) {
            this.addListenersForTextField((BGTextField)comp);
        } else if (comp instanceof BGComboBox) {
            comp.setBackground(Color.WHITE);
            this.addListenersForComboBox((BGComboBox)comp);
        }
    }

    private void addListenersForComboBox(BGComboBox<?> comboBox) {
        this.okPanel.addActionListener(e -> {
            String actionCommand = e.getActionCommand();
            if ("reset".equals(actionCommand)) {
                comboBox.setSelectedId(this.originalValue);
            } else {
                if ("cancel".equals(actionCommand)) {
                    this.setVisible(false);
                    this.resultValue = "";
                    this.dispose();
                }
                if ("ok".equals(actionCommand)) {
                    this.result = "ok";
                    this.resultValue = comboBox.getSelectedId();
                    this.setVisible(false);
                    this.dispose();
                }
            }
        });
        this.checkBox.addActionListener(e -> {
            if (this.checkBox.isSelected()) {
                this.lastEditText = comboBox.getSelectedId();
                comboBox.setSelectedId(this.defaultValue);
                comboBox.setEnabled(false);
            } else {
                comboBox.setSelectedId(this.lastEditText);
                comboBox.setEnabled(true);
            }
        });
    }

    private void addListenersForTextField(final BGTextField textField) {
        this.okPanel.addActionListener(e -> {
            String actionCommand = e.getActionCommand();
            if ("reset".equals(actionCommand)) {
                textField.setText(this.originalValue);
            } else {
                if ("cancel".equals(actionCommand)) {
                    this.setVisible(false);
                    this.resultValue = "";
                    this.dispose();
                }
                if ("ok".equals(actionCommand)) {
                    this.result = "ok";
                    this.resultValue = textField.getText();
                    this.setVisible(false);
                    this.dispose();
                }
            }
        });
        this.checkBox.addActionListener(e -> {
            if (this.checkBox.isSelected()) {
                this.lastEditText = textField.getText();
                textField.setText(this.defaultValue);
                textField.setEnabled(false);
            } else {
                textField.setText(this.lastEditText);
                textField.setEnabled(true);
            }
        });
        textField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent arg0) {
                if (!ConfigBaseEditor.this.checkValue(textField.getText())) {
                    textField.setBackground(ConfigBaseEditor.this.colRed);
                    ConfigBaseEditor.this.okPanel.getButtonOK().setEnabled(false);
                } else {
                    textField.setBackground(Color.WHITE);
                    ConfigBaseEditor.this.okPanel.getButtonOK().setEnabled(true);
                }
            }
        });
    }

    public boolean checkValue(String valueStr) {
        return false;
    }
}

