/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.script.client;

import bitel.billing.module.common.BGTextArea;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.time.LocalDate;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.script.common.bean.ContractScript;
import ru.bitel.bgbilling.kernel.contract.script.common.service.ContractScriptService;
import ru.bitel.bgbilling.kernel.script.common.service.EventScriptService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

public class ContractScriptPanel
extends BGUPanel {
    private ScriptTableModel tableModel = null;
    private BGUPanel.WebServiceHolder<EventScriptService> eventScriptService = new BGUPanel.WebServiceHolder(EventScriptService.class);
    private BGUPanel.WebServiceHolder<ContractScriptService> contractScriptService = new BGUPanel.WebServiceHolder(ContractScriptService.class);

    @Override
    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable(this.getTableModel());
        table.setSelectionMode(0);
        BGSwingUtilites.handleEdit((JTable)table, this, "edit");
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private ScriptTableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new ScriptTableModel(ScriptTableModel.class.getName());
        }
        return this.tableModel;
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> this.getTableModel().setData(this.contractScriptService.get().contractScriptList(((ClientContext)this.getContext()).getContractId())));
        new AbstractBGUPanel.BGActionNew(e -> new ScriptEditorDialog("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u043a\u0440\u0438\u043f\u0442\u0430", new ContractScript()).open());
        new AbstractBGUPanel.BGActionEdit(e -> this.showEditDialog(this.getTableModel(), ScriptEditorDialog.class, "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u043a\u0440\u0438\u043f\u0442\u0430"));
        new AbstractBGUPanel.BGActionDelete(e -> this.getTableModel().optSelectedRow().ifPresentOrElse(contractScript -> {
            int idInt = contractScript.getId();
            if (idInt > 0 && ClientUtils.confirmDelete("\u0441\u043a\u0440\u0438\u043f\u0442")) {
                this.tryCall(() -> this.contractScriptService.get().contractScriptDelete(idInt));
                this.performAction("refresh");
            }
        }, () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u043a\u0440\u0438\u043f\u0442 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f")));
    }

    class ScriptTableModel
    extends BGTableModel<ContractScript> {
        public ScriptTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0421\u043a\u0440\u0438\u043f\u0442", 300, 400, 500, "script", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 250, 250, 250, "period", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 250, 250, -1, "comment", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class ScriptEditorDialog
    extends BGEditorDialog<ContractScript> {
        private List<IdTitle> scriptItems;
        private BGTextArea comment;
        private BGUList<IdTitle> scriptList;
        private BGControlPanelPeriodNoB periodPanel;

        public ScriptEditorDialog(String title, ContractScript data) {
            super(title, data);
            this.scriptItems = null;
            this.comment = new BGTextArea(6, 10);
            this.scriptList = new BGUList();
            this.periodPanel = new BGControlPanelPeriodNoB();
        }

        @Override
        public void doDialogPanel() {
            this.panel.add((Component)this.getLeftPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getRightPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.tryCall(() -> {
                this.scriptItems = ContractScriptPanel.this.eventScriptService.get().getScriptList();
            });
            this.scriptList.setData(this.scriptItems);
            ClientUtils.setListSelection(this.scriptList, ((ContractScript)this.data).getScriptId(), -1);
            this.periodPanel.setPeriod(((ContractScript)this.data).getId() < 1 ? new Period(LocalDate.now(), null) : ((ContractScript)this.data).getPeriod());
            this.comment.setText(((ContractScript)this.data).getId() < 1 ? "" : ((ContractScript)this.data).getComment());
        }

        private JPanel getLeftPanel() {
            this.scriptList.setSelectionMode(0);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0421\u043a\u0440\u0438\u043f\u0442:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)BGSwingUtilites.wrapScrollPane(this.scriptList, 400, 200), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getRightPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.periodPanel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
            return panel;
        }

        @Override
        public boolean doApply() throws Exception {
            IdTitle scriptItem = (IdTitle)this.scriptList.getSelectedValue();
            if (scriptItem == null) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0441\u043a\u0440\u0438\u043f\u0442!");
                return false;
            }
            Period period = this.periodPanel.getPeriod();
            if (period.getDateFrom() == null) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0430\u044f \u0434\u0430\u0442\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
                return false;
            }
            return this.tryCallBoolean(() -> {
                ((ContractScript)this.data).setContractId(((ClientContext)ContractScriptPanel.this.getContext()).getContractId());
                ((ContractScript)this.data).setScriptId(scriptItem.getId());
                ((ContractScript)this.data).setPeriod(period);
                ((ContractScript)this.data).setComment(this.comment.getText());
                ContractScriptPanel.this.contractScriptService.get().contractScriptUpdate((ContractScript)this.data);
                ContractScriptPanel.this.performAction("refresh");
                EventBus.publish((Object)new UpdateContractTreeEvent(((ClientContext)ContractScriptPanel.this.getContext()).getModuleId(), ((ClientContext)ContractScriptPanel.this.getContext()).getContractId()));
            });
        }
    }
}

