/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.eap;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.MSUtils;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusSession;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPAuthenticator;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPMessage;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPPEAPAuthenticator0;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPTTLSAuthenticator0;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.common.sql.ConnectionSet;

public class EAPSession<N extends Nas<?, ?, ?>, P>
extends RadiusSession<N, P> {
    private static final Logger logger = LogManager.getLogger();
    private static final byte BYTE_0 = 0;
    private static final byte BYTE_4 = 4;
    private static final EAPMessage nullEAPMessage = new EAPMessage(0, 0, 0, null);
    public byte identifier;
    protected EAPAuthenticator<N, P> authenticator;
    public Action action = Action.identity;
    private Action previous;
    private RadiusPacket lastResponsePacket;
    protected RadiusPacket acceptPacket;
    private static Random random = new Random();

    private static byte[] newState() {
        byte[] result = new byte[16];
        random.nextBytes(result);
        return result;
    }

    public EAPSession(String userName, RadiusAttribute.RadiusAttributeString userNameAttribute, P sessionParams) {
        super(EAPSession.newState(), userName, userNameAttribute, sessionParams);
    }

    @Override
    public boolean checkPassword(Nas<?, ?, ?> nas, RadiusAttributeSet request, RadiusAttributeSet response, String openPassw, byte[] secret, byte[] authenticator) {
        return this.authenticator.checkPassword(request, response, openPassw, secret, authenticator);
    }

    @Override
    public void accessRequest(RadiusProcessor<?, N, P> processor, RadiusListenerWorker<N> req, N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int log_record_id) {
        this.accessRequest0(processor, req, nas, request, response, connectionSet, log_record_id);
        if (logger.isTraceEnabled()) {
            logger.trace("EAP session state: " + String.valueOf((Object)this.action));
        }
    }

    private void accessRequest0(RadiusProcessor<?, N, P> processor, RadiusListenerWorker<N> req, N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int log_record_id) {
        EAPMessage eap = EAPMessage.newEAPMessage(request);
        EAPMessage result = null;
        int code = 4;
        try {
            result = this.handshake(eap, processor, req, nas, request, response, connectionSet, log_record_id);
            code = result.code;
        }
        catch (SSLException e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
        }
        switch (code) {
            case 1: {
                response.setAttributes(-1, 79, result.toRadiusAttributes());
                response.setCode((byte)11);
                return;
            }
            case 3: {
                response.setAttribute(this.userNameAttribute);
                response.setByteAttribute(-1, 79, new byte[]{3, eap.identifier, 0, 4});
                response.removeAttributes(-1, 24);
                byte[][] keys = this.authenticator.getMppeKeys();
                if (keys != null) {
                    try {
                        MSUtils.addMppeKeys(request, response, keys[1], keys[0], ((Nas)nas).getSecret(), request.getAuthenticator(), false);
                    }
                    catch (NoSuchAlgorithmException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                response.setCode((byte)2);
                return;
            }
            case 0: {
                return;
            }
        }
        response.setAttribute(this.userNameAttribute);
        response.setByteAttribute(-1, 79, new byte[]{4, eap.identifier, 0, 4});
        response.setCode((byte)3);
    }

    private EAPMessage handshake(EAPMessage eap, RadiusProcessor<?, N, P> processor, RadiusListenerWorker<N> req, N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int log_record_id) throws SSLException {
        if (this.authenticator == null) {
            switch (eap.type) {
                case 3: {
                    logger.debug("Recieve NAK");
                    return this.reject();
                }
            }
            try {
                this.identifier = eap.identifier;
                switch (((Nas)nas).getConf().getInt("eap.type", 25)) {
                    case 21: {
                        this.authenticator = new EAPTTLSAuthenticator0(this);
                        return this.authenticator.start();
                    }
                }
                this.authenticator = new EAPPEAPAuthenticator0(this);
                return this.authenticator.start();
            }
            catch (IllegalStateException e) {
                logger.warn("EAP is not enabled");
                return this.reject();
            }
        }
        if (eap.type == this.authenticator.getAuthentificatorType() || eap.type == 2) {
            return this.authenticator.authenticate(eap, this, processor, req, nas, request, response, connectionSet, log_record_id);
        }
        if (eap.type == 3) {
            logger.debug("Recieve NAK");
            return this.rejectWithNotify(response, "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043f\u043e\u0434\u043b\u0438\u043d\u043d\u043e\u0441\u0442\u0438: \u0442\u0438\u043f EAP: \u0417\u0430\u0449\u0438\u0449\u0435\u043d\u043d\u044b\u0435 EAP (PEAP)");
        }
        return this.reject();
    }

    public final EAPMessage reject() {
        return new EAPMessage(4, this.identifier, this.authenticator != null ? this.authenticator.getAuthentificatorType() : (byte)0, null);
    }

    public final void rejecting() {
        this.action = Action.rejectingWithErrorCode;
    }

    public final EAPMessage accept() {
        return new EAPMessage(3, this.identifier, this.authenticator.getAuthentificatorType(), null);
    }

    public final EAPMessage rejectWithNotify(RadiusPacket response, String message) {
        if (message != null) {
            try {
                this.action = Action.notify;
                this.previous = Action.rejecting;
                return new EAPMessage(1, this.identifier, 2, ByteBuffer.wrap(message.getBytes("cp1251")));
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
            }
        }
        this.action = Action.rejecting;
        return new EAPMessage(4, this.identifier, 2, null);
    }

    public final EAPMessage checkPacket(EAPMessage eap, RadiusPacket response) {
        if (eap.identifier != this.identifier) {
            if (eap.identifier == (byte)(this.identifier - 1) && this.lastResponsePacket != null) {
                response.fromPacket(this.lastResponsePacket);
                return nullEAPMessage;
            }
            logger.warn("EAP identifier fault");
            return this.reject();
        }
        this.lastResponsePacket = response;
        this.identifier = (byte)(this.identifier + 1);
        if (this.action == Action.notify) {
            this.action = this.previous;
        }
        switch (this.action.ordinal()) {
            case 0: {
                if (eap.getData().remaining() < 2) {
                    return this.reject();
                }
                this.action = Action.handshaking;
                break;
            }
            case 5: 
            case 6: {
                return this.reject();
            }
            case 7: {
                return this.accept();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(new String(new byte[]{74, 65, 73, 74}));
    }

    public static enum Action {
        identity,
        handshaking,
        handshaking_waitnext,
        notify,
        messaging,
        rejectingWithErrorCode,
        rejecting,
        accepting;

    }
}

