/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.json.JSONObject;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

public class BGControlPanelPages
extends JPanel
implements PropertyChangeListener,
PopupMenuListener {
    private int pageIndex = 1;
    private int pageIndexOld = 1;
    private int pageCount = 1;
    private int pageSize = 25;
    private int pageSizeOld = 25;
    private String key = null;
    private boolean readConfig = true;
    private ClientSetup setupData = ClientSetup.getInstance();
    private BGTextField textField = new BGTextField(10);
    private PageButton toFirstButton;
    private PageButton toPrevButton;
    private PageButton toNextButton;
    private PageButton toLastButton;
    private static final Popup popup;

    public BGControlPanelPages() {
        this((String)null);
    }

    public BGControlPanelPages(String key) {
        this.key = key;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.textField.setFocusable(false);
        this.textField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BGControlPanelPages.this.setPopupVisible(true);
            }
        });
        this.init();
        this.addHierarchyListener(e -> {
            if (e.getID() == 1400 && (e.getChangeFlags() & 1L) > 0L && e.getChanged() instanceof BGPanel && this.setupData == null) {
                this.setupData = ((BGPanel)e.getChanged()).getSetup();
                this.setText();
            }
        });
    }

    private void jbInit() throws Exception {
        this.textField.setEditable(false);
        this.textField.setHorizontalAlignment(0);
        this.toFirstButton = new PageButton("to_first.gif", "\u041d\u0430 \u043f\u0435\u0440\u0432\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 (Ctrl+Alt+PageUp)", "toFirst");
        this.toPrevButton = new PageButton("to_prev.gif", "\u041d\u0430 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 (Alt+PageUp)", "toPrev");
        this.toNextButton = new PageButton("to_next.gif", "\u041d\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 (Alt+PageDown)", "toNext");
        this.toLastButton = new PageButton("to_last.gif", "\u041d\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 (Ctrl+Alt+PageDown)", "toLast");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.toFirstButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.toPrevButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.textField, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.toNextButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.toLastButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setText() {
        this.textField.setText(this.getPageIndex() + " \u0438\u0437 " + this.getPageCount() + " [" + this.getPageSize() + "]");
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
        this.setText();
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
        this.setText();
    }

    public void setPageCount(Element element) {
        this.setPageCount(Page.getPageCount(element));
    }

    void toPage(String name) {
        int oldValue = this.getPageIndex();
        switch (name) {
            case "toFirst": {
                this.setPageIndex(1);
                break;
            }
            case "toPrev": {
                if (this.getPageIndex() <= 1) break;
                this.setPageIndex(this.getPageIndex() - 1);
                break;
            }
            case "toNext": {
                if (this.getPageIndex() >= this.getPageCount()) break;
                this.setPageIndex(this.getPageIndex() + 1);
                break;
            }
            case "toLast": {
                this.setPageIndex(this.getPageCount());
                break;
            }
        }
        this.firePropertyChange(name, oldValue, this.getPageIndex());
    }

    public int getPageSize() {
        if (this.setupData != null && this.readConfig && this.getKey() != null) {
            Preferences prefs = this.setupData.getUserConfig();
            this.pageSize = prefs.getInt("page.size." + this.getKey(), 25);
            this.readConfig = false;
        }
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (this.pageSize != pageSize) {
            this.pageIndex = 1;
        }
        this.pageSize = pageSize;
        if (this.setupData != null && this.getKey() != null) {
            Preferences prefs = this.setupData.getUserConfig();
            prefs.set("page.size." + this.getKey(), String.valueOf(pageSize));
            this.setupData.saveUserConfig();
        }
        this.setText();
    }

    public void reset() {
        this.setPageIndex(1);
        this.setPageCount(1);
    }

    public void init() {
        this.reset();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("toFirstPage", new PageAction("toFirst"));
        actionMap.put("toPrevPage", new PageAction("toPrev"));
        actionMap.put("toNextPage", new PageAction("toNext"));
        actionMap.put("toLastPage", new PageAction("toLast"));
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(33, 640), "toFirstPage");
        inputMap.put(KeyStroke.getKeyStroke(33, 512), "toPrevPage");
        inputMap.put(KeyStroke.getKeyStroke(34, 512), "toNextPage");
        inputMap.put(KeyStroke.getKeyStroke(34, 640), "toLastPage");
    }

    public void setPopupVisible(boolean visible) {
        if (visible) {
            this.pageIndexOld = this.getPageIndex();
            this.pageSizeOld = this.getPageSize();
            BGControlPanelPages.popup.pageSetPanel.setPageIndex(this.pageIndexOld);
            BGControlPanelPages.popup.pageSetPanel.setPageSize(this.pageSizeOld);
            BGControlPanelPages.popup.pageSetPanel.addPropertyChangeListener(this);
            popup.addPopupMenuListener(this);
            popup.show(this, 0, this.getHeight() + 1);
        } else {
            popup.setVisible(false);
        }
    }

    public String getKey() {
        if (this.key == null || this.key.isEmpty()) {
            boolean flag = false;
            StringBuffer buf = new StringBuffer();
            for (Container container = this.getParent(); container != null; container = container.getParent()) {
                if (buf.length() > 0) {
                    buf.append("_");
                }
                buf.append(container.getClass().getName());
                flag = true;
            }
            if (flag) {
                this.key = Utils.getDigest(buf.toString(), "UTF-8");
            }
        }
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setPageInfo(JSONObject page) {
        int serverPageIndex = page.optInt("pageIndex", 1);
        int serverPageCount = page.optInt("pageCount", 1);
        if (serverPageIndex > 0) {
            this.setPageIndex(serverPageIndex);
        }
        if (serverPageCount > 0) {
            this.setPageCount(serverPageCount);
        }
    }

    public void setPageInfo(Element element) {
        if (element != null) {
            int serverPageIndex = Page.getPageIndex(element);
            int serverPageCount = Page.getPageCount(element);
            if (serverPageIndex > 0) {
                this.setPageIndex(serverPageIndex);
            }
            if (serverPageCount > 0) {
                this.setPageCount(serverPageCount);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("pageSet".equals(propertyName)) {
            this.setPopupVisible(false);
            this.setPageIndex(Math.min(BGControlPanelPages.popup.pageSetPanel.getPageIndex(), this.getPageCount()));
            this.setPageSize(BGControlPanelPages.popup.pageSetPanel.getPageSize());
            if (this.getPageSize() != this.pageSizeOld) {
                this.firePropertyChange("toSize", this.pageSizeOld, this.getPageSize());
            }
            if (this.getPageIndex() != this.pageIndexOld) {
                this.firePropertyChange("toPage", this.pageIndexOld, this.getPageIndex());
            }
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(e -> {
            String name = e.getPropertyName();
            if (name != null && name.startsWith("to")) {
                listener.propertyChange(e);
            }
        });
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        BGControlPanelPages.popup.pageSetPanel.removePropertyChangeListener(this);
        popup.removePopupMenuListener(this);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    public Page getPage() {
        return new Page(this.getPageIndex(), this.getPageSize());
    }

    public void setPage(Page page) {
        this.setPageIndex(page.getPageIndex());
        this.setPageSize(page.getPageSize());
        this.setPageCount(page.getPageCount());
    }

    @Override
    public void setBorder(Border border) {
        if (border instanceof TitledBorder) {
            super.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        } else {
            super.setBorder(border);
        }
    }

    static {
        Popup cp = null;
        try {
            cp = new Popup();
        }
        catch (Throwable ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        popup = cp;
    }

    class PageButton
    extends BGButton {
        public PageButton(String icon, String toolTipText, String name) {
            this.setIcon(ClientUtils.getIcon(icon));
            this.setMargin(new Insets(0, 2, 0, 2));
            this.setToolTipText(toolTipText);
            this.addActionListener(e -> BGControlPanelPages.this.toPage(name));
        }
    }

    class PageAction
    extends AbstractAction {
        private final String name;

        public PageAction(String name) {
            this.name = name;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BGControlPanelPages.this.toPage(this.name);
        }
    }

    private static class Popup
    extends JPopupMenu {
        private PageSetPanel pageSetPanel = new PageSetPanel();

        public Popup() {
            try {
                this.setLayout(new BorderLayout());
                this.add("Center", this.pageSetPanel);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    private static class PageSetPanel
    extends JPanel {
        private int pageIndex = 1;
        private int pageSize = 25;
        private boolean newSize = true;
        private boolean newIndex = true;
        private JTextField pageSizeField = new JTextField(5);
        private JTextField pageIndexField = new JTextField(5);
        private JButton okButton = new BGButton("Ok");
        private JToggleButton modeButton = new JToggleButton(ClientUtils.getIcon("numpad.png"));

        public PageSetPanel() {
            try {
                this.jbInit();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            this.okButton.addActionListener(e -> this.firePropertyChange("pageSet", false, true));
        }

        private void jbInit() throws Exception {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.getSizePanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.getIndexPanel(), new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        }

        private JPanel getSizePanel() {
            JLabel pageSizeLabel = new JLabel("\u0420\u0430\u0437\u043c\u0435\u0440");
            String[] pageSizes = new String[]{"10", "15", "20", "25", "30", "50", "100"};
            ActionListener actionListener = actionEvent -> {
                String actionCommand = actionEvent.getActionCommand();
                this.pageSizeField.setText(actionCommand);
                this.newSize = true;
                this.newIndex = true;
            };
            this.pageSizeField.setEnabled(false);
            this.pageSizeField.setForeground(Color.black);
            this.pageSizeField.setHorizontalAlignment(0);
            this.pageSizeField.setPreferredSize(this.okButton.getPreferredSize());
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)pageSizeLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
            panel.add((Component)this.pageSizeField, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            for (int index = 0; index < pageSizes.length; ++index) {
                int x = index % 2;
                int y = 2 + index / 2;
                BGButton button = new BGButton(pageSizes[index], pageSizes[index], actionListener);
                panel.add((Component)button, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            panel.add((Component)this.modeButton, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getIndexPanel() {
            BGButton button = null;
            JPanel panel = new JPanel(new GridBagLayout());
            JLabel pageIndexLabel = new JLabel("\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430");
            String[] pageIndexes = new String[]{"7", "8", "9", "4", "5", "6", "1", "2", "3"};
            ActionListener actionListener = e -> {
                String actionCommand = e.getActionCommand();
                JTextField pageField = null;
                pageField = this.modeButton.isSelected() ? this.pageSizeField : this.pageIndexField;
                if ("0123456789".indexOf(actionCommand) > -1) {
                    String value = pageField.getText();
                    if (this.modeButton.isSelected()) {
                        if (this.newSize) {
                            pageField.setText(actionCommand);
                            this.newIndex = true;
                            this.newSize = false;
                        } else if (value == null || value.length() > 2 || value.length() == 0 && "0".equals(actionCommand)) {
                            Toolkit.getDefaultToolkit().beep();
                        } else {
                            pageField.setText(value + actionCommand);
                        }
                    } else if (this.newIndex) {
                        pageField.setText(actionCommand);
                        this.newIndex = false;
                        this.newSize = true;
                    } else if (value == null || value.length() > 4 || value.length() == 0 && "0".equals(actionCommand)) {
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        pageField.setText(value + actionCommand);
                    }
                } else {
                    pageField.setText("");
                }
            };
            panel.add((Component)pageIndexLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.pageIndexField.setEnabled(false);
            this.pageIndexField.setForeground(Color.black);
            this.pageIndexField.setHorizontalAlignment(0);
            panel.add((Component)this.pageIndexField, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.okButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            for (int index = 0; index < pageIndexes.length; ++index) {
                int x = index % 3;
                int y = 2 + index / 3;
                button = new BGButton(pageIndexes[index], pageIndexes[index], actionListener);
                panel.add((Component)button, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            button = new BGButton("0", "0", actionListener);
            panel.add((Component)button, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            button = new BGButton("C", "C", actionListener);
            panel.add((Component)button, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        public int getPageIndex() {
            return Utils.parseInt(this.pageIndexField.getText(), this.pageIndex);
        }

        public void setPageIndex(int pageIndex) {
            this.pageIndex = pageIndex;
            this.pageIndexField.setText(String.valueOf(pageIndex));
        }

        public int getPageSize() {
            return Utils.parseInt(this.pageSizeField.getText(), this.pageSize);
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
            this.pageSizeField.setText(String.valueOf(pageSize));
        }
    }
}

