/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.hd.client.ContractPackageEditor;
import ru.bitel.bgbilling.modules.hd.client.PackageEditorPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ContractPackageHostingEditor
extends PackageEditorPanel
implements ActionListener {
    private DefaultListModel<String> listModel = new DefaultListModel();
    private JList<String> hostList = new JList<String>(this.listModel);
    private BGDialogToolBar toolBar = new BGDialogToolBar();
    private BGTextField hostTf = new BGTextField();
    private JPanel editor = new JPanel(new GridBagLayout());
    private int hostingHost;

    public ContractPackageHostingEditor(ContractPackageEditor serviceEditor) {
        this.jbInit();
        this.editor.setVisible(false);
    }

    private void jbInit() {
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        this.toolBar.setDefaultButtons((ActionListener)this);
        this.toolBar.setToolBar(new String[]{"newItem", "deleteItem"});
        this.toolBar.setFloatable(false);
        this.toolBar.setOrientation(1);
        this.editor.add((Component)new JLabel("\u0425\u043e\u0441\u0442: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.editor.add((Component)this.hostTf, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.editor.add((Component)okCancel, new GridBagConstraints(0, 1, 6, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane(this.hostList), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.editor, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
    }

    @Override
    public void updateEditor(Element service) {
        this.hostingHost = Utils.parseInt((String)service.getAttribute("hosting_host"));
        boolean addEnable = this.hostingHost != 1;
        this.toolBar.setEnabled(addEnable);
        this.hostList.setEnabled(addEnable);
    }

    @Override
    public void update() {
        if (this.hostingHost == 1) {
            // empty if block
        }
    }

    private void stopEdit(boolean save) {
        String host;
        if (save && Utils.isBlankString((String)(host = this.hostTf.getText()))) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0445\u043e\u0441\u0442\u0430");
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == null) {
            return;
        }
        if (command.equals("newItem")) {
            this.newItem();
        } else if (command.equals("deleteItem")) {
            this.deleteItem();
        }
    }

    public void deleteItem() {
        int pos = this.hostList.getSelectedIndex();
        if (pos < 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0445\u043e\u0441\u0442!");
            return;
        }
        this.listModel.remove(pos);
    }

    public void newItem() {
        this.editor.setVisible(true);
        this.hostTf.setText("");
    }

    @Override
    public void setData(Element data) {
        this.listModel.removeAllElements();
        if (data != null) {
            try {
                Element hostListEl = XMLUtils.selectElement((Node)data, (String)"//hosting");
                NodeList list = hostListEl.getElementsByTagName("host");
                int size = list.getLength();
                for (int i = 0; i < size; ++i) {
                    Element hostEl = (Element)list.item(i);
                    this.listModel.addElement(hostEl.getAttribute("name"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void addToRequest(Request req) {
        StringBuilder hostingHost = new StringBuilder();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (hostingHost.length() == 0) {
                hostingHost.append(",");
            }
            hostingHost.append(this.listModel.get(i));
        }
        req.setAttribute("hosting_host", hostingHost.toString());
    }
}

