/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.client;

import bitel.billing.module.common.BGControlPanelPeriodNavigation;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.bean.ViewUploadFilesConfigurator;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.bgbilling.modules.sorm.common.service.ViewUploadedFilesService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

public class UploadedFilesViewerPanel
extends BGUPanel {
    private ViewUploadedFilesService viewUploadFilesService;
    private final JTextField pathToFile = new JTextField();
    private final JTextField lineCountsForProcessed = new JTextField();
    private final BGUComboBox<IdTitle> orientation = new BGUComboBox();
    private final JCheckBox isShowTitleOfFields = new JCheckBox("<html>\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0438\u043c\u0435\u043d\u0430 \u043f\u043e\u043b\u0435\u0439?<br>(\u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u041c\u0424\u0418\u0421\u043e\u0444\u0442 \u0438 \u0421\u043f\u0435\u0446.\u0422\u0435\u0445\u043d\u043e\u043b\u043e\u0433\u0438\u0439)</hmtl>");
    private final BGUComboBox<SormProject> sormProjects = new BGUComboBox();
    private final JButton search = new JButton("\u041f\u043e\u0438\u0441\u043a \u0444\u0430\u0439\u043b\u043e\u0432");
    private final JLabel findedFilesLabel = new JLabel("\u041d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u044b");
    private final BGUList<IdTitle> findedFiles = new BGUList();
    private final BGTextField searchField = new BGTextField(30);
    private JTextArea fileData;
    private BGSplitPaneNoBorder splitPane;
    private final BGControlPanelPeriodNavigation periodPanel = new BGControlPanelPeriodNavigation();
    AbstractBGUPanel.AsyncAction<Window> searchFilesAction = new AbstractBGUPanel.AsyncAction<Window>("", "\u041d\u0430\u0439\u0442\u0438 \u0444\u0430\u0439\u043b\u044b"){

        protected Window doInBackground() throws Exception {
            Window waitwindow = ClientUtils.showWaitWindow((String)"\u041f\u043e\u0438\u0441\u043a...");
            waitwindow.setLocationRelativeTo(UploadedFilesViewerPanel.this.splitPane.getLeftComponent());
            try {
                UploadedFilesViewerPanel.this.searchFiles();
            }
            catch (BGException e) {
                waitwindow.dispose();
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
            return waitwindow;
        }

        protected void done(Window result) throws Exception {
            if (result != null) {
                result.dispose();
            }
        }
    };

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.sormProjects.setData(((SormService)((ClientContext)this.getContext()).getPort(SormService.class, ((ClientContext)this.getContext()).getModuleId())).getSormProjects());
        this.orientation.addItem((Object)new IdTitle(0, "\u0413\u043e\u0440\u0438\u0437\u043e\u043d\u0442\u0430\u043b\u044c\u043d\u043e\u0439"));
        this.orientation.addItem((Object)new IdTitle(1, "\u0412\u0435\u0440\u0442\u0438\u043a\u0430\u043b\u044c\u043d\u043e\u0439"));
        final JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add("\u0423\u0434\u0430\u043b\u0438\u0442\u044c").addActionListener(e -> {
            if (BGSwingUtilites.confirmDelete((String)"\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u044b \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435")) {
                this.tryCall(() -> this.getService().deleteFiles(this.findedFiles.getSelectedValuesList().stream().map(IdTitle::getTitle).collect(Collectors.toList())));
                this.searchFilesAction.perform();
                if (this.fileData != null) {
                    this.fileData.setText("");
                }
            }
        });
        this.findedFiles.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                List selectedFiles;
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    UploadedFilesViewerPanel.this.openSelectedFile();
                } else if (e.getButton() == 3 && e.getClickCount() == 1 && Utils.notEmptyCollection((Collection)(selectedFiles = UploadedFilesViewerPanel.this.findedFiles.getSelectedValuesList()))) {
                    popupMenu.show((Component)UploadedFilesViewerPanel.this.findedFiles, e.getX(), e.getY());
                }
            }
        });
        this.search.addActionListener(e -> this.searchFilesAction.perform());
        this.splitPane = new BGSplitPaneNoBorder(1, (Component)this.configurePanel(), (Component)this.fileDataViewerPanel(), 300L);
        this.add((Component)this.splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel configurePanel() {
        JPanel configurePanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 3, 3, 3), 0, 0);
        configurePanel.add((Component)new JLabel("<html>\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043f\u0443\u0442\u044c \u0434\u043e \u0444\u0430\u0439\u043b\u0430<br>(\u0438\u043b\u0438 \u043e\u0441\u0442\u0430\u0432\u044c\u0442\u0435 \u043f\u043e\u043b\u0435 \u043f\u0443\u0441\u0442\u044b\u043c \u0434\u043b\u044f \u0430\u0432\u0442\u043e\u043f\u043e\u0438\u0441\u043a\u0430)</html>"), constraints);
        configurePanel.add((Component)this.pathToFile, constraints);
        configurePanel.add((Component)new JLabel("<html>\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043e\u043b-\u0432\u043e \u0441\u0442\u0440\u043e\u043a \u0434\u043b\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438<br>(\u0435\u0441\u043b\u0438 \u043d\u0435 \u043d\u0443\u0436\u043d\u043e \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0442\u044c \u0432\u0435\u0441\u044c \u0444\u0430\u0439\u043b)</html>"), constraints);
        configurePanel.add((Component)this.lineCountsForProcessed, constraints);
        configurePanel.add((Component)new JLabel("\u0421 \u043a\u0430\u043a\u043e\u0439 \u043e\u0440\u0438\u0435\u043d\u0442\u0430\u0446\u0438\u0435\u0439 \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442"), constraints);
        configurePanel.add((Component)this.orientation, constraints);
        configurePanel.add((Component)this.isShowTitleOfFields, constraints);
        configurePanel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u043e\u0435\u043a\u0442"), constraints);
        configurePanel.add((Component)this.sormProjects, constraints);
        configurePanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434"), constraints);
        configurePanel.add((Component)this.periodPanel, constraints);
        configurePanel.add((Component)this.search, constraints);
        configurePanel.add((Component)this.findedFilesLabel, constraints);
        this.isShowTitleOfFields.setSelected(true);
        JPanel fileListPanel = new JPanel(new GridBagLayout());
        configurePanel.add((Component)fileListPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane findedFilesScroll = new JScrollPane((Component)this.findedFiles);
        constraints.fill = 1;
        fileListPanel.add((Component)findedFilesScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JButton openFileButton = new JButton("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0444\u0430\u0439\u043b");
        openFileButton.addActionListener(e -> this.openSelectedFile());
        constraints.insets = new Insets(5, 0, 0, 0);
        fileListPanel.add((Component)openFileButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.searchField.setPromptText("\u041f\u043e\u0438\u0441\u043a \u043f\u043e enter...");
        this.searchField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                try {
                    if (e.getKeyCode() == 10) {
                        BGSwingUtilites.highlighText((JTextComponent)UploadedFilesViewerPanel.this.fileData, (String)UploadedFilesViewerPanel.this.searchField.getText());
                    }
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        });
        constraints.anchor = 16;
        fileListPanel.add((Component)this.searchField, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return configurePanel;
    }

    private JPanel fileDataViewerPanel() {
        JPanel dataViewerPanel = new JPanel(new GridBagLayout());
        this.fileData = new JTextArea();
        dataViewerPanel.add((Component)new JScrollPane(this.fileData), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return dataViewerPanel;
    }

    private void searchFiles() throws Exception {
        List<IdTitle> finded = this.search();
        if (Utils.notEmptyCollection(finded)) {
            this.findedFiles.setData(finded);
            this.findedFilesLabel.setText("\u041d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u044b (\u0424\u0430\u0439\u043b\u043e\u0432: " + finded.size() + ")");
        } else {
            BGToolTip.showMessage(this.findedFiles, (String)"\u0424\u0430\u0439\u043b\u044b \u043d\u0435 \u0431\u044b\u043b\u0438 \u043d\u0430\u0439\u0434\u0435\u043d\u044b");
            this.findedFilesLabel.setText("\u041d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u044b (\u0424\u0430\u0439\u043b\u043e\u0432: 0)");
            this.findedFiles.setData(Collections.emptyList());
            this.fileData.setText("");
        }
    }

    private List<IdTitle> search() throws Exception {
        String path = this.pathToFile.getText();
        if (Utils.notBlankString((String)path)) {
            return this.searchByPath(path);
        }
        if (this.sormProjects.getSelectedItem() != null) {
            return this.searchBySelectedProject((SormProject)this.sormProjects.getSelectedItem(), this.periodPanel.getPeriod());
        }
        ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043f\u0443\u0442\u044c \u0434\u043e \u0444\u0430\u0439\u043b\u0430 \u0438\u043b\u0438 \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u043e\u0435\u043a\u0442");
        return Collections.emptyList();
    }

    private List<IdTitle> searchByPath(String path) throws Exception {
        return this.getService().searchFilesByPath(path).stream().map(fileName -> new IdTitle(0, fileName)).collect(Collectors.toList());
    }

    private List<IdTitle> searchBySelectedProject(SormProject selectedProject, Period period) throws Exception {
        return this.getService().searchFilesBySormProject(selectedProject, period).stream().map(fileName -> new IdTitle(0, fileName)).toList();
    }

    private void openSelectedFile() {
        IdTitle selectedPathToFile = (IdTitle)this.findedFiles.getSelectedValue();
        if (selectedPathToFile == null || Utils.isBlankString((String)selectedPathToFile.getTitle())) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0444\u0430\u0439\u043b \u0434\u043b\u044f \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430");
            return;
        }
        try {
            String dataOfSelectedFile = this.getService().processUploadedFile(new ViewUploadFilesConfigurator().setSormProject((SormProject)this.sormProjects.getSelectedItem()).setPathToFile(selectedPathToFile.getTitle()).setProcessedLineLimit(Utils.parseInt((String)this.lineCountsForProcessed.getText(), (int)0)).setShowFieldTitles(this.isShowTitleOfFields.isSelected()).setPrintOrientation(((IdTitle)this.orientation.getSelectedItem()).getId()));
            this.fileData.setText(dataOfSelectedFile);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private ViewUploadedFilesService getService() {
        if (this.viewUploadFilesService == null) {
            this.viewUploadFilesService = (ViewUploadedFilesService)((ClientContext)this.getContext()).getPort(ViewUploadedFilesService.class);
        }
        return this.viewUploadFilesService;
    }
}

