/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rentsoft.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.rentsoft.common.bean.SubscribtionStatus;

public class SubscribtionStatusManager {
    private Connection con;
    private String tableName;

    public SubscribtionStatusManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "rentsoft_subscribtion_product_" + mid;
    }

    public void updateStatus(SubscribtionStatus status) throws BGException {
        try {
            String query = "UPDATE " + this.tableName + " SET status=? WHERE cid=? AND pid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, status.getStatus());
            ps.setInt(2, status.getContractId());
            ps.setInt(3, status.getProductId());
            int count = ps.executeUpdate();
            if (count == 0) {
                ps.close();
                query = "INSERT INTO " + this.tableName + " SET status=?, cid=?, pid=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, status.getStatus());
                ps.setInt(2, status.getContractId());
                ps.setInt(3, status.getProductId());
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
    }

    public List<SubscribtionStatus> getList(int cid) throws BGException {
        ArrayList<SubscribtionStatus> result = new ArrayList<SubscribtionStatus>();
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE cid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                SubscribtionStatus ss = new SubscribtionStatus();
                ss.setContractId(rs.getInt("cid"));
                ss.setProductId(rs.getInt("pid"));
                ss.setStatus(rs.getInt("status"));
                result.add(ss);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void deleteForContract(int cid) throws BGException {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE cid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
    }
}

