/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.task;

import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.Transport;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.IOException;
import java.util.Properties;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;

public class MailChecker
extends TaskBase {
    private static boolean flag = true;

    public String getDescription() {
        return null;
    }

    protected boolean initTask() {
        return flag;
    }

    protected void executeTask() {
        flag = false;
        Properties mailProps = new Properties();
        mailProps.put("mail.store.protocol", this.taskSetup.get("mail.store.protocol", "pop3"));
        mailProps.put("mail.debug", (Object)this.taskSetup.get("mail.debug", "0").equals("1"));
        Session session = Session.getDefaultInstance((Properties)mailProps);
        try {
            Store store = session.getStore();
            store.connect(this.taskSetup.get("mail.host", "mail.mydomail.ru"), this.taskSetup.get("mail.user", "myaccount"), this.taskSetup.get("mail.paasword", "password"));
            Folder folder = store.getFolder("INBOX");
            folder.open(2);
            for (int index = 1; index <= folder.getMessageCount(); ++index) {
                int errorCode = 0;
                String errorString = "";
                MimeMessage message = (MimeMessage)folder.getMessage(index);
                try {
                    errorCode = this.parseMessage(message);
                }
                catch (MessagingException ex) {
                    errorCode = 1;
                    errorString = ex.getLocalizedMessage();
                }
                catch (IOException ex) {
                    errorCode = 1;
                    errorString = ex.getLocalizedMessage();
                }
                this.sendReply(message, errorCode, errorString);
                message.setFlag(Flags.Flag.DELETED, true);
            }
            folder.expunge();
        }
        catch (NoSuchProviderException ex) {
            this.logError(ex);
        }
        catch (MessagingException ex) {
            this.logError(ex);
        }
        flag = true;
    }

    private int parseMessage(MimeMessage message) throws MessagingException, IOException {
        int errorCode = 0;
        if (errorCode == 0) {
            String contentType = message.getContentType();
            if (contentType.startsWith("multipart/")) {
                Object contentObject = message.getContent();
                if (contentObject instanceof MimeMultipart) {
                    MimeMultipart mimeMultipart = (MimeMultipart)contentObject;
                    for (int multipartIndex = 0; multipartIndex < mimeMultipart.getCount(); ++multipartIndex) {
                        MimeMessage attachMessage;
                        Object attachContentObject;
                        Object partContentObject;
                        BodyPart part = mimeMultipart.getBodyPart(multipartIndex);
                        String partContentType = part.getContentType();
                        if (partContentType.startsWith("message/rfc822") && (partContentObject = part.getContent()) instanceof MimeMessage && !((attachContentObject = (attachMessage = (MimeMessage)partContentObject).getContent()) instanceof MimeMultipart)) continue;
                    }
                } else {
                    errorCode = 3;
                }
            } else {
                errorCode = 3;
            }
        } else {
            errorCode = 1;
        }
        return errorCode;
    }

    private void sendReply(MimeMessage message, int errorCode, String errorMessage) {
        Session mailSession = null;
        Properties mailProps = new Properties();
        mailProps.put("mail.smtp.host", this.taskSetup.get("mail.smtp.host", "smtp.mydomain.ru"));
        mailProps.put("mail.smtp.port", this.taskSetup.get("mail.smtp.port", "25"));
        mailProps.put("mail.smtp.auth", this.taskSetup.get("mail.smtp.auth", "false"));
        mailProps.put("mail.debug", this.taskSetup.get("mail.debug", "false"));
        mailSession = "true".equalsIgnoreCase(mailProps.getProperty("mail.smtp.auth")) ? Session.getInstance((Properties)mailProps, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailChecker.this.taskSetup.get("mail.smtp.auth.user", "user"), MailChecker.this.taskSetup.get("mail.smtp.auth.password", "password"));
            }
        }) : Session.getInstance((Properties)mailProps);
        MimeMessage replyMessage = new MimeMessage(mailSession);
        StringBuilder subject = new StringBuilder();
        try {
            subject.append(message.getSubject());
            subject.append(" => ");
            if (errorCode == 0) {
                subject.append("OK");
                replyMessage.setText("");
            } else {
                subject.append("ERROR: [");
                subject.append(errorCode);
                subject.append("] ");
                subject.append(errorMessage);
                replyMessage.setText("");
            }
        }
        catch (MessagingException ex) {
            this.logError(ex);
        }
        try {
            Transport.send((Message)replyMessage);
        }
        catch (MessagingException ex) {
            this.logError(ex);
        }
    }

    public static void main(String[] args) throws Exception {
        Properties mailProps = new Properties();
        mailProps.put("mail.store.protocol", "pop3");
        mailProps.put("mail.pop3.host", "cat.ufamail.ru");
        mailProps.put("mail.imap.host", "cat.ufamail.ru");
        mailProps.put("mail.debug", "false");
        Session session = Session.getDefaultInstance((Properties)mailProps);
        Store store = session.getStore();
        store.connect("email.com", "email@email.com", "password");
        Folder folder = store.getFolder("INBOX");
        folder.open(2);
        for (int index = 1; index <= folder.getMessageCount(); ++index) {
            StringBuilder builder = new StringBuilder();
            MimeMessage message = (MimeMessage)folder.getMessage(index);
            if (!message.getContentType().startsWith("multipart/mixed;")) continue;
            String subject = message.getSubject();
            builder.append("subject = " + subject);
            Object contentObject = message.getContent();
            if (!(contentObject instanceof MimeMultipart)) continue;
            builder.append("; multipart = yes");
            MimeMultipart mimeMultipart = (MimeMultipart)contentObject;
            builder.append("; count = " + mimeMultipart.getCount());
            for (int multipartIndex = 0; multipartIndex < mimeMultipart.getCount(); ++multipartIndex) {
                BodyPart part = mimeMultipart.getBodyPart(multipartIndex);
                String partContentType = part.getContentType();
                if (!partContentType.startsWith("message/rfc822")) continue;
                builder.append("; part" + multipartIndex + " = " + partContentType);
                Object partContentObject = part.getContent();
                if (!(partContentObject instanceof MimeMessage)) continue;
                MimeMessage attachMessage = (MimeMessage)partContentObject;
                builder.append("; attachSubject = " + attachMessage.getSubject());
                Object attachContentObject = attachMessage.getContent();
                if (!(attachContentObject instanceof MimeMultipart)) continue;
            }
            System.out.println(builder.toString());
        }
    }
}

