/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseComponent;
import ru.bitel.bgbilling.modules.license.common.bean.enums.LicenseComponentCategory;
import ru.bitel.common.model.Id;

public class LicenseComponentDao
extends AbstractIdDao<LicenseComponent> {
    public LicenseComponentDao(Connection con, int moduleId) {
        super(con, moduleId, "lic_component");
    }

    public LicenseComponent getByName(String name) throws SQLException {
        LicenseComponent productItem = null;
        String query = "SELECT  *  FROM " + this.tableName + " WHERE  name=? ";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, name);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    productItem = this.getFromRS(rs);
                }
            }
        }
        return productItem;
    }

    public List<LicenseComponent> list() throws SQLException {
        return this.listImpl(null, null, "title", new Object[0]);
    }

    public List<LicenseComponent> listForProduct(int productId) throws SQLException {
        ArrayList<LicenseComponent> productItems = new ArrayList<LicenseComponent>();
        String query = "SELECT item.* FROM " + this.tableName + " as item  JOIN  lic_product_component_" + this.moduleId + " link ON item.id=link.component_id WHERE link.product_id=? ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, productId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    productItems.add(this.getFromRS(rs));
                }
            }
        }
        return productItems;
    }

    public List<LicenseComponent> list(int copyId, boolean showHidden, Boolean availableOnWeb) throws SQLException {
        ArrayList<LicenseComponent> productItems = new ArrayList<LicenseComponent>();
        StringBuilder query = new StringBuilder().append("SELECT ").append("pi.* ").append(" FROM ").append(this.tableName + " as pi ").append(" JOIN ").append(" lic_product_component_" + this.moduleId + " as pip ").append(" ON pip.component_id=pi.id ").append(" JOIN ").append(" lic_copy_" + this.moduleId + " as tc ").append(" ON tc.product_id=pip.product_id ").append(" WHERE ").append(" tc.id=? ");
        if (!showHidden) {
            query.append(" AND pi.type=0 ");
        }
        if (availableOnWeb != null) {
            query.append(" AND pi.available_on_web=").append(availableOnWeb);
        }
        query.append(" ORDER BY ");
        query.append(" pi.title ");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, copyId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    productItems.add(this.getFromRS(rs));
                }
            }
        }
        return productItems;
    }

    protected LicenseComponent getFromRS(ResultSet rs) throws SQLException {
        return LicenseComponent.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setName(rs.getString("name")).setComment(rs.getString("comment")).setType(rs.getInt("type")).setUnlimited(rs.getInt("unlimited")).setAvailableOnWeb(rs.getBoolean("available_on_web")).setLastUpdate((Date)rs.getDate("lu")).setCategory(LicenseComponentCategory.getComponentCategoryByCode((int)rs.getInt("category_id"))).setTariffGroupId(rs.getInt("tariff_group_id")).build();
    }

    protected void updateImpl(LicenseComponent component) throws SQLException {
        String querySet = "name=?, title=?, category_id=?, tariff_group_id=?, comment=?, type=?, unlimited=?, available_on_web=?";
        try (PreparedStatement ps = this.prepareStatement((Id)component, querySet);){
            int index = 1;
            ps.setString(index++, component.getName());
            ps.setString(index++, component.getTitle());
            ps.setInt(index++, component.getCategory().getCode());
            ps.setInt(index++, component.getTariffGroupId());
            ps.setString(index++, component.getComment());
            ps.setInt(index++, component.getType());
            ps.setInt(index++, component.getUnlimited());
            ps.setBoolean(index++, component.isAvailableOnWeb());
            this.executeUpdate((Id)component, index, ps);
        }
    }

    public void deleteComponents(int productId) throws SQLException {
        String query = "DELETE  FROM " + this.tableName + " WHERE  product_id=? ";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, productId);
            ps.executeUpdate();
        }
    }
}

