/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.client;

import bitel.billing.module.common.BGComboBox;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.object.client.ObjectEditor;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectType;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.ListItem;
import ru.bitel.common.model.SearchResult;

public class ContractObjectEditor
extends BGPanel
implements ActionListener {
    private static final String module = "contract.object";
    private CardLayout cardLayout = new CardLayout();
    private BGTextField filterTitle;
    private BGComboBox<ListItem> filterType;
    private BGControlPanelPages pages;
    private JLabel records;
    private ObjectEditor objectEditor;
    private final ContractObjectTableModel objectTableModel = new ContractObjectTableModel();
    private List<ObjectType> types;
    private List<Status> statusList = null;
    private ContractObjectService contractObjectService;
    private ContractStatusService contractStatusService = null;
    private BGUTable table;
    final JPopupMenu popupMenu = new JPopupMenu();

    public void build() {
        this.objectEditor = new ObjectEditor();
        this.objectEditor.addPropertyChangeListener(e -> {
            if ("statusUpdate".equals(e.getPropertyName())) {
                ContractObject contractObject = (ContractObject)((Object)((Object)this.objectTableModel.getSelectedRow()));
                if (contractObject != null) {
                    try {
                        ContractObject contractObjectUpdate = this.getContractObjectService().contractObjectGet(contractObject.getContractId(), contractObject.getId());
                        if (contractObjectUpdate != null) {
                            contractObject.setStatus(contractObjectUpdate.getStatus());
                            this.objectTableModel.fireTableDataChanged();
                            this.objectTableModel.setSelectedRow((Object)contractObject);
                        }
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            } else if ("toList".equals(e.getPropertyName())) {
                this.cardLayout.show((Container)((Object)this), "table");
            }
        });
        this.jbInit();
    }

    private void jbInit() {
        this.initTransferContractPopup(this.popupMenu, this.table, "MoveObject", "id", "oid");
        this.setLayout(this.cardLayout);
        this.add(this.getTablePanel(), "table");
        this.add((Component)((Object)this.objectEditor), "editor");
    }

    private JPanel getTablePanel() {
        this.table = new BGUTable((TableModel)((Object)this.objectTableModel));
        this.table.setSelectionMode(0);
        this.filterTitle = new BGTextField(20);
        this.filterType = new BGComboBox();
        this.pages = new BGControlPanelPages();
        this.pages.init();
        this.records = new JLabel();
        this.addListenersToComponets();
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons((ActionListener)this);
        toolBar.setToolBar(new String[]{"newItem", "copyItem", "deleteItem", "separator", "upItem", "downItem"});
        toolBar.setFloatable(false);
        toolBar.setOrientation(1);
        toolBar.compact();
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)this.filterTitle, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)new JLabel("\u0422\u0438\u043f: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        filterPanel.add((Component)this.filterType, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)this.records, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 20), 0, 0));
        filterPanel.add((Component)this.pages, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u041e\u0431\u044a\u0435\u043a\u0442\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 "));
        panel.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 10, 3, new Insets(30, 0, 0, 5), 0, 0));
        panel.add((Component)filterPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        return panel;
    }

    private void addListenersToComponets() {
        this.filterTitle.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                String title = ContractObjectEditor.this.filterTitle.getText();
                if (title != null && title.length() >= 3) {
                    ContractObjectEditor.this.pages.setPageIndex(1);
                    ContractObjectEditor.this.setData();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                String title = ContractObjectEditor.this.filterTitle.getText();
                if (title == null || title.length() == 0) {
                    ContractObjectEditor.this.pages.setPageIndex(1);
                    ContractObjectEditor.this.setData();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.filterTitle.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    ContractObjectEditor.this.pages.setPageIndex(1);
                    ContractObjectEditor.this.setData();
                }
            }
        });
        this.filterType.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                this.pages.setPageIndex(1);
                this.setData();
            }
        });
        this.pages.addPropertyChangeListener(event -> {
            if (event.getPropertyName().startsWith("to")) {
                this.setData();
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ContractObjectEditor.this.table.getSelectedRow() == ContractObjectEditor.this.table.rowAtPoint(e.getPoint())) {
                    if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1) {
                        ContractObjectEditor.this.popupMenu.show((Component)ContractObjectEditor.this.table, e.getX(), e.getY());
                    } else if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                        ContractObjectEditor.this.id = ((ContractObject)((Object)ContractObjectEditor.this.objectTableModel.getSelectedRow())).getId();
                        ContractObjectEditor.this.openObject();
                    }
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("upItem".equals(actionCommand)) {
            this.orderItem(true);
        } else if ("downItem".equals(actionCommand)) {
            this.orderItem(false);
        } else {
            super.actionPerformed(e);
        }
    }

    public void setData() {
        try {
            if (this.statusList == null) {
                try {
                    this.statusList = this.getContractStatusService().getStatusList(false);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                    this.statusList = new ArrayList<Status>();
                }
                this.objectEditor.setStatusList(this.statusList);
            }
            int typeId = -1;
            if (this.filterType.getItemCount() == 0) {
                DefaultComboBoxModel<IdTitle> model = new DefaultComboBoxModel<IdTitle>();
                model.addElement(new IdTitle(-1, "\u041b\u044e\u0431\u043e\u0439"));
                this.types = this.getContractObjectService().objectTypeList(false);
                for (ObjectType objectType : this.types) {
                    model.addElement(new IdTitle(objectType.getId(), objectType.getTitle()));
                }
                this.filterType.setModel(model);
            } else {
                typeId = ((ListItem)this.filterType.getSelectedItem()).getId();
            }
            SearchResult<ContractObject> searchResult = this.getContractObjectService().contractObjectTable(this.getContractId(), this.filterTitle.getText(), typeId, this.pages.getPage());
            this.objectTableModel.setData(searchResult.getList(), true);
            this.pages.setPage(searchResult.getPage());
            this.records.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + (searchResult != null ? searchResult.getPage().getRecordCount() : 0));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void deleteItem() {
        this.getObjectId();
        if (this.id != 0 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            try {
                this.getContractObjectService().contractObjectDelete(this.getContext().getContractId(), this.id);
                EventBus.publish((Object)new UpdateContractTreeEvent(0, this.getContractId()));
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
            this.setData();
            this.id = 0;
            this.objectEditor.setId(0);
            this.objectEditor.setData();
        }
    }

    public void copyItem() {
        this.getObjectId();
        if (this.id != 0) {
            int dialogResult = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043d\u0430 \u043d\u043e\u0432\u044b\u0439 \u043e\u0431\u044a\u0435\u043a\u0442?", "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", 0, 3);
            boolean clonePeriod = dialogResult == 0;
            try {
                this.getContractObjectService().contractObjectClone(this.getContext().getContractId(), this.id, clonePeriod);
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
            this.setData();
        }
    }

    public void editItem() {
        this.getObjectId();
        if (this.id != 0) {
            this.openObject();
        }
    }

    public void newItem() {
        new ObjectTypeSelectDialog("\u0412\u044b\u0431\u043e\u0440 \u0442\u0438\u043f\u0430 \u043d\u043e\u0432\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430", new IdTitle()).open();
    }

    public void orderItem(boolean up) {
        try {
            this.getObjectId();
            if (this.id != 0) {
                this.getContractObjectService().contractObjectOrder(this.getContext().getContractId(), this.id, up);
            }
            this.setData();
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private void getObjectId() {
        this.id = ((ContractObject)((Object)this.objectTableModel.getSelectedRow())).getId();
        if (this.id == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0431\u044a\u0435\u043a\u0442!");
        }
    }

    public void init(String module, int mid) {
        super.init(module, mid);
        this.objectEditor.init(module, mid);
        this.objectEditor.setContractObjectEditor(this);
    }

    public void setContractId(int id) {
        super.setContractId(id);
        this.objectEditor.setContractId(id);
    }

    private void openObject() {
        if (this.id != 0) {
            this.objectEditor.setId(this.id);
            this.objectEditor.setData();
            this.cardLayout.show((Container)((Object)this), "editor");
        }
    }

    private ContractStatusService getContractStatusService() {
        if (this.contractStatusService == null) {
            this.contractStatusService = (ContractStatusService)this.getContext().getWebService(ContractStatusService.class, 0);
        }
        return this.contractStatusService;
    }

    public void selectedTypeForNewObject(int typeId) {
        try {
            ContractObject contractObject = new ContractObject();
            contractObject.setTypeId(typeId);
            contractObject.setContractId(this.getContractId());
            int newId = this.contractObjectService.contractObjectUpdate(this.getContext().getContractId(), contractObject);
            contractObject.setId(newId);
            this.id = newId;
            this.setData();
            this.objectTableModel.setSelectedRow((Object)((ContractObject)this.objectTableModel.getRows().stream().filter(a -> a.getId() == newId).findFirst().orElse(null)));
            EventBus.publish((Object)new UpdateContractTreeEvent(0, this.getContractId()));
            this.openObject();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public ContractObjectTableModel getObjectTableModel() {
        return this.objectTableModel;
    }

    private ContractObjectService getContractObjectService() {
        if (this.contractObjectService == null) {
            this.contractObjectService = (ContractObjectService)this.getContext().getWebService(ContractObjectService.class, 0);
        }
        return this.contractObjectService;
    }

    class ContractObjectTableModel
    extends BGTableModel<ContractObject> {
        private Status contractStatus;

        public ContractObjectTableModel() {
            super(ContractObjectTableModel.class.getName());
            this.contractStatus = new Status();
            this.contractStatus.setId(-1);
            this.contractStatus.setTitle("\u0421\u0442\u0430\u0442\u0443\u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, "period", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0422\u0438\u043f", 150, 180, 200, "typeId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 150, 180, 200, "status", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValueAt(ContractObject contractObject, int column) throws Exception {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "period": {
                    return (contractObject.getDateFrom() != null ? TimeUtils.formatDate((Date)contractObject.getDateFrom()) : "...") + " - " + (contractObject.getDateTo() != null ? TimeUtils.formatDate((Date)contractObject.getDateTo()) : "...");
                }
                case "typeId": {
                    if (Utils.isEmptyCollection(ContractObjectEditor.this.types)) {
                        ContractObjectEditor.this.types = ContractObjectEditor.this.getContractObjectService().objectTypeList(false);
                    }
                    return ContractObjectEditor.this.types.stream().filter(t -> t.getId() == contractObject.getTypeId()).findAny().map(IdTitle::getTitle).orElse("<\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d>");
                }
                case "status": {
                    return ContractObjectEditor.this.statusList.stream().filter(a -> a.getId() == contractObject.getStatus()).findFirst().map(a -> a.getGuiTitle()).orElseGet(() -> contractObject.getStatus() == -1 ? "\u0421\u0442\u0430\u0442\u0443\u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430" : "??? [#" + contractObject.getStatus() + "]");
                }
            }
            return super.getValueAt((Object)contractObject, column);
        }

        public void setSelectedRows(List<ContractObject> selected) {
            ListSelectionModel selectionModel = this.table.getSelectionModel();
            selectionModel.clearSelection();
            if (Utils.notEmptyCollection(selected)) {
                selectionModel.setValueIsAdjusting(true);
                Set set = selected.stream().filter(Objects::nonNull).mapToInt(Id::getId).boxed().collect(Collectors.toSet());
                int size = this.getRowCount();
                for (int i = 0; i < size; ++i) {
                    if (!set.contains(((ContractObject)((Object)this.getRows().get(i))).getId())) continue;
                    if (this.table.getRowSorter() != null) {
                        int row = this.table.getRowSorter().convertRowIndexToView(i);
                        selectionModel.addSelectionInterval(row, row);
                        continue;
                    }
                    selectionModel.addSelectionInterval(i, i);
                }
                selectionModel.setValueIsAdjusting(false);
            }
        }
    }

    class ObjectTypeSelectDialog
    extends BGEditorDialog<IdTitle> {
        private JCheckBox showHiddenCB;
        private BGUList<IdTitle> typeList;

        public ObjectTypeSelectDialog(String title, IdTitle data) {
            super(title, (Object)data);
            this.showHiddenCB = new JCheckBox("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0441\u043a\u0440\u044b\u0442\u044b\u0435");
            this.typeList = new BGUList();
        }

        public void doDialogPanel() {
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane(this.typeList, (int)500, (int)300), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.showHiddenCB, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.showHiddenCB.setSelected(false);
            BGSwingUtilites.handleLDMouseClicked(this.typeList, e -> ((JButton)this.optionPane.getOptions()[0]).doClick());
            this.showHiddenCB.addActionListener(e -> this.loadTypeList());
            this.loadTypeList();
        }

        private void loadTypeList() {
            try {
                this.typeList.setData(ContractObjectEditor.this.getContractObjectService().objectTypeTitles(!this.showHiddenCB.isSelected()));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        public boolean doApply() throws Exception {
            IdTitle idTitle = (IdTitle)this.typeList.getSelectedValue();
            if (idTitle == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f!");
                return false;
            }
            ContractObjectEditor.this.selectedTypeForNewObject(idTitle.getId());
            return true;
        }
    }
}

