/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.client.contract;

import bitel.billing.module.services.ServicePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseCopy;
import ru.bitel.bgbilling.modules.license.common.service.LicenseService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBoxRefresh;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class ContractProductCopiesPanel
extends ServicePanel {
    private ProductCopyTableModel tableModel = new ProductCopyTableModel();
    private BGUTable tableCopies = new BGUTable((TableModel)((Object)this.tableModel));

    public ContractProductCopiesPanel() {
        this.jbInit();
    }

    public void setModuleData(String module, int moduleId, int contractId) {
        if (Utils.isEmptyString((String)this.module) || this.getModuleId() == -1 || this.getContractId() == -1) {
            this.module = module;
            this.setModuleId(moduleId);
            this.setContractId(contractId);
        }
    }

    public void jbInit() {
        this.tableCopies.setModel((TableModel)((Object)this.tableModel));
        this.setLayout(new BorderLayout());
        this.add(BGSwingUtilites.wrapBorder((JComponent)new JScrollPane((Component)this.tableCopies), (String)"\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"), "Center");
        BGSwingUtilites.handleLDMouseClicked((Component)this.tableCopies, e -> this.editItem());
    }

    public void newItem() {
        LicenseCopy copy = new LicenseCopy(-1).setLicenseName("").setComment("");
        new CopyEditorDialog("\u041d\u043e\u0432\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", copy).open();
    }

    public void editItem() {
        int row = this.tableCopies.getSelectedRow();
        if (row >= 0) {
            this.tryCall(() -> {
                int copyId = ((LicenseCopy)this.tableModel.getSelectedRow()).getId();
                LicenseCopy copy = ((LicenseService)this.getContext().getWebService(LicenseService.class, this.getModuleId())).copyGet(copyId);
                new CopyEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043a\u043e\u043f\u0438\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", copy).open();
            });
        }
    }

    public void deleteItem() {
        LicenseCopy copy = (LicenseCopy)this.tableModel.getSelectedRow();
        if (copy != null && ClientUtils.confirmDelete((Object)copy.getProductTitle())) {
            this.tryCall(() -> ((LicenseService)this.getContext().getWebService(LicenseService.class, this.getModuleId())).copyDelete(copy.getId(), this.getContractId()));
            this.setData();
        }
    }

    public void setData() {
        this.tryCall(() -> this.tableModel.setData(((LicenseService)this.getContext().getWebService(LicenseService.class, this.getModuleId())).copyList(this.getContractId())));
    }

    class ProductCopyTableModel
    extends BGTableModel<LicenseCopy> {
        public ProductCopyTableModel() {
            super(ProductCopyTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0440\u043e\u0434\u0443\u043a\u0442", 200, 200, 200, "productTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0412\u0435\u0440\u0441\u0438\u044f", 100, 100, 100, "productVersion", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430", 180, 180, 180, "date", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u0430\u0442", 200, 300, 400, "licenseName", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumnId();
        }
    }

    class CopyEditorDialog
    extends BGEditorDialog<LicenseCopy> {
        private BGTextField comment;
        private BGTextField licenseeName;
        private BGUComboBoxRefresh<IdTitle> availableProducts;

        public CopyEditorDialog(String title, LicenseCopy data) {
            super(title, (Object)data);
            this.comment = new BGTextField(40);
            this.licenseeName = new BGTextField(40);
            this.availableProducts = new BGUComboBoxRefresh();
        }

        public void doDialogPanel() {
            this.addFieldV("\u041f\u0440\u043e\u0434\u0443\u043a\u0442: ", (JComponent)this.availableProducts);
            this.addFieldV("\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u0430\u0442: ", (JComponent)this.licenseeName);
            this.addFieldV("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439: ", (JComponent)this.comment);
            this.availableProducts.setSupplier(() -> ((LicenseService)ContractProductCopiesPanel.this.getContext().getWebService(LicenseService.class, ContractProductCopiesPanel.this.getModuleId())).productTitles());
            this.availableProducts.refresh();
            this.licenseeName.setText(((LicenseCopy)this.data).getLicenseName());
            this.comment.setText(((LicenseCopy)this.data).getComment());
            this.availableProducts.setSelectedItem((Object)((LicenseCopy)this.data).getProductId());
            this.availableProducts.setEnabled(((LicenseCopy)this.data).getId() < 1);
        }

        public boolean doApply() throws Exception {
            if (this.availableProducts.getSelectedItem() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442");
                return false;
            }
            ((LicenseCopy)this.data).setProductId(((IdTitle)this.availableProducts.getSelectedItem()).getId()).setContractId(ContractProductCopiesPanel.this.getContractId()).setLicenseName(this.licenseeName.getText()).setComment(this.comment.getText());
            ((LicenseService)ContractProductCopiesPanel.this.getContext().getWebService(LicenseService.class, ContractProductCopiesPanel.this.getModuleId())).copyUpdate((LicenseCopy)this.data);
            ContractProductCopiesPanel.this.setData();
            return true;
        }
    }
}

