/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGControlPanelMonthAndDays;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Optional;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.common.XMLUtils;

public class WebLogTabLogon
extends BGUPanel {
    public static final String LOG_TYPE_OK = "ok";
    public static final String LOG_TYPE_ERROR = "error";
    private String logType = null;
    private BGControlPanelMonthAndDays period;
    private BGUTable table = new BGUTable(null);
    private BGDataSourceTableModel okTableModel = new BGDataSourceTableModel("WebLogonLogOk");
    private BGDataSourceTableModel errorTableModel = new BGDataSourceTableModel("WebLogonLogError");

    public WebLogTabLogon(String logType, BGControlPanelMonthAndDays period) {
        this.period = period;
        if (logType != null && LOG_TYPE_OK.equals(logType)) {
            this.logType = logType;
            this.table.setModel(this.okTableModel);
        } else if (logType != null && LOG_TYPE_ERROR.equals(logType)) {
            this.logType = logType;
            this.table.setModel(this.errorTableModel);
        } else {
            this.logType = null;
        }
    }

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public Document setQuery(int pageIndex, int pageSize, String date1, String date2, String conId, String filterQuery) {
        Document doc;
        Request request = new Request().setModule("admin").setAction("WebLogonLog").setPageIndex(pageIndex).setPageSize(pageSize).setAttribute("logType", this.logType).setAttribute("query_filter", filterQuery);
        Optional.ofNullable(date1).ifPresent(a -> request.setAttribute("date1", (String)a));
        Optional.ofNullable(date2).ifPresent(a -> request.setAttribute("date2", (String)a));
        if (conId != null && conId.length() > 0) {
            request.setAttribute("contracts", conId);
        }
        if (ClientUtils.checkStatus(doc = TransferManager.getDocument(request))) {
            Node node = XMLUtils.getNode(doc, "table");
        }
        BGUTableParams tableParams = new BGUTableParams().setPeriod(this.period.getPeriod());
        if (LOG_TYPE_OK.equals(this.logType)) {
            this.okTableModel.loadData(this.getKernelContext(), tableParams);
        } else if (LOG_TYPE_ERROR.equals(this.logType)) {
            this.errorTableModel.loadData(this.getKernelContext(), tableParams);
        }
        return doc;
    }

    public void clearTable() {
        if (LOG_TYPE_OK.equals(this.logType)) {
            this.okTableModel.deleteRows();
        } else if (LOG_TYPE_ERROR.equals(this.logType)) {
            this.errorTableModel.deleteRows();
        }
    }
}

