/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.action.web;

import bitel.billing.server.contract.bean.ContractServiceManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.ActionMessage;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Channel;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.PacketChannel;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.AddCheck;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardPacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.ChannelManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.PacketChannelManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.PacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.TariffRequestManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.dto.CardPacketDTO;
import ru.bitel.bgbilling.modules.cerbercrypt.server.dto.FutureSubscriptionDTO;
import ru.bitel.bgbilling.modules.cerbercrypt.server.dto.PacketDTO;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.ClosePacketSubscriptionEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.GetClosePacketDatesEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.GetOpenPacketDatesEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.OpenPacketSubscriptionEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.SubscriptionChangedEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.task.Recalculator;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.CollectionMapConverter;
import ru.bitel.common.model.Pair;

@WebAction(title="Cerbercrypt")
public class ActionCerbercrypt
extends AbstractAction {
    private Map<Integer, List<PacketChannel>> channelPacketMap = null;

    public ActionCerbercrypt() {
        super("cerbercrypt");
    }

    @WebOperation(title="\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u0430\u0440\u0442")
    public void list() throws Exception {
        try (UserCardManager userCardManager = new UserCardManager(this.con, this.moduleId, -1);){
            this.setResultParam("userCards", userCardManager.getList(this.contractId, false));
        }
        this.requestDispatcher(this.moduleName, "cerbercrypt_cards");
    }

    @WebOperation(title="\u0421\u043c\u0435\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u043a\u0430\u0440\u0442\u044b")
    public void password() throws Exception {
        this.requestDispatcher(this.moduleName, "cerbercrypt_password");
    }

    @WebOperation(title="\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430\u043c\u0438")
    public void subscription() throws Exception {
        GregorianCalendar now = new GregorianCalendar();
        try (UserCardManager userCardManager = new UserCardManager(this.con, this.moduleId, -1);){
            UserCard userCard = (UserCard)userCardManager.get(this.req.getInt("cardId", 0));
            if (userCard == null || userCard.getContractId() != this.contractId) {
                throw new BGException("card not found");
            }
            this.setResultParam("userCard", userCard);
            this.setResultParam("cardisactive", TimeUtils.checkDateIntervalsIntersection((Date)userCard.getDate1(), (Date)userCard.getDate2(), (Date)now.getTime(), (Date)now.getTime()) ? "1" : "0");
            TariffRequestManager tariffRequestManager = new TariffRequestManager(this.connectionSet, this.moduleId);
            Set<Integer> packetGroup = null;
            if (userCard != null && userCard.getContractId() == this.contractId) {
                packetGroup = tariffRequestManager.getPacketGroup((ParameterMap)this.moduleSetup, this.contractId, now);
            }
            List<PacketChannel> pc = new PacketChannelManager(this.con, this.moduleId).getPacketChannelList(now);
            Map mapPacketChannelList = new CollectionMapConverter<PacketChannel, Integer, Integer>(this){

                protected Pair<Integer, Integer> convert(PacketChannel f) {
                    return new Pair((Object)f.getPacketId(), (Object)f.getChannelId());
                }
            }.getMapOfList(pc);
            PacketManager packetManager = new PacketManager(this.con, this.moduleId);
            HashMap<Integer, Packet> packetMap = new HashMap<Integer, Packet>();
            ArrayList<PacketDTO> packetList = new ArrayList<PacketDTO>();
            for (Packet packet : packetManager.getPacketList()) {
                packetMap.put(packet.getId(), packet);
                if (!packet.isCanWebOpen() && !packet.isCanWebClose()) continue;
                PacketDTO packetDTO = PacketDTO.of(packet);
                packetDTO.setPacketGroup(packetGroup != null && packetGroup.contains(packet.getId()));
                List lpc = (List)mapPacketChannelList.get(packet.getId());
                packetDTO.setChannelCount(lpc != null ? lpc.size() : 0);
                packetList.add(packetDTO);
            }
            boolean isShowArchive = this.req.getBoolean("showarchive", false);
            CardPacketManager cardPacketManager = new CardPacketManager(this.con, this.moduleId);
            ArrayList<CardPacketDTO> cardPacketDTOList = new ArrayList<CardPacketDTO>();
            List<CardPacket> cardPacketList = cardPacketManager.getCardPacketList(this.contractId, userCard.getId(), isShowArchive ? null : new Date(), false);
            for (CardPacket cardPacket : cardPacketList) {
                boolean packetisactive = TimeUtils.checkDateIntervalsIntersection((Date)cardPacket.getDateFrom(), (Date)cardPacket.getDateTo(), (Date)now.getTime(), (Date)now.getTime());
                List lpc = (List)mapPacketChannelList.get(cardPacket.getPacketId());
                CardPacketDTO cardPacketDTO = CardPacketDTO.of(cardPacket);
                cardPacketDTO.setPacketTitle(((Packet)packetMap.get(cardPacket.getPacketId())).getTitle());
                cardPacketDTO.setPacketisactive(packetisactive);
                cardPacketDTO.setChannelCount(lpc != null ? lpc.size() : 0);
                cardPacketDTOList.add(cardPacketDTO);
            }
            HashMap<String, String> costMap = new HashMap<String, String>();
            ArrayList<FutureSubscriptionDTO> futureSubscriptions = new ArrayList<FutureSubscriptionDTO>();
            List<CardPacket> futureCardPacketList = cardPacketManager.getFutureCardPacketList(this.contractId, userCard.getId(), now.getTime());
            for (CardPacket cardPacket : futureCardPacketList) {
                Packet packet = (Packet)packetMap.get(cardPacket.getPacketId());
                if (packet == null || packet.isVirtualCinema()) continue;
                FutureSubscriptionDTO dto = new FutureSubscriptionDTO();
                dto.setId(cardPacket.getId());
                dto.setPacketId(cardPacket.getPacketId());
                dto.setPacketTitle(packet.getTitle());
                dto.setDateFrom(cardPacket.getDateFrom());
                dto.setDateTo(cardPacket.getDateTo());
                String dateString = TimeUtils.formatDate((Date)cardPacket.getDateFrom());
                String cost = (String)costMap.get(dateString);
                if (cost == null) {
                    Date date = cardPacket.getDateFrom();
                    List<CardPacket> cardPackets = cardPacketManager.getCardPacketList(this.contractId, cardPacket.getUsercardId(), date, false);
                    cost = Utils.formatCost((float)tariffRequestManager.getSubscriptionCost(this.contractId, date, packetMap, cardPackets, false));
                    costMap.put(dateString, cost);
                }
                dto.setCost(cost);
                futureSubscriptions.add(dto);
            }
            this.setResultParam("cardPacketList", cardPacketDTOList);
            this.setResultParam("cost", Utils.formatCost((float)tariffRequestManager.getSubscriptionCost(this.contractId, now.getTime(), packetMap, cardPacketList, false)));
            this.setResultParam("packetMap", packetMap);
            this.setResultParam("packetList", packetList);
            this.setResultParam("packetGroup", packetList.stream().allMatch(a -> a.isPacketGroup()));
            this.setResultParam("futureSubscriptions", futureSubscriptions);
            GetOpenPacketDatesEvent dateOpenListEvent = new GetOpenPacketDatesEvent(this.userId, this.moduleId, this.contractId, userCard.getId(), new Date());
            dateOpenListEvent = (GetOpenPacketDatesEvent)EventProcessor.getInstance().request((QueueEvent)dateOpenListEvent);
            if (dateOpenListEvent.getDateList() != null) {
                this.setResultParam("dateListOpen", dateOpenListEvent.getDateList());
            }
            GetClosePacketDatesEvent dateCloseListEvent = new GetClosePacketDatesEvent(this.userId, this.moduleId, this.contractId, userCard.getId(), new Date());
            dateCloseListEvent = (GetClosePacketDatesEvent)EventProcessor.getInstance().request((QueueEvent)dateCloseListEvent);
            if (dateCloseListEvent.getDateList() != null) {
                this.setResultParam("dateListClose", dateCloseListEvent.getDateList());
            }
            this.setResultParam("date", TimeUtils.format((Calendar)now, (String)"yyyy-MM-dd"));
        }
        this.requestDispatcher(this.moduleName, "cerbercrypt_subscription");
    }

    @WebOperation(title="\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0430\u043a\u0435\u0442 \u043d\u0430 \u043a\u0430\u0440\u0442\u0435")
    public void subscriptionChange() throws Exception {
        int usercardId = this.req.getInt("cardId", 0);
        ActionMessage message = new ActionMessage("cerbercryptRoot", "subscription", "cerbercryptQuery", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430");
        message.getQueryParamList().add(new KeyValue("cardId", String.valueOf(usercardId)));
        try {
            String msg = this.processCommand(usercardId, new GregorianCalendar(), false);
            if (Utils.notBlankString((String)msg)) {
                message.setText(msg);
            }
        }
        catch (BGMessageException ex) {
            message.setOnClose("close");
            message.setError(ex.getMessage());
        }
        this.setResultParam("message", message);
        this.requestDispatcher("include", "popup_message");
    }

    @WebOperation(title="\u0412\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u0438\u043d\u043e\u0442\u0435\u0430\u0442\u0440")
    public void virtualCinema() throws Exception {
        this.requestDispatcher(this.moduleName, "cerbercrypt_virtual_cinema");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String processCommand(int usercardId, Calendar now, boolean virtualCinema) throws BGException {
        String msg = "";
        UserCard userCard = null;
        try (UserCardManager userCardManager = new UserCardManager(this.con, this.moduleId, -1);){
            userCard = (UserCard)userCardManager.get(usercardId);
            if (userCard == null || userCard.getContractId() != this.contractId) {
                throw new BGException("card not found");
            }
        }
        PacketManager packetManager = new PacketManager(this.con, this.moduleId);
        HashMap<Integer, Packet> packetMap = new HashMap<Integer, Packet>();
        for (Packet packet : packetManager.getPacketList()) {
            packetMap.put(packet.getId(), packet);
        }
        CardPacketManager cardPacketManager = new CardPacketManager(this.con, this.moduleId);
        TariffRequestManager tariffRequestManager = new TariffRequestManager(this.connectionSet, this.moduleId);
        List<CardPacket> cardPacketList = Collections.unmodifiableList(cardPacketManager.getCardPacketList(this.contractId, userCard.getId(), now.getTime(), virtualCinema));
        List<CardPacket> futureCardPacketList = Collections.unmodifiableList(cardPacketManager.getFutureCardPacketList(this.contractId, userCard.getId(), now.getTime()));
        HashMap<Integer, CardPacket> cardPacketMap = new HashMap<Integer, CardPacket>();
        for (CardPacket cardPacket : cardPacketList) {
            cardPacketMap.put(cardPacket.getPacketId(), cardPacket);
        }
        HashMap<Integer, CardPacket> futureCardPacketMap = new HashMap<Integer, CardPacket>();
        for (CardPacket cardPacket : futureCardPacketList) {
            futureCardPacketMap.put(cardPacket.getPacketId(), cardPacket);
        }
        String string = this.req.get("command", null);
        if (!Utils.notBlankString((String)string)) return msg;
        if (string.equals("delete")) {
            int id = this.req.getInt("id", -1);
            CardPacket cardPacket = cardPacketManager.getCardPacketById(id);
            Packet packet = (Packet)packetMap.get(cardPacket.getPacketId());
            if (cardPacket == null || cardPacket.getContractId() != this.contractId || !TimeUtils.dateBefore((Date)now.getTime(), (Date)cardPacket.getDateFrom())) return msg;
            if (!this.checkCanRemovePacketWeb(cardPacketManager, packetMap, usercardId, packet, TimeUtils.convertDateToCalendar((Date)cardPacket.getDateFrom()), false)) {
                throw new BGMessageException("checkCanRemovePacketWeb = false");
            }
            cardPacketManager.deleteCardPacket(id);
            SubscriptionChangedEvent event = new SubscriptionChangedEvent(this.userId, this.moduleId, this.contractId, userCard.getId(), 2, 3, cardPacket.getPacketId(), null);
            this.context.publishAfterCommit((Event)event);
            return msg;
        }
        if (!string.equals("change")) return msg;
        int packetId = this.req.getInt("packetId", 0);
        Packet packet = (Packet)packetMap.get(packetId);
        if (packet == null || !packet.isCanWebOpen() && !packet.isCanWebClose()) {
            throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u043c \u043f\u0430\u043a\u0435\u0442\u043e\u043c \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u0447\u0435\u0440\u0435\u0437 WEB");
        }
        String type = this.req.get("type", "open");
        Calendar date = Calendar.getInstance();
        Date _fromDate = this.req.getDate("fromDate", "yyyy-MM-dd", date.getTime());
        if (_fromDate != null) {
            date.setTime(_fromDate);
        }
        String comment = this.req.get("comment", null);
        if (!virtualCinema) {
            if (packet.isVirtualCinema()) {
                throw new BGMessageException("packet.isVirtualCinema() = true");
            }
            if (userCard.getSubscrDate() == null) {
                throw new BGMessageException("\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u043e\u0439 \u043e\u0442 \u043b\u044e\u0431\u043e\u0439 \u0434\u0430\u0442\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e!");
            }
            if (!TimeUtils.dateBeforeOrEq((Date)userCard.getSubscrDate(), (Date)date.getTime())) {
                String datestr = TimeUtils.formatDate((Date)userCard.getSubscrDate());
                throw new BGMessageException("\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u043e\u0439 \u043e\u0442 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0439 \u0434\u0430\u0442\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e (\u043c\u043e\u0436\u043d\u043e \u0441 " + datestr + ")!");
            }
            if (type.equals("open")) {
                Object[] pkt;
                if (!packet.isCanWebOpen()) {
                    throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435\u043b\u044c\u0437\u044f \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0447\u0435\u0440\u0435\u0437 WEB");
                }
                if (TimeUtils.dateBefore((Calendar)date, (Calendar)now)) {
                    throw new BGMessageException("\u041f\u0430\u043a\u0435\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u043a\u0440\u044b\u0442 \u0440\u0430\u043d\u0435\u0435 \u0447\u0435\u043c \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0434\u0430\u0442\u043e\u0439!");
                }
                if (cardPacketManager.getCardPacket(usercardId, packetId, date.getTime()) != null) {
                    throw new BGMessageException("\u041f\u0430\u043a\u0435\u0442 \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442 \u043d\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u0434\u0430\u0442\u0443!");
                }
                AtomicReference<Date> date2 = new AtomicReference<Date>();
                try {
                    this.checkCanAddPacketWeb(cardPacketManager, packetMap, usercardId, packet, date, date2);
                }
                catch (BGException ex) {
                    throw new BGMessageException(ex.getMessage());
                }
                Set<Integer> packetGroup = tariffRequestManager.getPacketGroup((ParameterMap)this.moduleSetup, this.contractId, date);
                if (this.moduleSetup.getInt("cerbercrypt.cardpacket.addcheck", AddCheck.OPEN.getCode()) >= AddCheck.WEBADD.getCode() && (pkt = this.hasChannelFromPacket(cardPacketManager, packetMap, usercardId, packetId, date.getTime(), packetGroup)) != null) {
                    Packet pak = (Packet)pkt[0];
                    Channel c = (Channel)pkt[1];
                    throw new BGMessageException("\u041a\u0430\u043d\u0430\u043b " + (c != null ? c.getTitle() : "null") + " \u0432 \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c\u043e\u043c \u043f\u0430\u043a\u0435\u0442\u0435 " + packet.getTitle() + " \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442 \u0432 \u043f\u0430\u043a\u0435\u0442\u0435 " + pak.getTitle());
                }
                OpenPacketSubscriptionEvent eventOpenPacket = new OpenPacketSubscriptionEvent(this.userId, this.moduleId, this.contractId, userCard, packet, date.getTime());
                eventOpenPacket = (OpenPacketSubscriptionEvent)EventProcessor.getInstance().request((QueueEvent)eventOpenPacket);
                if (Utils.notBlankString((String)eventOpenPacket.getError())) {
                    throw new BGMessageException(eventOpenPacket.getError());
                }
                if (Utils.notBlankString((String)eventOpenPacket.getMessage())) {
                    msg = eventOpenPacket.getMessage();
                }
                if (eventOpenPacket.isProcessed()) return msg;
                CardPacket cardPacket = new CardPacket();
                cardPacket.setContractId(this.contractId);
                cardPacket.setUsercardId(usercardId);
                cardPacket.setPacketId(packetId);
                cardPacket.setDateFrom(TimeUtils.convertCalendarToDate((Calendar)date));
                if (comment != null) {
                    cardPacket.setComment(comment);
                }
                if (cardPacket.getDateFrom() == null && userCard.getDate1() != null || cardPacket.getDateTo() == null && userCard.getDate2() != null || cardPacket.getDateFrom() != null && userCard.getDate1() != null && TimeUtils.dateBefore((Date)cardPacket.getDateFrom(), (Date)userCard.getDate1()) || cardPacket.getDateTo() != null && userCard.getDate2() != null && TimeUtils.dateBefore((Date)userCard.getDate2(), (Date)cardPacket.getDateTo())) {
                    throw new BGMessageException("\u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043f\u0430\u043a\u0435\u0442\u0430 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043a\u0430\u0440\u0442\u044b");
                }
                try (UserCardManager userCardManager = new UserCardManager(this.con, this.moduleId, -1);){
                    cardPacketManager.openCardPackets((ParameterMap)this.moduleSetup, cardPacketManager, packetMap, this.contractId, usercardId, Collections.singletonList(cardPacket), now, true);
                    SubscriptionChangedEvent event = new SubscriptionChangedEvent(this.userId, this.moduleId, this.contractId, userCard.getId(), 2, 1, cardPacket.getPacketId(), TimeUtils.convertCalendarToDate((Calendar)date));
                    this.context.publishAfterCommit((Event)event);
                    userCardManager.updateSubscribe(date.getTime(), cardPacket.getUsercardId(), true);
                    return msg;
                }
                catch (Exception e) {
                    throw new BGMessageException(e.getMessage());
                }
            }
            if (!type.equals("close")) return msg;
            if (!packet.isCanWebClose()) {
                throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435\u043b\u044c\u0437\u044f \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u0447\u0435\u0440\u0435\u0437 WEB");
            }
            if (TimeUtils.dateBefore((Calendar)date, (Calendar)now)) {
                throw new BGMessageException("\u041f\u0430\u043a\u0435\u0442 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u043a\u0440\u044b\u0442 \u043d\u0435 \u0440\u0430\u043d\u0435\u0435 \u0447\u0435\u043c \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0434\u0430\u0442\u043e\u0439");
            }
            if (!this.checkCanRemovePacketWeb(cardPacketManager, packetMap, usercardId, packet, date, false)) {
                throw new BGMessageException("checkCanRemovePacketWeb = false");
            }
            ClosePacketSubscriptionEvent eventClosePacket = new ClosePacketSubscriptionEvent(this.userId, this.moduleId, this.contractId, userCard, packet, date.getTime());
            eventClosePacket = (ClosePacketSubscriptionEvent)EventProcessor.getInstance().request((QueueEvent)eventClosePacket);
            if (Utils.notBlankString((String)eventClosePacket.getError())) {
                throw new BGMessageException(eventClosePacket.getError());
            }
            if (Utils.notBlankString((String)eventClosePacket.getMessage())) {
                msg = eventClosePacket.getMessage();
            }
            if (eventClosePacket.isProcessed()) return msg;
            CardPacket cardPacket = cardPacketManager.getCardPacket(usercardId, packetId, date.getTime());
            if (cardPacket == null) throw new BGMessageException("\u041f\u0430\u043a\u0435\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u0443\u044e \u0434\u0430\u0442\u0443");
            cardPacket.setDateTo(TimeUtils.convertCalendarToDate((Calendar)date));
            if (comment != null) {
                cardPacket.setComment(comment);
            }
            cardPacketManager.updateCardPacket(cardPacket);
            SubscriptionChangedEvent event = new SubscriptionChangedEvent(this.userId, this.moduleId, this.contractId, userCard.getId(), 2, 2, packetId, TimeUtils.convertCalendarToDate((Calendar)date));
            this.context.publishAfterCommit((Event)event);
            return msg;
        }
        if (!packet.isVirtualCinema()) return msg;
        int virtualCinemaService = this.moduleSetup.getInt("cerbercrypt.virtual_cinema.serviceId", 0);
        if (virtualCinemaService > 0) {
            boolean can = false;
            List serviceList = new ContractServiceManager(this.con).getContractServiceList(this.contractId, (Calendar)new GregorianCalendar());
            for (ContractService s : serviceList) {
                if (s.getServiceId() != virtualCinemaService) continue;
                can = true;
                break;
            }
            if (!can) {
                throw new BGMessageException("\u0423\u0441\u043b\u0443\u0433\u0430 \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u0438\u043d\u043e\u0437\u0430\u043b \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430.");
            }
        }
        if (!type.equals("activate")) return msg;
        date = new GregorianCalendar();
        if (cardPacketManager.getCardPacket(usercardId, packetId, date.getTime()) != null) {
            throw new BGMessageException("\u0412\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u0438\u043d\u043e\u0437\u0430\u043b \u0443\u0436\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d!");
        }
        Calendar date2 = (Calendar)date.clone();
        date2.add(5, 1);
        CardPacket cardPacket = new CardPacket();
        cardPacket.setContractId(this.contractId);
        cardPacket.setUsercardId(usercardId);
        cardPacket.setPacketId(packetId);
        cardPacket.setDateFrom(TimeUtils.convertCalendarToDate((Calendar)date));
        cardPacket.setDateTo(TimeUtils.convertCalendarToDate((Calendar)date2));
        if (cardPacket.getDateFrom() == null && userCard.getDate1() != null || cardPacket.getDateTo() == null && userCard.getDate2() != null || cardPacket.getDateFrom() != null && userCard.getDate1() != null && TimeUtils.dateBefore((Date)cardPacket.getDateFrom(), (Date)userCard.getDate1()) || cardPacket.getDateTo() != null && userCard.getDate2() != null && TimeUtils.dateBefore((Date)userCard.getDate2(), (Date)cardPacket.getDateTo())) {
            throw new BGMessageException("\u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043f\u0430\u043a\u0435\u0442\u0430 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043a\u0430\u0440\u0442\u044b");
        }
        SubscriptionChangedEvent event = new SubscriptionChangedEvent(this.userId, this.moduleId, this.contractId, userCard.getId(), 2, 1, cardPacket.getPacketId(), TimeUtils.convertCalendarToDate((Calendar)date));
        this.context.publishAfterCommit((Event)event);
        float summ = tariffRequestManager.getSubscriptionCost(this.contractId, date.getTime(), packetMap, Collections.singletonList(cardPacket), true);
        BalanceUtils bu = new BalanceUtils(this.con);
        ContractDao contractDao = new ContractDao(this.con, 0);
        BigDecimal balance = bu.getBalance(date.getTime(), this.contractId);
        BigDecimal limit = ((Contract)contractDao.get(this.contractId)).getBalanceLimit();
        bu.close();
        contractDao.close();
        if (Float.isNaN(summ)) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043a\u0438\u043d\u043e\u0437\u0430\u043b\u0430.");
        }
        if (balance.floatValue() - summ < limit.floatValue()) {
            throw new BGMessageException("\u041d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0441\u0447\u0435\u0442\u0435 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438!");
        }
        if (cardPacket.getDateFrom() == null && userCard.getDate1() != null || cardPacket.getDateTo() == null && userCard.getDate2() != null || cardPacket.getDateFrom() != null && userCard.getDate1() != null && TimeUtils.dateBefore((Date)cardPacket.getDateFrom(), (Date)userCard.getDate1()) || cardPacket.getDateTo() != null && userCard.getDate2() != null && TimeUtils.dateBefore((Date)userCard.getDate2(), (Date)cardPacket.getDateTo())) {
            throw new BGMessageException("\u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043f\u0430\u043a\u0435\u0442\u0430 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043a\u0430\u0440\u0442\u044b");
        }
        cardPacketManager.updateCardPacket(cardPacket);
        new RunTaskDataManager(this.con).addTask((RunTask)new Recalculator(this.moduleId, TimeUtils.convertDateToCalendar((Date)cardPacket.getDateFrom()), null, String.valueOf(this.contractId), "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438"));
        return msg;
    }

    private void checkCanAddPacketWeb(CardPacketManager cpm, Map<Integer, Packet> packetMap, int usercardId, Packet packet, Calendar date, AtomicReference<Date> date2Ref) throws BGException {
        if (packet.getDepends().size() > 0 || packet.getUnacceptable().size() > 0) {
            List<CardPacket> currentPacketList = cpm.getCardPacketList(this.contractId, usercardId, date.getTime(), false);
            currentPacketList.addAll(cpm.getFutureCardPacketList(this.contractId, usercardId, date.getTime()));
            currentPacketList = Collections.unmodifiableList(currentPacketList);
            HashSet<Integer> currentPackets = new HashSet<Integer>();
            Date date2 = null;
            for (CardPacket cardPacket : currentPacketList) {
                currentPackets.add(cardPacket.getPacketId());
                if (cardPacket.getDateTo() == null || date2 != null && !date2.after(cardPacket.getDateTo())) continue;
                date2 = cardPacket.getDateTo();
            }
            date2Ref.set(date2);
            if (packet.getDepends().size() > 0 && Collections.disjoint(currentPackets, packet.getDepends())) {
                StringBuilder packets = new StringBuilder();
                for (Integer id : packet.getDepends()) {
                    Packet p = packetMap.get(id);
                    if (p != null) {
                        packets.append(p.getTitle()).append(", ");
                        continue;
                    }
                    this.getLogger().error("Depend packet id=" + id + " not found for packet id=" + packet.getId());
                }
                if (packets.length() > 0) {
                    packets.setLength(packets.length() - 2);
                }
                throw new BGMessageException("\u0414\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0430 \u043e\u0434\u0438\u043d \u0438\u0437 \u043f\u0430\u043a\u0435\u0442\u043e\u0432: " + packets.toString());
            }
            ArrayList unacceptable = new ArrayList(packet.getUnacceptable());
            unacceptable.retainAll(currentPackets);
            if (unacceptable.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Integer id : unacceptable) {
                    Packet p = packetMap.get(id);
                    if (p != null) {
                        stringBuilder.append(p.getTitle()).append(", ");
                        continue;
                    }
                    this.getLogger().error("Unacceptable packet not found=" + id + " for packet " + packet.getId());
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.setLength(stringBuilder.length() - 2);
                }
                throw new BGMessageException("\u0414\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0430\u043a\u0435\u0442\u044b: " + stringBuilder.toString());
            }
        }
    }

    private boolean checkCanRemovePacketWeb(CardPacketManager cpm, Map<Integer, Packet> packetMap, int usercardId, Packet packet, Calendar date, boolean groupReplace) throws BGException {
        Packet p;
        StringBuilder packets;
        List<CardPacket> currentPacketList = cpm.getCardPacketList(this.contractId, usercardId, date.getTime(), false);
        currentPacketList.addAll(cpm.getFutureCardPacketList(this.contractId, usercardId, date.getTime()));
        currentPacketList = Collections.unmodifiableList(currentPacketList);
        TariffRequestManager trm = new TariffRequestManager(this.connectionSet, this.moduleId);
        Set<Integer> packetGroup = trm.getPacketGroup((ParameterMap)this.moduleSetup, this.contractId, date);
        boolean result = true;
        StringBuilder errors = new StringBuilder();
        if (!groupReplace && packetGroup != null && packetGroup.contains(packet.getId())) {
            packetGroup.remove(packet.getId());
            packets = new StringBuilder();
            for (Integer id : packetGroup) {
                p = packetMap.get(id);
                if (p != null) {
                    packets.append(p.getTitle()).append(", ");
                    continue;
                }
                this.getLogger().error("Group packet not found=" + packet.getId());
            }
            if (packets.length() > 0) {
                packets.setLength(packets.length() - 2);
            }
            errors.append("\u0411\u0430\u0437\u043e\u0432\u044b\u0439 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0435\u0433\u043e \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0430 \u043e\u0434\u0438\u043d \u0438\u0437: " + packets.toString()).append(".");
            result = false;
        }
        packets = new StringBuilder();
        for (CardPacket cp : currentPacketList) {
            p = packetMap.get(cp.getPacketId());
            if (p != null) {
                if (!p.getDepends().contains(packet.getId())) continue;
                packets.append(p.getTitle()).append(", ");
                continue;
            }
            this.getLogger().error("Packet not found=" + cp.getPacketId() + " for cardPacket " + cp.getId());
        }
        if (packets.length() > 0) {
            packets.setLength(packets.length() - 2);
            if (errors.length() > 0) {
                errors.append(" ");
            }
            errors.append("\u041f\u0430\u043a\u0435\u0442 " + packet.getTitle() + " \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c \u0434\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0430\u043a\u0435\u0442\u044b: " + packets.toString() + ". \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0435 \u043f\u0430\u043a\u0435\u0442\u044b.");
            result = false;
        }
        if (errors.length() > 0) {
            throw new BGMessageException(errors.toString());
        }
        return result;
    }

    private Map<Integer, List<PacketChannel>> getChannelPacketMap(Map<Integer, Packet> packetMap) throws BGException {
        Map<Integer, List<PacketChannel>> result = this.channelPacketMap;
        if (result == null) {
            result = new HashMap<Integer, List<PacketChannel>>();
            PacketChannelManager pcm = new PacketChannelManager(this.con, this.moduleId);
            for (Packet p : packetMap.values()) {
                List<PacketChannel> pcList = pcm.getPacketChannelList(p.getId());
                result.put(p.getId(), pcList);
            }
            this.channelPacketMap = result;
        }
        return result;
    }

    private Object[] hasChannelFromPacket(CardPacketManager cpm, Map<Integer, Packet> packetMap, int usercardId, int packetId, Date now, Set<Integer> withoutPackets) throws BGException {
        Map<Integer, List<PacketChannel>> channelPacketMap = this.getChannelPacketMap(packetMap);
        List<PacketChannel> addSet = channelPacketMap.get(packetId);
        for (CardPacket cp : cpm.getCardPacketList(this.contractId, usercardId, now, false)) {
            List<PacketChannel> set = channelPacketMap.get(cp.getPacketId());
            if (set == null || withoutPackets != null && withoutPackets.contains(cp.getPacketId())) continue;
            for (PacketChannel i : addSet) {
                for (PacketChannel s : set) {
                    if (i.getChannelId() != s.getChannelId() || !TimeUtils.dateInRange((Date)now, (Date)s.getDateFrom(), (Date)s.getDateTo()) || !TimeUtils.dateInRange((Date)now, (Date)i.getDateFrom(), (Date)i.getDateTo())) continue;
                    Channel c = new ChannelManager(this.con, this.moduleId).getChannelById(i.getChannelId());
                    return new Object[]{packetMap.get(cp.getPacketId()), c};
                }
            }
        }
        return null;
    }
}

