/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.client;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.bgbilling.plugins.edo.client.ParamNestEditor;
import ru.bitel.bgbilling.plugins.edo.common.bean.EdoDocumentType;
import ru.bitel.bgbilling.plugins.edo.common.service.EdoDocumentTypeService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.function.Async;

public class ServiceConfigEdoDocumentType
extends BGUPanel {
    private BGUList<EdoDocumentType> edoDocumentTypeList = new BGUList();
    private DocumentEditor documentTypeEditor = new DocumentEditor();
    private JPanel rightPanel = new JPanel();
    private CardLayout cardLayout = new CardLayout();

    public ServiceConfigEdoDocumentType() {
        JPanel emptyPanel = new JPanel(new GridBagLayout());
        emptyPanel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442"), new GridBagConstraints());
        this.rightPanel.setLayout(this.cardLayout);
        this.rightPanel.add((Component)((Object)this.documentTypeEditor), "editor");
        this.rightPanel.add((Component)emptyPanel, "empty");
        this.cardLayout.show(this.rightPanel, "empty");
        ClientUtils.addOpenAction(this.edoDocumentTypeList, event -> this.performAction("edit"));
        ClientUtils.addShowCodeListener(this.edoDocumentTypeList);
        JSplitPane mainSplit = new JSplitPane();
        mainSplit.setDividerSize(4);
        mainSplit.setDividerLocation(200);
        mainSplit.setLeftComponent(new JScrollPane((Component)this.edoDocumentTypeList));
        mainSplit.setRightComponent(this.rightPanel);
        this.setLayout(new BorderLayout());
        this.add(mainSplit, "Center");
    }

    protected void jbInit() {
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.edoDocumentTypeList.setData(((EdoDocumentTypeService)((ClientContext)this.getContext()).getPort(EdoDocumentTypeService.class)).getEdoDocumentTypeList(true))));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> this.startEdit(0));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            EdoDocumentType li = (EdoDocumentType)this.edoDocumentTypeList.getSelectedValue();
            if (li != null) {
                this.startEdit(li.getId());
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            EdoDocumentType li = (EdoDocumentType)this.edoDocumentTypeList.getSelectedValue();
            if (li != null && ClientUtils.confirmDelete((Object)"\u0442\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430")) {
                if (li.isDefaultDocument()) {
                    ClientUtils.showErrorMessageDialog((String)("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c " + li.getTitle()));
                    return;
                }
                ((EdoDocumentTypeService)((ClientContext)this.getContext()).getPort(EdoDocumentTypeService.class)).deleteEdoDocumentType(li.getId());
                this.hideEditor();
            }
        });
    }

    private void startEdit(int id) {
        this.documentTypeEditor.setId(id);
        this.cardLayout.show(this.rightPanel, "editor");
        this.documentTypeEditor.performAction("refresh");
    }

    public void hideEditor() {
        this.cardLayout.show(this.rightPanel, "empty");
        this.performAction("refresh");
    }

    class DocumentEditor
    extends BGUPanel {
        private BGTextField fTitle = new BGTextField();
        private DynamicClassChooser fClass = new DynamicClassChooser(true);
        private JLabel fClassLabel = new JLabel("\u041a\u043b\u0430\u0441\u0441:");
        private ParamNestEditor fConfig = new ParamNestEditor(EdoDocumentType.STATIC_FIELDS);
        private int id;

        public DocumentEditor() {
            this.setLayout(new GridBagLayout());
            this.fClass.setIfaceName("ru.bitel.bgbilling.plugins.edo.server.bean.EdoBillFileGenerator");
            this.fClass.performAction("refresh");
            this.fClass.setNewClassPrefix("ru.bitel.bgbilling.modules.edo.dyn.");
            JButton okButton = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
            this.add(new JLabel("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.fTitle, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.add(this.fClassLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.fClass, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.add(new JScrollPane(this.fConfig), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.add(okButton, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 5), 0, 0));
            okButton.addActionListener(e -> ServiceConfigEdoDocumentType.this.performAction("ok"));
        }

        protected void jbInit() {
        }

        private void setDefaultDocumentMode(boolean isDefaultDocument) {
            this.fTitle.setEnabled(!isDefaultDocument);
            this.fClass.setVisible(!isDefaultDocument);
            this.fClassLabel.setVisible(!isDefaultDocument);
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
                if (this.id > 0) {
                    EdoDocumentType document = ((EdoDocumentTypeService)((ClientContext)this.getContext()).getPort(EdoDocumentTypeService.class)).getEdoDocumentType(this.id);
                    this.fTitle.setText(document.getTitle());
                    this.fClass.setSelectedItem(document.getClazz());
                    this.fConfig.setConfigText(document.getConfig());
                    this.setDefaultDocumentMode(document.isDefaultDocument());
                } else {
                    this.fTitle.setText("\u041d\u043e\u0432\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
                    this.fClass.clearSelection();
                    this.fConfig.setConfigText(null);
                    this.setDefaultDocumentMode(false);
                }
            });
            new AbstractBGUPanel.DefaultAction("ok", "OK"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    if (Utils.isBlankString((String)DocumentEditor.this.fTitle.getText())) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a!");
                        return;
                    }
                    if (Utils.isBlankString((String)DocumentEditor.this.fClass.getSelectedClass())) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043b\u0430\u0441\u0441!");
                        return;
                    }
                    EdoDocumentType document = new EdoDocumentType();
                    document.setId(DocumentEditor.this.id);
                    document.setTitle(DocumentEditor.this.fTitle.getText());
                    document.setClazz(DocumentEditor.this.fClass.getSelectedClass());
                    document.setConfig(DocumentEditor.this.fConfig.getConfigText());
                    ((EdoDocumentTypeService)((ClientContext)DocumentEditor.this.getContext()).getPort(EdoDocumentTypeService.class)).updateEdoDocumentType(document);
                    ServiceConfigEdoDocumentType.this.hideEditor();
                }
            };
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

