/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin;

import bitel.billing.module.admin.WebLogTabLogon;
import bitel.billing.module.admin.WebLogTabQuery;
import bitel.billing.module.common.BGControlPanelMonthAndDays;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.time.LocalDate;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.DialogContractSelect;
import ru.bitel.common.model.Page;

public class WebLogViewer
extends BGUPanel {
    private String conId = "";
    private WebLogTabQuery webLogTabQuery = null;
    private WebLogTabLogon webLogTabLogonOk = null;
    private WebLogTabLogon webLogTabLogonError = null;
    private JTextField contractMask = new JTextField();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private BGTextField filterQuery = new BGTextField();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGControlPanelMonthAndDays period = new BGControlPanelMonthAndDays();

    public WebLogViewer(ClientContext ctx) {
        super(ctx);
    }

    @Override
    protected void jbInit() {
        this.webLogTabQuery = new WebLogTabQuery(this.period, this.pagePanel);
        this.webLogTabLogonOk = new WebLogTabLogon("ok", this.period, this.pagePanel);
        this.webLogTabLogonError = new WebLogTabLogon("error", this.period, this.pagePanel);
        this.tabbedPane.add((Component)this.webLogTabQuery, "Web-\u0437\u0430\u043f\u0440\u043e\u0441\u044b");
        this.tabbedPane.add((Component)this.webLogTabLogonOk, "Web-\u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 (\u0443\u0441\u043f\u0435\u0448\u043d\u044b\u0435)");
        this.tabbedPane.add((Component)this.webLogTabLogonError, "Web-\u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 (\u0431\u0435\u0437\u0443\u0441\u043f\u0435\u0448\u043d\u044b\u0435)");
        this.tabbedPane.addChangeListener(e -> {
            this.pagePanel.init();
            this.webLogTabQuery.clearTable();
            this.webLogTabLogonOk.clearTable();
            this.webLogTabLogonError.clearTable();
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getPeriodPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getTopRigthPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.tabbedPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getPeriodPanel() {
        this.period.setDate(LocalDate.now());
        this.period.setBorder(BorderFactory.createTitledBorder(" \u041f\u0435\u0440\u0438\u043e\u0434 "));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.period, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTopRigthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getContractPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(Box.createVerticalStrut(5), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getPagesPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 15, 2, new Insets(-1, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getPagesPanel() {
        this.pagePanel.init();
        this.pagePanel.setKey(this.getClass().getName());
        this.pagePanel.addPropertyChangeListener(e -> this.pageChange(e));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getTextPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getShowButtonPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(1, 7, 0, 10), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 15, 2, new Insets(0, 0, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getTextPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0443:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.filterQuery, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getShowButtonPanel() {
        JButton showButton = new JButton("\u0412\u044b\u0432\u0435\u0441\u0442\u0438");
        showButton.setAlignmentX(0.0f);
        showButton.setMnemonic('0');
        showButton.setVerticalAlignment(0);
        showButton.addActionListener(e -> {
            this.pagePanel.init();
            this.setQuery();
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)showButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getContractPanel() {
        JButton contractMaskClear = new JButton("X");
        contractMaskClear.setMargin(new Insets(2, 2, 2, 2));
        contractMaskClear.addActionListener(e -> this.contractMaskClear_actionPerformed(e));
        JButton contractMaskFind = new JButton(">>>");
        contractMaskFind.setMargin(new Insets(2, 2, 2, 2));
        contractMaskFind.addActionListener(e -> this.contractMaskFind_actionPerformed(e));
        this.contractMask.setHorizontalAlignment(0);
        this.contractMask.setEnabled(true);
        this.contractMask.setDisabledTextColor(Color.black);
        this.contractMask.setEditable(false);
        this.contractMask.setColumns(20);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(" \u041a\u043e\u043d\u0442\u0440\u0430\u043a\u0442 "));
        panel.add((Component)this.contractMask, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)contractMaskClear, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)contractMaskFind, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        return panel;
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            this.pagePanel.init();
            this.setQuery();
        });
    }

    private void pageChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name != null && name.startsWith("to")) {
            this.setQuery();
        }
    }

    private void setQuery() {
        Document doc = null;
        int selectedTabIndex = this.tabbedPane.getSelectedIndex();
        if (selectedTabIndex == 0) {
            doc = this.webLogTabQuery.setQuery(this.conId, this.filterQuery.getText());
        } else if (selectedTabIndex == 1) {
            this.webLogTabLogonOk.setQuery(this.conId, this.filterQuery.getText());
        } else if (selectedTabIndex == 2) {
            this.webLogTabLogonError.setQuery(this.conId, this.filterQuery.getText());
        }
        if (doc != null) {
            int maxPages = Page.getPageCount(XMLUtils.getElement(doc, "table"));
            if (maxPages <= 0) {
                maxPages = 1;
            }
            this.pagePanel.setPageCount(maxPages);
        }
    }

    private void contractMaskClear_actionPerformed(ActionEvent e) {
        this.contractMask.setText("");
        this.conId = "";
    }

    private void contractMaskFind_actionPerformed(ActionEvent e) {
        String[] selected = null;
        DialogContractSelect dialog = new DialogContractSelect();
        dialog.setVisible(true);
        selected = dialog.getSelected();
        this.conId = selected[0];
        this.contractMask.setText(selected[1]);
        dialog.dispose();
    }
}

