/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGControlPanelMonthAndDays;
import bitel.billing.module.common.table.BGTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;

public class WebLogTabQuery
extends BGPanel {
    private BGControlPanelPages page;
    private BGControlPanelMonthAndDays period;
    private BGTable table = new BGTable();
    private JTextArea queryInfo = new JTextArea(3, 10);

    public WebLogTabQuery(BGControlPanelMonthAndDays period, BGControlPanelPages page) {
        this.module = "admin";
        this.page = page;
        this.period = period;
        try {
            this.initialize();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.table.getSelectionModel().addListSelectionListener(e -> {
            int index = this.table.getSelectedRow();
            if (!e.getValueIsAdjusting() && index > -1) {
                Object value = this.table.getValueAt(index, 4);
                this.queryInfo.setText(value.toString());
            }
        });
        this.table.setHeader(this.rb_name, this.moduleDoc, "web_log");
        this.queryInfo.setDisabledTextColor(Color.black);
        this.queryInfo.setEnabled(true);
        this.queryInfo.setEditable(false);
    }

    private void initialize() throws Exception {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(" \u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0443 "));
        jPanel.add((Component)new JScrollPane(this.queryInfo), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    public Document setQuery(String conId, String filterQuery) {
        Request request = new Request().setModule(this.module).setAction("WebQueryLogTable").setPage(this.page).setPeriod(this.period.getPeriod()).setAttribute("contracts", conId).setAttribute("query_filter", filterQuery);
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            Node node = XMLUtils.getNode(doc, "table");
            this.table.updateData(node);
        }
        this.queryInfo.setText("");
        return doc;
    }

    public void clearTable() {
        this.table.removeRows();
    }
}

