/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.action.apps;

import bitel.billing.server.contract.bean.ContractParameterManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.mobile.server.bean.AbstractAction;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrMultiList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

public class ActionContractParams
extends AbstractAction {
    public void execute() throws BGException {
        HashMap<Integer, EntityAttr> paramsMap = new HashMap<Integer, EntityAttr>();
        List reqTypeParams = this.req.getIntegerList("paramsIds", null);
        if (reqTypeParams != null && reqTypeParams.size() > 0) {
            try (ContractDao contractDao = new ContractDao(this.con, -1);){
                for (Integer pid : reqTypeParams) {
                    EntityAttr param;
                    ContractParameterGroupAttr groupAttr = (ContractParameterGroupAttr)this.context.getDirectory(ContractParameterGroupAttr.class, 0).get(pid.intValue());
                    if (groupAttr == null || !groupAttr.isCustomerRead() || (param = contractDao.getContractParameter(this.contractId, pid.intValue())) == null) continue;
                    paramsMap.put(pid, param);
                }
            }
        }
        this.actionMap.put("paramsMap", paramsMap);
    }

    public void contractGroupsParams() throws Exception {
        ArrayList list = new ArrayList();
        ArrayList listTypeWithoutValue = new ArrayList();
        HashMap mapOpt = new HashMap();
        int contractParamId = this.contract.getParamGroupId();
        try (ContractDao contractDao = new ContractDao(this.con, -1);){
            Map contractParameterMap = contractDao.getContractParameters(this.contractId, contractParamId);
            ContractParameterGroup parameterGroup = (ContractParameterGroup)this.context.getDirectory(ContractParameterGroup.class, 0).get(contractParamId);
            if (parameterGroup == null) {
                this.actionMap.put("paramGroupIsNull", "true");
                return;
            }
            parameterGroup.getAttributeList().stream().map(a -> (ContractParameterGroupAttr)a).filter(a -> a.isCustomerRead() || a.isCustomerWrite()).forEach(a -> {
                block12: {
                    final EntityAttr attr = (EntityAttr)contractParameterMap.get(a.getId());
                    if (attr != null && a.isCustomerRead()) {
                        HashMap<String, Object> paramFull = new HashMap<String, Object>(){
                            {
                                this.put("param", attr);
                                this.put("type", a);
                            }
                        };
                        list.add(paramFull);
                    } else if (a.isCustomerWrite()) {
                        listTypeWithoutValue.add(a);
                    }
                    if (a.isCustomerWrite()) {
                        try {
                            if (a.getType() == EntitySpecAttrType.LIST.getCode()) {
                                mapOpt.put(a.getId(), this.context.getDirectory(ContractParameterListItem.class, a.getId()).list());
                                break block12;
                            }
                            if (a.getType() != EntitySpecAttrType.MULTILIST.getCode()) break block12;
                            try (ContractParameterManager manager = new ContractParameterManager(this.con);){
                                mapOpt.put(a.getId(), manager.getMultiListValues(a.getId()));
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            });
        }
        this.actionMap.put("params", list);
        this.actionMap.put("withoutValue", listTypeWithoutValue);
        this.actionMap.put("optMap", mapOpt);
    }

    public void saveContractParameter() throws Exception {
        int id = this.req.getInt("id", -1);
        int typeId = this.req.getInt("typeId", -1);
        String value = this.req.get("value", null);
        int contractParamId = this.contract.getParamGroupId();
        ContractParameterGroup parameterGroup = (ContractParameterGroup)this.context.getDirectory(ContractParameterGroup.class, 0).get(contractParamId);
        ContractParameterGroupAttr specAttr = parameterGroup.getAttributeList().stream().map(a -> (ContractParameterGroupAttr)a).filter(a -> a.getId() == id).findFirst().orElse(null);
        if (specAttr == null || !specAttr.isCustomerWrite()) {
            throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e.");
        }
        EntityAttr entityAttr = null;
        try (ContractDao contractDao = new ContractDao(this.con, -1);){
            entityAttr = contractDao.getContractParameter(this.contractId, id);
            if (entityAttr == null) {
                entityAttr = EntityAttr.newInstance((int)typeId, (int)this.contractId, (int)id);
            }
            if (entityAttr instanceof EntityAttrText) {
                ((EntityAttrText)entityAttr).setValue(value);
            } else if (entityAttr instanceof EntityAttrDate) {
                ((EntityAttrDate)entityAttr).setValue(TimeUtils.parseDate((String)value, (String)"dd.MM.yyyy"));
            } else if (entityAttr instanceof EntityAttrPhone) {
                EntityAttrPhone phoneEn = (EntityAttrPhone)entityAttr;
                phoneEn.setContactList(new ArrayList());
                if (Utils.notBlankString((String)value)) {
                    JSONArray jsonAnswer = new JSONArray(value);
                    for (int i = 0; i < jsonAnswer.length(); ++i) {
                        JSONObject contact = jsonAnswer.getJSONObject(i);
                        String phoneContact = contact.optString("phone", null);
                        if (!Utils.notBlankString((String)phoneContact)) continue;
                        phoneEn.addContact(phoneContact, contact.optString("comment", null));
                    }
                }
            } else if (entityAttr instanceof EntityAttrEmail) {
                EntityAttrEmail emailEn = (EntityAttrEmail)entityAttr;
                emailEn.setContactList(new ArrayList());
                if (Utils.notBlankString((String)value)) {
                    JSONArray jsonAnswer = new JSONArray(value);
                    for (int i = 0; i < jsonAnswer.length(); ++i) {
                        JSONObject contact = jsonAnswer.getJSONObject(i);
                        String email = contact.optString("address", null);
                        if (!Utils.notBlankString((String)email)) continue;
                        emailEn.addContact(contact.optString("name", null), email);
                    }
                }
            } else if (entityAttr instanceof EntityAttrList) {
                EntityAttrList listEn = (EntityAttrList)entityAttr;
                int valueInt = Utils.parseInt((String)value, (int)-1);
                if (valueInt < 1) {
                    listEn.setCustomValue(this.req.get("customValue", null));
                }
                listEn.setValue(valueInt);
                listEn.setCustomValue("");
            } else if (entityAttr instanceof EntityAttrBoolean) {
                EntityAttrBoolean boolEn = (EntityAttrBoolean)entityAttr;
                boolEn.setValue(Utils.parseBoolean((String)value));
            } else if (entityAttr instanceof EntityAttrMultiList) {
                EntityAttrMultiList multi = (EntityAttrMultiList)entityAttr;
                multi.setValueList(new ArrayList());
                for (Integer item : Utils.toIntegerSet((String)value)) {
                    if (item <= 0) continue;
                    multi.getValueList().add(new IdTitle(item.intValue(), ""));
                }
                String custom = this.req.get("customValue", null);
                if (Utils.notBlankString((String)custom)) {
                    for (String cus : Utils.toList((String)custom)) {
                        if (!Utils.notBlankString((String)value)) continue;
                        multi.getValueList().add(new IdTitle(-1, cus));
                    }
                }
            }
            ContractService contractService = (ContractService)this.context.getService(ContractService.class, 0);
            contractService.contractParameterUpdate(this.contractId, entityAttr);
            entityAttr = contractDao.getContractParameter(this.contractId, id);
            this.actionMap.put("updatedValue", entityAttr);
        }
    }
}

