/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.license.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.util.Date;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.LicenseDataDTO;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.Storage;

public class LicenseData
implements Comparable<LicenseData> {
    private int id = -1;
    private boolean active = false;
    private Date createDate = new Date();
    private Storage storage = Storage.SERVER;
    private int count = 0;
    private String hash = "";
    private String encryptData = "";
    private String plainData = "";

    @Override
    public int compareTo(LicenseData licenseData) {
        int result = 0;
        if (licenseData != null) {
            int id = licenseData.getId();
            result = this.getId() < id ? -1 : (this.getId() == id ? 0 : 1);
        }
        return result;
    }

    @XmlAttribute
    public int getCount() {
        return this.count;
    }

    @XmlAttribute
    public Date getCreateDate() {
        return this.createDate;
    }

    public String getEncryptData() {
        return this.encryptData;
    }

    @XmlAttribute
    public String getHash() {
        return this.hash;
    }

    @XmlAttribute
    public int getId() {
        return this.id;
    }

    public String getPlainData() {
        return this.plainData;
    }

    @XmlAttribute
    public Storage getStorage() {
        return this.storage;
    }

    @XmlAttribute
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public void setEncryptData(String encryptData) {
        this.encryptData = encryptData;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setPlainData(String plainData) {
        this.plainData = plainData;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public LicenseDataDTO toLicenseDataDTO() {
        return LicenseDataDTO.builder().setId(this.id).setActive(this.active).setCount(this.count).setCreateDate(this.createDate).setHash(this.hash).setStorage(this.storage).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private LicenseData licenseData = new LicenseData();

        private Builder() {
        }

        public Builder setActive(boolean active) {
            this.licenseData.active = active;
            return this;
        }

        public Builder setCount(int count) {
            this.licenseData.count = count;
            return this;
        }

        public Builder setCreateDate(Date createDate) {
            this.licenseData.createDate = createDate;
            return this;
        }

        public Builder setEncryptData(String encryptData) {
            this.licenseData.encryptData = encryptData;
            return this;
        }

        public Builder setHash(String hash) {
            this.licenseData.hash = hash;
            return this;
        }

        public Builder setId(int id) {
            this.licenseData.id = id;
            return this;
        }

        public Builder setPlainData(String plainData) {
            this.licenseData.plainData = plainData;
            return this;
        }

        public Builder setStorage(Storage storage) {
            this.licenseData.storage = storage;
            return this;
        }

        public LicenseData build() {
            try {
                LicenseData licenseData = this.licenseData;
                return licenseData;
            }
            finally {
                this.licenseData = null;
            }
        }
    }
}

