/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelContractSelect;
import ru.bitel.bgbilling.client.common.BGControlPanelMonth;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoDay;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.modules.npay.common.service.NPayService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.model.Period;

public class NPayServiceConfigRecalculate
extends ServiceConfigTabbedPanel {
    private static final String MAIL_SEND_KEY = ".mail.send";
    private boolean filterInit = false;
    private JTextField commentTf = new JTextField();
    private JTextField protoEmail_TF = new JTextField();
    private BGComboBox<ComboBoxItem> serviceSetCombo = new BGComboBox();
    private boolean monthRange = this.setup.getInt("dbinfo.npay.recalc.month.range", 0) == 1;
    private JPanel periodPanel;
    private BGControlPanelContractSelect contractSelect = new BGControlPanelContractSelect();
    private JCheckBox detailCheckBox = new JCheckBox("\u0411\u0435\u0437 \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438");
    private JCheckBox mailSendCheckBox = new JCheckBox("\u0411\u0435\u0437 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f");
    private ContractLabelTree contractLabels = new ContractLabelTree();
    private ContractLabelService contractLabelService;

    public NPayServiceConfigRecalculate() {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)this.getContractLabelPanel(), (Component)this.getDataPanel(), 400L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getContractLabelPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" \u041c\u0435\u0442\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 "), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        panel.add((Component)new JScrollPane((Component)this.contractLabels), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getDataPanel() {
        this.periodPanel = this.monthRange ? new BGControlPanelPeriodNoDay() : new BGControlPanelMonth();
        this.periodPanel.setBorder(BorderFactory.createCompoundBorder((Border)new BGTitleBorder(" \u041f\u0435\u0440\u0438\u043e\u0434: "), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        JPanel serviceSetPanel = new JPanel(new GridBagLayout());
        serviceSetPanel.setBorder((Border)new BGTitleBorder(" \u041d\u0430\u0431\u043e\u0440 \u0443\u0441\u043b\u0443\u0433 "));
        serviceSetPanel.add((Component)this.serviceSetCombo, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.contractSelect.addWindowListenerForDialog((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                NPayServiceConfigRecalculate.this.contractLabels.setEnabled(Utils.isEmptyString((String)NPayServiceConfigRecalculate.this.contractSelect.getContracts()));
            }
        });
        BGSwingUtilites.handleMouseClicked((Component)this.contractSelect, e -> this.contractLabels.setEnabled(Utils.isEmptyString((String)this.contractSelect.getContracts())));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.periodPanel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)serviceSetPanel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.contractSelect, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getClearAndRecalcPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 11, 1, new Insets(20, 0, 0, 0), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getClearAndRecalcPanel() {
        JButton clearButton = new JButton("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c");
        clearButton.addActionListener(e -> this.clearAccountRequest());
        JPanel clearPanel = new JPanel(new GridBagLayout());
        clearPanel.setBorder((Border)new BGTitleBorder(" \u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0443 "));
        clearPanel.add((Component)clearButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 5, 5), 0, 0));
        clearPanel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridLayout(1, 2, 10, 10));
        panel.add(clearPanel);
        panel.add(this.getRecalcPanel());
        return panel;
    }

    private JPanel getRecalcPanel() {
        this.detailCheckBox.setToolTipText("\u041f\u0440\u0438 \u043a\u0430\u043b\u044c\u043a\u0443\u043b\u044f\u0446\u0438\u0438 \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c\u0441\u044f/\u0434\u043e\u043f\u043e\u043b\u043d\u044f\u0442\u044c\u0441\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430 npay_detail");
        this.mailSendCheckBox.setToolTipText("\u041f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043e\u0442\u0441\u044b\u043b\u0430\u0442\u044c\u0441\u044f \u043d\u0435 \u0431\u0443\u0434\u0435\u0442");
        this.mailSendCheckBox.addActionListener(e -> {
            this.protoEmail_TF.setEnabled(!this.mailSendCheckBox.isSelected());
            String key = ((Object)((Object)this)).getClass().getCanonicalName() + MAIL_SEND_KEY;
            ClientSetup.getInstance().getUserConfig().set(key, String.valueOf(this.mailSendCheckBox.isSelected()));
            ClientSetup.getInstance().saveUserConfig();
        });
        this.mailSendCheckBox.setSelected(ClientSetup.getInstance().getBoolean(((Object)((Object)this)).getClass().getCanonicalName() + MAIL_SEND_KEY, true));
        JPanel detailPanel = new JPanel();
        detailPanel.setBorder((Border)new BGTitleBorder(" \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u0435\u0440\u0435\u0440\u0430\u0441\u0447\u0435\u0442\u0430"));
        detailPanel.add(this.detailCheckBox);
        detailPanel.add(this.mailSendCheckBox);
        this.protoEmail_TF.setColumns(30);
        this.protoEmail_TF.setName("npay");
        this.protoEmail_TF.setEnabled(!this.mailSendCheckBox.isSelected());
        JButton runButton = new JButton("\u0417\u0430\u043f\u0443\u0441\u043a");
        runButton.addActionListener(e -> {
            this.saveUserEmail(this.module, this.protoEmail_TF.getText().trim());
            this.sendRecalculateRequest();
        });
        JPanel recalculatePanel = new JPanel(new GridBagLayout());
        recalculatePanel.setBorder((Border)new BGTitleBorder(" \u041f\u0443\u0441\u043a \u043f\u0435\u0440\u0435\u0441\u0447\u0435\u0442\u0430 "));
        recalculatePanel.add((Component)new JLabel("\u0412\u044b\u0441\u043b\u0430\u0442\u044c \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043d\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        recalculatePanel.add((Component)this.protoEmail_TF, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 5, 0, 5), 0, 0));
        recalculatePanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 5), 0, 0));
        recalculatePanel.add((Component)this.commentTf, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 5, 0, 5), 0, 0));
        recalculatePanel.add((Component)runButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)detailPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)recalculatePanel, new GridBagConstraints(0, -1, 4, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    public void init(String module, int moduleId) {
        super.init(module, moduleId);
        this.contractSelect.init(module, moduleId);
        if (this.monthRange) {
            BGControlPanelPeriodNoDay periodPanelNoDay = (BGControlPanelPeriodNoDay)this.periodPanel;
            periodPanelNoDay.setDateCalendar1((Calendar)new GregorianCalendar());
            periodPanelNoDay.setDateCalendar2((Calendar)new GregorianCalendar());
        }
    }

    public void setData() throws Exception {
        this.initFilterPanel();
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ServiceSetList");
        request.setModuleId(this.getModuleId());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildComboBox(this.serviceSetCombo, (Node)XMLUtils.selectElement((Node)doc, (String)"//list"), (String)"");
        }
        this.protoEmail_TF.setText(this.getUserEmail(this.module));
    }

    private void initFilterPanel() {
        if (!this.filterInit) {
            this.filterInit = true;
            try {
                this.contractLabels.setData(this.getContractLabelService().getContractLabelTreeItemList(-1, false));
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }
    }

    private void clearAccountRequest() {
        if (!ClientUtils.confirm((String)"\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0443?", (String)"\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0438")) {
            return;
        }
        if (Utils.isBlankString((String)this.contractSelect.getContracts()) && this.contractLabels.getSelectedIds().isEmpty() && !ClientUtils.confirm((String)"\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435: \u043e\u0447\u0438\u0441\u0442\u043a\u0430 \u0431\u0443\u0434\u0435\u0442 \u043f\u043e \u0432\u0441\u0435\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u043c!", (String)"\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0438")) {
            return;
        }
        try {
            ((NPayService)this.getContext().getWebService(NPayService.class)).accountClear(this.getPeriod(), Utils.toIntegerList((String)this.contractSelect.getContracts()), this.contractLabels.isEnabled() ? this.contractLabels.getSelectedIds() : new ArrayList(), Utils.parseInt((String)((String)((ComboBoxItem)this.serviceSetCombo.getSelectedItem()).getObject())));
            ClientUtils.showMessageDialog((Object)"\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0437\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 \u0443\u0434\u0430\u043b\u0435\u043d\u0430", (String)"\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0430");
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void sendRecalculateRequest() {
        String email = this.protoEmail_TF.getText();
        if (!this.mailSendCheckBox.isSelected() && Utils.isBlankString((String)email)) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u044f\u0449\u0438\u043a!");
            return;
        }
        if (Utils.isBlankString((String)this.contractSelect.getContracts()) && this.contractLabels.getSelectedIds().isEmpty() && !ClientUtils.confirm((String)"\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435: \u043f\u0435\u0440\u0435\u0441\u0447\u0451\u0442 \u0431\u0443\u0434\u0435\u0442 \u043f\u043e \u0432\u0441\u0435\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u043c!", (String)"\u041f\u0435\u0440\u0435\u0441\u0447\u0435\u0442")) {
            return;
        }
        try {
            ((NPayService)this.getContext().getWebService(NPayService.class)).recalculatePay(this.getPeriod(), Utils.toIntegerList((String)this.contractSelect.getContracts()), this.contractLabels.isEnabled() ? this.contractLabels.getSelectedIds() : new ArrayList(), Utils.parseInt((String)((String)((ComboBoxItem)this.serviceSetCombo.getSelectedItem()).getObject())), this.detailCheckBox.isSelected(), this.commentTf.getText(), this.mailSendCheckBox.isSelected() ? null : email);
            String message = "\u041f\u0435\u0440\u0435\u0441\u0447\u0435\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d" + (this.mailSendCheckBox.isSelected() ? "" : ", \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u0435 \u0431\u0443\u0434\u0435\u0442 \n\u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 EMail");
            ClientUtils.showMessageDialog((Object)message, (String)"\u041f\u0435\u0440\u0435\u0441\u0447\u0435\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d");
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private Period getPeriod() {
        if (this.monthRange) {
            BGControlPanelPeriodNoDay periodPanelNoD = (BGControlPanelPeriodNoDay)this.periodPanel;
            return new Period(periodPanelNoD.getDateFrom(), periodPanelNoD.getDateTo());
        }
        return new Period(((BGControlPanelMonth)this.periodPanel).getLocalDate(), ((BGControlPanelMonth)this.periodPanel).getLocalDate());
    }

    private ContractLabelService getContractLabelService() {
        if (this.contractLabelService == null) {
            this.contractLabelService = (ContractLabelService)this.getContext().getPort(ContractLabelService.class, 0);
        }
        return this.contractLabelService;
    }
}

