/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.worker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.worker.AccountingWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.AccountingWorkerTask;
import ru.bitel.bgbilling.apps.inet.accounting.worker.ConnectionAliveEventWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.EventTrackingWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.RestrictionTrackingWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.ServTrackingWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.SessionCountTrackingWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.SessionFinishWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.SessionFlushingWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.SessionTarifficationWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.SessionTrackingWorker;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.managed.ServerContextThreadFactory;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.worker.ThreadContextFactory;

public class AccountingWorkerSet
extends BGLogger
implements Lifecycle {
    private final Accounting accounting;
    private List<AccountingWorker> workers;

    public AccountingWorkerSet(Accounting accounting) {
        this.accounting = accounting;
    }

    public void start() throws BGException {
        this.getLogger().debug("Starting accounting workers");
        ServerContextThreadFactory threadContextFactory = new ServerContextThreadFactory(this.accounting.setup, this.accounting.moduleId, null, null);
        InetDeviceRuntime rootDeviceRuntime = this.accounting.deviceMap.get(this.accounting.rootDeviceId);
        ParameterMap config = rootDeviceRuntime.config;
        if (config.subIndexed("accounting.worker.").size() == 0) {
            this.getLogger().debug("Root device config doesn't contain accounting workers setup. Using defaults");
            Preferences defaults = new Preferences();
            defaults.set("accounting.worker.1.thread.count", "1");
            defaults.set("accounting.worker.1.tariffication.1.minDeltaAmount", "0");
            defaults.set("accounting.worker.1.tariffication.1.delay", "10");
            defaults.set("accounting.worker.1.tariffication.1.batchSize", "100");
            defaults.set("accounting.worker.1.tracking.1.delay", "20");
            defaults.set("accounting.worker.1.tracking.1.batchSize", "100");
            defaults.set("accounting.worker.2.thread.count", "1");
            defaults.set("accounting.worker.2.flushing.1.minDeltaAccount", "0");
            defaults.set("accounting.worker.2.flushing.1.delay", "20");
            defaults.set("accounting.worker.2.flushing.1.batchSize", "500");
            defaults.set("accounting.worker.3.thread.count", "1");
            defaults.set("accounting.worker.3.finishing.1.delay", "20");
            defaults.set("accounting.worker.3.finishing.1.batchSize", "500");
            config = defaults.inherit(config);
        }
        this.workers = new ArrayList<AccountingWorker>();
        boolean tariffication = false;
        boolean tracking = false;
        boolean flushing = false;
        boolean finishing = false;
        boolean sessionCountCheck = false;
        boolean restrictionCheck = false;
        boolean aliveEventGen = false;
        for (Map.Entry workerEntry : config.subKeyed("accounting.worker.").entrySet()) {
            ParameterMap params2;
            String threadName;
            String name = (String)workerEntry.getKey();
            ParameterMap workerParams = (ParameterMap)workerEntry.getValue();
            AccountingWorker worker = new AccountingWorker(name, workerParams, (ThreadContextFactory<ServerContext>)threadContextFactory);
            this.workers.add(worker);
            this.getLogger().info("Create worker: " + name);
            worker.init();
            worker.start();
            Map workerThreadParams = workerParams.subKeyed("tariffication.");
            ParameterMap defaultParams = (ParameterMap)workerThreadParams.getOrDefault("0", new ParameterMap.DefaultParameterMap(new HashMap()));
            workerThreadParams.remove("0");
            for (Map.Entry e : workerThreadParams.entrySet()) {
                threadName = (String)e.getKey();
                params2 = (ParameterMap)e.getValue();
                worker.addTask(threadName, new SessionTarifficationWorker(this.accounting, worker.service, "call", params2, defaultParams, this.accounting.connectionMapCall.values()));
                worker.addTask(threadName, new SessionTarifficationWorker(this.accounting, worker.service, "auto", params2, defaultParams, this.accounting.connectionMapAuto.iterable()));
                tariffication = true;
            }
            workerThreadParams = workerParams.subKeyed("tracking.");
            defaultParams = (ParameterMap)workerThreadParams.getOrDefault("0", new ParameterMap.DefaultParameterMap(new HashMap()));
            workerThreadParams.remove("0");
            for (Map.Entry e : workerThreadParams.entrySet()) {
                threadName = (String)e.getKey();
                params2 = (ParameterMap)e.getValue();
                worker.addTask(threadName, new SessionTrackingWorker(this.accounting, worker.service, "call", params2, defaultParams, this.accounting.connectionMapCall.values()));
                worker.addTask(threadName, new SessionTrackingWorker(this.accounting, worker.service, "auto", params2, defaultParams, this.accounting.connectionMapAuto.iterable()));
                tracking = true;
            }
            workerThreadParams = workerParams.subKeyed("flushing.");
            defaultParams = (ParameterMap)workerThreadParams.getOrDefault("0", new ParameterMap.DefaultParameterMap(new HashMap()));
            workerThreadParams.remove("0");
            for (Map.Entry e : workerThreadParams.entrySet()) {
                threadName = (String)e.getKey();
                params2 = (ParameterMap)e.getValue();
                worker.addTask(threadName, new SessionFlushingWorker(this.accounting, worker.service, "call", params2, defaultParams, this.accounting.connectionMapCall.values()));
                worker.addTask(threadName, new SessionFlushingWorker(this.accounting, worker.service, "auto", params2, defaultParams, this.accounting.connectionMapAuto.iterable()));
                flushing = true;
            }
            workerThreadParams = workerParams.subKeyed("finishing.");
            defaultParams = (ParameterMap)workerThreadParams.getOrDefault("0", new ParameterMap.DefaultParameterMap(new HashMap()));
            workerThreadParams.remove("0");
            for (Map.Entry e : workerThreadParams.entrySet()) {
                threadName = (String)e.getKey();
                params2 = (ParameterMap)e.getValue();
                worker.addTask(threadName, new SessionFinishWorker(this.accounting, worker.service, "call", params2, defaultParams, this.accounting.connectionMapCall.values()));
                worker.addTask(threadName, new SessionFinishWorker(this.accounting, worker.service, "auto", params2, defaultParams, this.accounting.connectionMapAuto.iterable()));
                finishing = true;
            }
            workerThreadParams = workerParams.subKeyed("event.alive.");
            defaultParams = (ParameterMap)workerThreadParams.getOrDefault("0", new ParameterMap.DefaultParameterMap(new HashMap()));
            workerThreadParams.remove("0");
            for (Map.Entry e : workerThreadParams.entrySet()) {
                threadName = (String)e.getKey();
                params2 = (ParameterMap)e.getValue();
                worker.addTask(threadName, new ConnectionAliveEventWorker(this.accounting, worker.service, "auto", params2, defaultParams, this.accounting.connectionMapAuto.iterable()));
                aliveEventGen = true;
            }
            this.addTasks("serv.tracking.", worker, workerParams, (accounting, workerService, params, defParams) -> new ServTrackingWorker((Accounting)((Object)accounting), (ScheduledExecutorService)workerService, (ParameterMap)params, (ParameterMap)defParams));
            this.addTasks("event.tracking.", worker, workerParams, (accounting, workerService, params, defParams) -> new EventTrackingWorker((Accounting)((Object)accounting), (ScheduledExecutorService)workerService, (ParameterMap)params, (ParameterMap)defParams));
            sessionCountCheck = this.addTasks("sessionCount.tracking.", worker, workerParams, (accounting, workerService, params, defParams) -> new SessionCountTrackingWorker((Accounting)((Object)accounting), (ScheduledExecutorService)workerService, (ParameterMap)params, (ParameterMap)defParams));
            restrictionCheck = this.addTasks("restriction.tracking.", worker, workerParams, (accounting, workerService, params, defParams) -> new RestrictionTrackingWorker((Accounting)((Object)accounting), (ScheduledExecutorService)workerService, (ParameterMap)params, (ParameterMap)defParams));
        }
        if (!tariffication) {
            this.getLogger().error("Tariffication worker not started. Check config!");
        }
        if (!tracking) {
            this.getLogger().error("Tracking worker not started. Check config!");
        }
        if (!flushing) {
            this.getLogger().error("Flushing worker not started. Check config!");
        }
        if (!finishing) {
            this.getLogger().error("Finishing worker not started. Check config!");
        }
        if (!(sessionCountCheck && restrictionCheck && aliveEventGen)) {
            Preferences params3;
            Preferences workerParams = new Preferences();
            workerParams.set("thread.count", "1");
            AccountingWorker worker = new AccountingWorker("system", (ParameterMap)workerParams, (ThreadContextFactory<ServerContext>)threadContextFactory);
            this.workers.add(worker);
            this.getLogger().info("Create worker system");
            worker.init();
            worker.start();
            ParameterMap.DefaultParameterMap dafaultParams = new ParameterMap.DefaultParameterMap(new HashMap());
            if (!sessionCountCheck) {
                params3 = new Preferences();
                params3.set("delay", "23");
                params3.set("batchSize", "1000");
                worker.addTask("sessionCountWorker", new SessionCountTrackingWorker(this.accounting, worker.service, (ParameterMap)params3, (ParameterMap)dafaultParams));
            }
            if (!restrictionCheck) {
                params3 = new Preferences();
                params3.set("delay", "23");
                params3.set("batchSize", "500");
                worker.addTask("restrictionWorker", new RestrictionTrackingWorker(this.accounting, worker.service, (ParameterMap)params3, (ParameterMap)dafaultParams));
            }
            if (!aliveEventGen) {
                params3 = new Preferences();
                params3.set("delay", "180");
                params3.set("batchSize", "250");
                worker.addTask("aliveEventGen", new ConnectionAliveEventWorker(this.accounting, worker.service, "auto", (ParameterMap)params3, (ParameterMap)dafaultParams, this.accounting.connectionMapAuto.iterable()));
            }
        }
    }

    private boolean addTasks(String prefix, AccountingWorker worker, ParameterMap workerParams, BuildAccountingWorkerTask<Accounting, ScheduledExecutorService, ParameterMap, ParameterMap> accountingWorkerTask) {
        boolean result = false;
        Map workerThreadParams = workerParams.subKeyed(prefix);
        ParameterMap dafaultParams = (ParameterMap)workerThreadParams.getOrDefault("0", new ParameterMap.DefaultParameterMap(new HashMap()));
        workerThreadParams.remove("0");
        for (Map.Entry e : workerThreadParams.entrySet()) {
            String threadName = (String)e.getKey();
            ParameterMap params = (ParameterMap)e.getValue();
            worker.addTask(threadName, accountingWorkerTask.build(this.accounting, worker.service, params, dafaultParams));
            result = true;
        }
        return result;
    }

    public void stop() throws InterruptedException {
        this.getLogger().debug("Stopping accounting workers....");
        for (AccountingWorker worker : this.workers) {
            worker.stop();
        }
        for (AccountingWorker worker : this.workers) {
            worker.destroy();
        }
        this.workers.clear();
        this.workers = null;
        this.getLogger().debug("... done");
    }

    static interface BuildAccountingWorkerTask<A, B, C, D> {
        public AccountingWorkerTask build(A var1, B var2, C var3, D var4);
    }
}

