/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action;

import au.com.bytecode.opencsv.CSVWriter;
import bitel.billing.server.ActionConType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.modules.bill.common.bean.BillListFilter;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.SortMode;
import ru.bitel.bgbilling.modules.bill.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.bill.server.bean.Bill;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Period;

@ActionConType(value=2)
public class ActionPreemptBill
extends ActionBase {
    private boolean saveOnServer;
    private String saveOnServerPath;
    private Writer writer;
    private char separator;
    private StringBuilder sb;

    public void doAction() throws Exception {
        BillListFilter billListFilter = new BillListFilter().setMonth(this.getIntParameter("m", -1)).setYear(this.getIntParameter("y", 0)).setAccountId(this.getIntParameter("account_id", 0)).setContractTitle(this.getParameter("contract", "")).setBillNumber(this.getParameter("billNumber", "")).setPackageParamId(this.getPackageParamId()).setPackageId(this.getIntParameter("package", -1)).setPage(this.getPage()).setPeriod(new Period(TimeUtils.convertStringToDate((String)this.getParameter("from", "")), TimeUtils.convertStringToDate((String)this.getParameter("until", "")))).setPrimarySortMode(this.getIntParameter("sort_mode", SortMode.CONTRACT.getCode())).setSecondarySortMode(this.getIntParameter("secondary_sort_mode", -1)).setAddressSortParamId(this.getAddressSortParamId()).setNameSortParam(this.getNameSortParamId()).setDateType(this.getIntParameter("date_type", 0)).setPayedType(this.getIntParameter("payed_type", 0)).setUserType(this.getIntParameter("user_type", 0));
        int unloadType = this.getIntParameter("unload_type", 0);
        int countOfBill = this.getIntParameter("countOfBill", 0);
        String groups = this.getParameter("gr", "");
        String groupMode = this.getParameter("gr_mode", "or");
        String type = this.getParameter("type", "");
        String preemptXSL = this.moduleSetup.get("preempt.bill.reestr.over.xsl", null);
        boolean forRegister = this.getIntParameter("forRegister", 0) == 1;
        boolean getXml = Utils.notBlankString((String)this.getParameter("get_xml"));
        this.saveOnServer = this.getBooleanParameter("saveOnServer", false);
        this.saveOnServerPath = this.moduleSetup.get("preempt.bill.reestr.to.server.path", null);
        this.separator = this.moduleSetup.get("csv.separator", ",").toCharArray()[0];
        BillManager billManager = new BillManager(this.conSlave, this.mid);
        ArrayList<String[]> allLines = new ArrayList<String[]>();
        this.sb = new StringBuilder();
        if (this.saveOnServer) {
            File file = new File(this.saveOnServerPath);
            this.writer = new OutputStreamWriter(new FileOutputStream(file));
        } else {
            this.writer = new StringWriter();
        }
        if (Utils.notBlankString((String)preemptXSL)) {
            if (preemptXSL.equals("true")) {
                preemptXSL = "bill_preempt_reestr.xsl";
            }
            getXml = true;
            int pageCount = (int)Math.ceil((double)countOfBill / 10.0);
            for (int i = 1; i <= pageCount; ++i) {
                billListFilter.getPage().setPageIndex(i);
                billListFilter.getPage().setPageSize(10);
                List<Bill> payBillList = billManager.getBillList(billListFilter, unloadType, groups, groupMode, getXml, type, forRegister);
                this.preemptBillNew(payBillList, preemptXSL);
            }
        } else {
            List<Bill> payBillList = billManager.getBillList(billListFilter, unloadType, groups, groupMode, getXml, type, forRegister);
            for (Bill bill : payBillList) {
                String[] line = new String[10];
                line[0] = bill.getContractTitle();
                line[1] = Utils.maskNull((String)bill.getRecipient());
                line[2] = Utils.maskNull((String)bill.getAddress());
                line[3] = Utils.maskNull((String)bill.getTypeTitle());
                line[4] = bill.getFormatNumber();
                line[5] = TimeUtils.formatDate((Date)bill.getCreateDate());
                line[6] = Utils.formatBigDecimalSumm((BigDecimal)bill.getSumm());
                allLines.add(line);
            }
            this.preemptBillOld(allLines);
        }
        Element data = this.createElement(this.rootNode, "data");
        data.setAttribute("file", this.sb.toString());
    }

    private void preemptBillNew(List<Bill> payBillList, String preemptXSL) {
        for (Bill bill : payBillList) {
            try {
                Document billDoc = bill.getDocument();
                if (billDoc != null) {
                    StreamResult sr = new StreamResult(this.writer);
                    XMLUtils.transform((Source)new DOMSource(billDoc), (Source)new StreamSource(new File("webroot/xsl/" + preemptXSL)), (Result)sr, (String)"UTF-8");
                    if (this.saveOnServer) continue;
                    this.sb.append(((StringWriter)this.writer).toString());
                    ((StringWriter)this.writer).getBuffer().setLength(0);
                    continue;
                }
                this.getLogger().error("XML is NULL, billNumber = {}", (Object)bill.getNumber());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void preemptBillOld(List<String[]> allLines) {
        try {
            CSVWriter csvWriter = new CSVWriter(this.writer, this.separator);
            csvWriter.writeAll(allLines);
            csvWriter.flush();
            csvWriter.close();
            if (this.saveOnServer) {
                this.writer.close();
            } else {
                this.sb.append(this.writer.toString());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

