/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import bitel.billing.server.contract.bean.Contract;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.events.MPSBeforeRequestEvent;
import ru.bitel.bgbilling.modules.mps.server.events.MPSSbrfSumEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class SbrfTransactionManager
extends MPSTransactionManager {
    public static final int RESPONSE_CODE_OK = 0;
    public static final int RESPONSE_CODE_ERROR_REPLACE_LATER = 1;
    public static final int RESPONSE_CODE_UNKNOWN_REQUEST_ACTION = 2;
    public static final int RESPONSE_CODE_CONTRACT_NOT_FOUND = 3;
    public static final int RESPONSE_CODE_INCORRECT_AMOUNT = 4;
    public static final int RESPONSE_CODE_ACCOUNT_OFF = 5;
    public static final int RESPONSE_CODE_INCORRECT_PAY_ID = 6;
    public static final int RESPONSE_CODE_TRANSFER_LOCK = 7;
    public static final int RESPONSE_CODE_DUBLICATE_TRANSACTION = 8;
    public static final int RESPONSE_CODE_SUM_INCORECT = 9;
    public static final int RESPONSE_CODE_SUM_MOST_SMALL = 10;
    public static final int RESPONSE_CODE_SUM_MOST_BIG = 11;
    public static final int RESPONSE_CODE_INCORRECT_PAY_DATE = 12;
    public static final int RESPONSE_CODE_INSIDE_ERROR = 300;
    private static final String RESPONSE_PARAM_FIO = "FIO";
    private static final String RESPONSE_PARAM_SUM = "SUM";
    private static final String RESPONSE_PARAM_REC_SUM = "REC_SUM";
    private static final String RESPONSE_PARAM_CODE = "CODE";
    private static final String RESPONSE_PARAM_INFO = "INFO";
    private static final String RESPONSE_PARAM_ADDRESS = "ADDRESS";
    private static final String RESPONSE_PARAM_MESSAGE = "MESSAGE";
    private static final String RESPONSE_PARAM_REG_DATE = "REG_DATE";
    private static final String RESPONSE_PARAM_BALANCE = "BALANCE";
    private static final String RESPONSE_PARAM_ACCOUNT_BALANCE = "ACCOUNT_BALANCE";
    private static final String TIME_FORMAT = "dd.MM.yyyy_HH:mm:ss";
    private DecimalFormat sumFormat = new DecimalFormat(){
        {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator('.');
            decimalFormatSymbols.setGroupingSeparator(' ');
            this.setDecimalFormatSymbols(decimalFormatSymbols);
            this.setGroupingUsed(false);
        }
    };

    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest request, HttpServletResponse response) {
        MPSResponse mpsResponse = new MPSResponse(moduleId, mpsId, response);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442");
            }
            MPSRequest mpsRequest = this.parseRequest(con, moduleId, mpsId, system, request);
            MPSBeforeRequestEvent mpsBeforeRequestEvent = new MPSBeforeRequestEvent(moduleId, mpsRequest, mpsResponse);
            EventProcessor.getInstance().request((QueueEvent)mpsBeforeRequestEvent);
            mpsResponse.setAction(mpsRequest.getAction());
            mpsResponse.getParameters().put("request", mpsRequest);
            switch (mpsRequest.getAction()) {
                case 1: {
                    this.getLogger().debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
                    Contract contract = this.actionCheck(mpsRequest);
                    this.getLogger().debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u043e\u043a. \u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0430\u0439\u0434\u0435\u043d, \u0441\u0443\u043c\u043c\u0430 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430.");
                    mpsResponse.setContract(contract);
                    mpsResponse.setResult(0);
                    mpsResponse.setMessage("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0430\u0439\u0434\u0435\u043d, \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u043f\u0440\u0438\u0435\u043c \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
                    StringBuilder value = new StringBuilder();
                    try (ContractDao contractDao = new ContractDao(con, 0);){
                        int paramId;
                        Iterator iterator = Utils.toIntegerList((String)system.config.get("fio")).iterator();
                        while (iterator.hasNext()) {
                            paramId = (Integer)iterator.next();
                            contractDao.optContractParameterTextAsString(contract.getId(), paramId).ifPresent(a -> value.append(value.length() > 0 ? " " : "").append((String)a));
                        }
                        if (value.length() > 0) {
                            mpsResponse.getParameters().put(RESPONSE_PARAM_FIO, value.toString());
                        }
                        value.setLength(0);
                        iterator = Utils.toIntegerList((String)system.config.get("address")).iterator();
                        while (iterator.hasNext()) {
                            paramId = (Integer)iterator.next();
                            contractDao.getContractParameterAddressAsString(contract.getId(), paramId).ifPresent(a -> value.append(value.length() > 0 ? "; " : "").append((String)a));
                        }
                        if (value.length() > 0) {
                            mpsResponse.getParameters().put(RESPONSE_PARAM_ADDRESS, value.toString());
                        }
                    }
                    if (system.config.get("sum") != null) {
                        try {
                            BigDecimal sum = new BigDecimal(system.config.get("sum"));
                            MPSSbrfSumEvent event = new MPSSbrfSumEvent(moduleId, sum);
                            event = (MPSSbrfSumEvent)EventProcessor.getInstance().request((QueueEvent)event);
                            BigDecimal scriptSum = event.getSum();
                            if (scriptSum != null) {
                                mpsResponse.getParameters().put(RESPONSE_PARAM_SUM, this.sumFormat.format(scriptSum).replace(" ", ""));
                                mpsResponse.getParameters().put(RESPONSE_PARAM_REC_SUM, this.sumFormat.format(scriptSum).replace(" ", ""));
                            }
                        }
                        catch (Exception e) {
                            this.getLogger().error("sum = " + system.config.get("sum"));
                            e.printStackTrace();
                        }
                    }
                    BalanceUtils balanceUtils = new BalanceUtils(con);
                    BigDecimal sum = balanceUtils.getBalance(LocalDate.now(), contract.getId());
                    mpsResponse.getParameters().put(RESPONSE_PARAM_BALANCE, this.sumFormat.format(sum));
                    mpsResponse.getParameters().put(RESPONSE_PARAM_ACCOUNT_BALANCE, this.sumFormat.format(sum));
                    balanceUtils.close();
                    break;
                }
                case 2: {
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction == null) {
                        this.getLogger().debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0438 \u0435\u0433\u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435.");
                        Contract contract = this.actionCheck(mpsRequest);
                        transaction = this.addTransaction(con, moduleId, mpsId, system, contract.getId(), mpsRequest.getTime(), mpsRequest.getSum(), mpsRequest.getTransId(), mpsRequest.getNumber(), mpsRequest.getType(), system.title);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u043e\u043a. \u041a\u043e\u0434 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 " + transaction.getId());
                        }
                        mpsResponse.setContract(contract);
                        mpsResponse.setResult(0);
                        mpsResponse.setMessage("");
                        mpsResponse.getParameters().put(RESPONSE_PARAM_REG_DATE, TimeUtils.format((Date)transaction.getLocalTime(), (String)TIME_FORMAT));
                        break;
                    }
                    throw new MPSException(8, "\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0443\u0436\u0435 \u0431\u044b\u043b \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440!");
                }
            }
        }
        catch (MPSException ex) {
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            this.getLogger().error("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage(), (Throwable)e);
            this.processError(new MPSException(-1), mpsResponse);
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        this.getLogger().debug("\u0420\u0430\u0437\u0431\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        MPSRequest result = new MPSRequest(con, moduleId, mpsId, request, system);
        String actionString = request.getParameter("ACTION");
        if ("check".equals(actionString)) {
            result.setAction(1);
        } else if ("payment".equals(actionString)) {
            result.setAction(2);
            String requestPayId = request.getParameter("PAY_ID");
            if (requestPayId == null || !requestPayId.matches("^\\d+$")) {
                throw new MPSException(6, "\u041d\u0435\u043a\u043e\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 PAY_ID");
            }
            result.setTransId(requestPayId);
            BigDecimal sum = Utils.parseBigDecimal((String)request.getParameter("AMOUNT"), (BigDecimal)BigDecimal.ZERO);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0443\u043c\u043c\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
                this.getLogger().debug("sum = {}; system.minSumm = {}; system.maxSumm = {}", new Object[]{sum, system.minSumm, system.maxSumm});
            }
            String currency = " " + Setup.getSetup().get("client.gui.currency.title.medium", "\u0440\u0443\u0431.");
            if (system.minSumm != null && sum.compareTo(system.minSumm) < 0) {
                throw new MPSException(10, "\u0421\u0443\u043c\u043c\u0430 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u0430\u043b\u0430 [min=" + String.valueOf(system.minSumm) + currency + "]");
            }
            if (system.maxSumm != null && sum.compareTo(system.maxSumm) > 0) {
                throw new MPSException(11, "\u0421\u0443\u043c\u043c\u0430 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0432\u0435\u043b\u0438\u043a\u0430 [max=" + String.valueOf(system.maxSumm) + currency + "]");
            }
            result.setSum(sum);
            Date payDate = TimeUtils.parseDate((String)request.getParameter("PAY_DATE"), (String)TIME_FORMAT);
            if (payDate == null) {
                throw new MPSException(12, "\u041d\u0435\u043a\u043e\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 PAY_DATE");
            }
            result.setTime(payDate);
        } else {
            throw new MPSException(2, "\u041d\u0435\u043a\u043e\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 ACTION");
        }
        result.setNumber(request.getParameter("ACCOUNT"));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u041f\u0440\u0438\u0448\u0435\u0434\u0448\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b - ACTION=" + actionString + "; ACCOUNT=" + result.getNumber() + "; AMOUNT=" + String.valueOf(result.getSum()) + "; PAY_ID=" + result.getTransId() + "; PAY_DATE=" + TimeUtils.format((Date)result.getTime(), (String)"dd.MM.yyyy HH:mm:ss"));
        }
        return result;
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case 3: {
                response.setResult(3);
                this.getLogger().debug("Error code = " + ex.error + "; error message = " + ex.message);
                break;
            }
            default: {
                response.setResult(ex.error);
                this.getLogger().error("Error code = " + ex.error + "; error message = " + ex.message);
            }
        }
        response.setMessage(ex.message);
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        return null;
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        Document doc = this.documentBuilder.newDocument();
        Element responseElement = doc.createElement("response");
        doc.appendChild(responseElement);
        this.processResponseEvent(response, responseElement);
        XMLUtils.createElement((Element)responseElement, (String)RESPONSE_PARAM_CODE).setTextContent(String.valueOf(response.getResult()));
        XMLUtils.createElement((Element)responseElement, (String)RESPONSE_PARAM_MESSAGE).setTextContent(String.valueOf(response.getMessage()));
        if (response.getResult() == 0) {
            switch (response.getAction()) {
                case 1: {
                    String param = (String)response.getParameters().get(RESPONSE_PARAM_FIO);
                    if (param != null) {
                        XMLUtils.createElement((Element)responseElement, (String)RESPONSE_PARAM_FIO).setTextContent(String.valueOf(param));
                    }
                    if ((param = (String)response.getParameters().get(RESPONSE_PARAM_ADDRESS)) != null) {
                        XMLUtils.createElement((Element)responseElement, (String)RESPONSE_PARAM_ADDRESS).setTextContent(String.valueOf(param));
                    }
                    if ((param = (String)response.getParameters().get(RESPONSE_PARAM_BALANCE)) != null) {
                        XMLUtils.createElement((Element)responseElement, (String)RESPONSE_PARAM_BALANCE).setTextContent(String.valueOf(param));
                        XMLUtils.createElement((Element)responseElement, (String)RESPONSE_PARAM_ACCOUNT_BALANCE).setTextContent(String.valueOf(param));
                    }
                    if ((param = (String)response.getParameters().get(RESPONSE_PARAM_SUM)) != null) {
                        XMLUtils.createElement((Element)responseElement, (String)RESPONSE_PARAM_SUM).setTextContent(String.valueOf(param));
                        XMLUtils.createElement((Element)responseElement, (String)RESPONSE_PARAM_REC_SUM).setTextContent(String.valueOf(param));
                    }
                    if ((param = (String)response.getParameters().get(RESPONSE_PARAM_INFO)) == null) break;
                    XMLUtils.createElement((Element)responseElement, (String)RESPONSE_PARAM_INFO).setTextContent(String.valueOf(param));
                    break;
                }
                case 2: {
                    String param = (String)response.getParameters().get(RESPONSE_PARAM_REG_DATE);
                    if (param == null) break;
                    XMLUtils.createElement((Element)responseElement, (String)RESPONSE_PARAM_REG_DATE).setTextContent(String.valueOf(param));
                    break;
                }
            }
        }
        this.setResponseParameters(response, responseElement);
        return this.xmlSerialize(doc);
    }

    @Override
    public String getDefaultEncoding() {
        return "windows-1251";
    }
}

