/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.client.admin;

import bitel.billing.module.common.BGComponentBorder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.ContractMonitorPanel;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.plugins.dispatch.client.admin.DispatchConditionPanel;
import ru.bitel.bgbilling.plugins.dispatch.client.common.DispatchMessagePanel;
import ru.bitel.bgbilling.plugins.dispatch.client.common.DispatchMessageStatisticPanel;
import ru.bitel.bgbilling.plugins.dispatch.client.common.SchedulePane;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ContactType;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.SenderType;
import ru.bitel.bgbilling.plugins.dispatch.common.service.DispatchService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.ScheduleTime;

public class DispatchManagerPanel
extends BGUPanel {
    private static final String DISPATCH_PANEL = "dispatch";
    private static final String STATISTIC_PANEL = "statistic";
    private static final String CONDITION_PANEL = "condition";
    private static final String MESSAGE_PANEL = "message";
    private DispatchTableModel model = new DispatchTableModel();
    private BGUTable table;
    private BGEditor editorContainer = new BGEditor();
    private DispatchManagerEditor editor = new DispatchManagerEditor();
    private DispatchMessageStatisticPanel statisticPanel = new DispatchMessageStatisticPanel();
    private JPanel mainPanel = new JPanel();
    private CardLayout switchLayout = new CardLayout();
    private DispatchMessagePanel messagePanel = new DispatchMessagePanel();
    private DispatchConditionPanel conditionPanel = new DispatchConditionPanel();
    private Directory<UserInfo> userDirectory;
    private ContractMonitorPanel contractPanel = new ContractMonitorPanel();
    private JPanel editorPanel = new JPanel();
    private String CONTRACT_MODE = "contracts";

    protected void jbInit() {
        this.table = new BGUTable((TableModel)((Object)this.model));
        this.table.enableSearchField();
        BGSwingUtilites.handleLDMouseClicked((Component)this.table, e -> this.editor.performAction("edit"));
        this.editorContainer.addForm((JComponent)((Object)this.editor));
        this.editorContainer.setVisible(false);
        JPanel dispatchTablePanel = new JPanel(new GridBagLayout());
        dispatchTablePanel.setBorder((Border)new BGTitleBorder("\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0438"));
        dispatchTablePanel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.setLayout(this.switchLayout);
        this.mainPanel.add((Component)dispatchTablePanel, DISPATCH_PANEL);
        this.mainPanel.add((Component)((Object)this.messagePanel), MESSAGE_PANEL);
        this.mainPanel.add((Component)((Object)this.conditionPanel), CONDITION_PANEL);
        this.mainPanel.add((Component)((Object)this.statisticPanel), STATISTIC_PANEL);
        this.editorPanel.setLayout(new CardLayout());
        this.editorPanel.add((Component)this.contractPanel, this.CONTRACT_MODE);
        this.editorPanel.setVisible(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.mainPanel, "Center");
        panel.add((Component)this.editorContainer, "West");
        panel.add((Component)this.editorPanel, "East");
        this.setLayout(new GridBagLayout());
        this.add(panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.editorPanel, new GridBagConstraints(2, 0, 1, 1, 3.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private Directory<UserInfo> getDirectory() {
        if (this.userDirectory == null) {
            try {
                this.userDirectory = ((ClientContext)this.getContext()).getDirectory(UserInfo.class, 0);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        return this.userDirectory;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            SenderType selectedSenderType = (SenderType)this.editor.typesCombo.getSelectedItem();
            this.editor.typesCombo.setData(((DispatchService)((ClientContext)this.getContext()).getPort(DispatchService.class)).getSenderTypes());
            if (selectedSenderType != null) {
                this.editor.typesCombo.setSelectedItem((Object)selectedSenderType);
            }
            List result = ((DispatchService)((ClientContext)this.getContext()).getPort(DispatchService.class)).getDispatchList();
            result.sort((d1, d2) -> {
                if (d1.isPersonal() && !d2.isPersonal()) {
                    return -1;
                }
                if (!d1.isPersonal() && d2.isPersonal()) {
                    return 1;
                }
                return d1.getTitle().compareToIgnoreCase(d2.getTitle());
            });
            this.model.setData(result);
            ContactType selectedContactType = (ContactType)this.editor.contactTypeCombo.getSelectedItem();
            List items = ((DispatchService)((ClientContext)this.getContext()).getPort(DispatchService.class)).getContactTypes();
            ContactType contactType = new ContactType();
            contactType.setTitle("-- \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043e\u0432 --");
            this.editor.contactTypeCombo.assignEmptyValue((GuiTitlable)contactType);
            this.editor.contactTypeCombo.setData(items);
            if (selectedContactType != null) {
                this.editor.contactTypeCombo.setSelectedItem((Object)selectedContactType);
            }
            this.conditionPanel.performAction("refresh");
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.switchLayout.show(this.mainPanel, DISPATCH_PANEL);
            this.editor.performAction("new");
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            this.switchLayout.show(this.mainPanel, DISPATCH_PANEL);
            this.editor.performAction("edit");
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> this.editor.performAction("delete"));
        new AbstractBGUPanel.MenuAction("dispatch.show_stat", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                Dispatch selectedRow = (Dispatch)DispatchManagerPanel.this.model.getSelectedRow();
                if (selectedRow != null) {
                    DispatchManagerPanel.this.switchLayout.show(DispatchManagerPanel.this.mainPanel, DispatchManagerPanel.STATISTIC_PANEL);
                    DispatchManagerPanel.this.statisticPanel.setDispatch(selectedRow);
                    DispatchManagerPanel.this.statisticPanel.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.MenuAction("dispatch.show_contracts", "\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b", ClientUtils.getIcon((String)"fugue/folder-open-document-text")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                Dispatch selectedRow = (Dispatch)DispatchManagerPanel.this.model.getSelectedRow();
                List result = ((DispatchService)((ClientContext)DispatchManagerPanel.this.getContext()).getPort(DispatchService.class)).getSubscriptions(selectedRow.getId(), 0);
                DispatchManagerPanel.this.contractPanel.setData(result);
                ((CardLayout)DispatchManagerPanel.this.editorPanel.getLayout()).show(DispatchManagerPanel.this.editorPanel, DispatchManagerPanel.this.CONTRACT_MODE);
                DispatchManagerPanel.this.editorPanel.setVisible(true);
                DispatchManagerPanel.this.revalidate();
                DispatchManagerPanel.this.repaint();
            }
        };
    }

    class DispatchTableModel
    extends BGTableModel<Dispatch> {
        public DispatchTableModel() {
            super(DispatchTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041c\u0435\u0442\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438", -1, 150, -1, "senderType", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438", -1, -1, -1, "repeatTime");
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u043d\u0430", -1, 100, 100, "active");
            this.addColumn("\u041f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u0430\u044f", -1, 150, 150, "personal");
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", Column.DateTime.class, -1, 150, 150, "createDispatchDate", false);
            this.addColumn("\u0414\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438", Column.DateTime.class, -1, 230, 250, "lastModifyDispatchDate", false);
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", -1, 150, -1, "user", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(Dispatch val, int column) throws Exception {
            switch (this.getIdentifier(column)) {
                case "senderType": {
                    return val.getSenderType().getGuiTitle();
                }
                case "repeatTime": {
                    return ScheduleTime.toHumanReadable((ScheduleTime)val.getRepeatTime());
                }
                case "user": {
                    UserInfo user = (UserInfo)DispatchManagerPanel.this.getDirectory().get(val.getUserId());
                    return user != null ? user.getName() : "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                }
            }
            return super.getValue((Object)val, column);
        }
    }

    private class DispatchManagerEditor
    extends BGUPanel {
        private Dispatch current = null;
        private JTextField titleField = new JTextField();
        private BGUComboBox<SenderType> typesCombo = new BGUComboBox();
        private SchedulePane schedulePane = new SchedulePane();
        private JCheckBox woContactType = new JCheckBox("\u0431\u0435\u0437 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430");
        private JCheckBox onlyOneContact = new JCheckBox("\u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0434\u0438\u043d \u043a\u043e\u043d\u0442\u0430\u043a\u0442");
        private JCheckBox activeCheckBox = new JCheckBox("\u0430\u043a\u0442\u0438\u0432\u043d\u0430");
        private JCheckBox personalCheckBox = new JCheckBox("\u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u0430\u044f");
        private JCheckBox doNotMarkSended = new JCheckBox("\u043d\u0435 \u043f\u043e\u043c\u0435\u0447\u0430\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u043c\u0438");
        private JCheckBox scheduleCheckBoxFake = new JCheckBox("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043f\u043e \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044e");
        private JCheckBox scheduleCheckBoxBorder = new JCheckBox("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043f\u043e \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044e");
        private JToggleButton showMessagesButton = new JToggleButton("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f =>");
        private JToggleButton showConditionsButton = new JToggleButton("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0443\u0441\u043b\u043e\u0432\u0438\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 =>");
        private JToggleButton showStatisticButton = new JToggleButton("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443 =>");
        private BGUComboBox<ContactType> contactTypeCombo = new BGUComboBox();

        private DispatchManagerEditor() {
        }

        protected void jbInit() {
            this.schedulePane.setBorder((Border)new BGComponentBorder((Component)this.scheduleCheckBoxBorder, (JComponent)this.schedulePane, BorderFactory.createEtchedBorder()));
            ActionListener al = e -> {
                if (this.scheduleCheckBoxFake.isSelected()) {
                    this.showSchedule();
                } else {
                    this.hideSchedule();
                }
            };
            this.woContactType.addActionListener(e -> this.contactTypeCombo.setEnabled(!this.woContactType.isSelected()));
            this.showMessagesButton.addActionListener(e -> {
                if (!this.showMessagesButton.isSelected()) {
                    DispatchManagerPanel.this.switchLayout.show(DispatchManagerPanel.this.mainPanel, DispatchManagerPanel.DISPATCH_PANEL);
                } else {
                    this.showConditionsButton.setSelected(false);
                    this.showStatisticButton.setSelected(false);
                    DispatchManagerPanel.this.switchLayout.show(DispatchManagerPanel.this.mainPanel, DispatchManagerPanel.MESSAGE_PANEL);
                    DispatchManagerPanel.this.messagePanel.setSelectedDispatch(this.current);
                    DispatchManagerPanel.this.messagePanel.performAction("refresh");
                }
            });
            this.showConditionsButton.addActionListener(e -> {
                if (!this.showConditionsButton.isSelected()) {
                    DispatchManagerPanel.this.switchLayout.show(DispatchManagerPanel.this.mainPanel, DispatchManagerPanel.DISPATCH_PANEL);
                } else {
                    this.showMessagesButton.setSelected(false);
                    this.showStatisticButton.setSelected(false);
                    DispatchManagerPanel.this.conditionPanel.setSelectedDispatch(this.current);
                    DispatchManagerPanel.this.switchLayout.show(DispatchManagerPanel.this.mainPanel, DispatchManagerPanel.CONDITION_PANEL);
                }
            });
            this.showStatisticButton.addActionListener(e -> {
                if (!this.showStatisticButton.isSelected()) {
                    DispatchManagerPanel.this.switchLayout.show(DispatchManagerPanel.this.mainPanel, DispatchManagerPanel.DISPATCH_PANEL);
                } else {
                    this.showMessagesButton.setSelected(false);
                    this.showConditionsButton.setSelected(false);
                    DispatchManagerPanel.this.statisticPanel.setDispatch((Dispatch)DispatchManagerPanel.this.model.getSelectedRow());
                    DispatchManagerPanel.this.statisticPanel.performAction("refresh");
                    DispatchManagerPanel.this.switchLayout.show(DispatchManagerPanel.this.mainPanel, DispatchManagerPanel.STATISTIC_PANEL);
                }
            });
            this.personalCheckBox.addActionListener(e -> {
                if (this.personalCheckBox.isSelected()) {
                    this.setConstraintsToSchedule();
                } else {
                    this.dropConstraintsFromSchedule();
                }
            });
            this.scheduleCheckBoxFake.addActionListener(al);
            this.scheduleCheckBoxBorder.addActionListener(al);
            JPanel rightPanel = new JPanel(new GridBagLayout());
            rightPanel.add((Component)this.woContactType, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            rightPanel.add((Component)this.onlyOneContact, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            rightPanel.add((Component)this.activeCheckBox, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            rightPanel.add((Component)this.personalCheckBox, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            rightPanel.add((Component)this.doNotMarkSended, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            rightPanel.add((Component)this.scheduleCheckBoxFake, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            rightPanel.add((Component)this.schedulePane, new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            rightPanel.add((Component)this.showMessagesButton, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 2, new Insets(25, 5, 5, 5), 0, 0));
            rightPanel.add((Component)this.showConditionsButton, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
            rightPanel.add((Component)this.showStatisticButton, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
            JPanel leftPanel = new JPanel(new GridBagLayout());
            leftPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            leftPanel.add((Component)this.titleField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            leftPanel.add((Component)new JLabel("\u0422\u0438\u043f \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438:"), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            leftPanel.add((Component)this.typesCombo, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            leftPanel.add((Component)new JLabel("\u0422\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043e\u0432:"), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            leftPanel.add((Component)this.contactTypeCombo, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.setLayout(new GridBagLayout());
            this.add(leftPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.add(rightPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 10, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.schedulePane.setVisible(false);
            Dimension d = new Dimension(150, 25);
            this.titleField.setMinimumSize(d);
            this.titleField.setPreferredSize(d);
            this.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
            this.setMinimumSize(new Dimension(350, 300));
            this.setPreferredSize(new Dimension(350, 300));
        }

        private void showSchedule() {
            this.schedulePane.setVisible(true);
            this.scheduleCheckBoxFake.setVisible(false);
            this.scheduleCheckBoxFake.setSelected(false);
            this.scheduleCheckBoxBorder.setSelected(true);
            this.doNotMarkSended.setSelected(true);
            this.doNotMarkSended.setEnabled(false);
        }

        private void hideSchedule() {
            this.schedulePane.setVisible(false);
            this.scheduleCheckBoxFake.setVisible(true);
            this.scheduleCheckBoxFake.setSelected(false);
            this.scheduleCheckBoxBorder.setSelected(false);
            this.doNotMarkSended.setSelected(this.current.isDoNotMarkSended());
            this.doNotMarkSended.setEnabled(true);
        }

        private void dropConstraintsFromSchedule() {
            this.hideSchedule();
            this.scheduleCheckBoxBorder.setEnabled(true);
            this.schedulePane.setTimeMode(false);
        }

        private void setConstraintsToSchedule() {
            this.showSchedule();
            this.scheduleCheckBoxBorder.setEnabled(false);
            this.schedulePane.setTimeMode(true);
        }

        private void fillToCurrent(boolean save) throws BGMessageException {
            this.current.setTitle(this.titleField.getText());
            this.current.setSenderType((SenderType)this.typesCombo.getSelectedItem());
            ScheduleTime st = null;
            if (this.scheduleCheckBoxBorder.isSelected()) {
                st = this.schedulePane.getTime();
            }
            this.current.setActive(this.activeCheckBox.isSelected());
            this.current.setPersonal(this.personalCheckBox.isSelected());
            this.current.setDoNotMarkSended(this.doNotMarkSended.isSelected());
            this.current.setOnlyOneContact(this.onlyOneContact.isSelected());
            this.current.setRepeatTime(st);
            this.current.setConditions(DispatchManagerPanel.this.conditionPanel.getConditions());
            this.current.setWoContactType(this.woContactType.isSelected());
            ContactType selectedContType = (ContactType)this.contactTypeCombo.getSelectedItem();
            if (save && selectedContType == null && !this.woContactType.isSelected()) {
                throw new BGMessageException("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043e\u0432!");
            }
            if (selectedContType != null) {
                this.current.setContactTypeId(selectedContType.getId());
            }
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
                this.current = new Dispatch();
                this.activeCheckBox.setSelected(true);
                this.personalCheckBox.setSelected(false);
                this.doNotMarkSended.setSelected(false);
                this.onlyOneContact.setSelected(false);
                this.titleField.setText("\u041d\u043e\u0432\u0430\u044f \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0430");
                this.typesCombo.setSelectedIndex(0);
                this.schedulePane.setDefaultTime();
                this.woContactType.setSelected(false);
                DispatchManagerPanel.this.conditionPanel.setSelectedDispatch(this.current);
                this.fillToCurrent(false);
                this.hideSchedule();
                this.showMessagesButton.setEnabled(false);
                this.showMessagesButton.setSelected(false);
                this.showConditionsButton.setSelected(false);
                this.showStatisticButton.setSelected(false);
                DispatchManagerPanel.this.switchLayout.show(DispatchManagerPanel.this.mainPanel, DispatchManagerPanel.DISPATCH_PANEL);
                this.contactTypeCombo.setEnabled(true);
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
                this.current = (Dispatch)DispatchManagerPanel.this.model.getSelectedRow();
                this.checkCurrent();
                this.woContactType.setSelected(this.current.isWoContactType());
                this.titleField.setText(this.current.getTitle());
                this.typesCombo.setSelectedItem((Object)this.current.getSenderType());
                this.activeCheckBox.setSelected(this.current.isActive());
                this.onlyOneContact.setSelected(this.current.isOnlyOneContact());
                this.schedulePane.setDefaultTime();
                this.personalCheckBox.setSelected(this.current.isPersonal());
                this.doNotMarkSended.setSelected(this.current.isDoNotMarkSended());
                if (this.current.isPersonal()) {
                    this.setConstraintsToSchedule();
                } else {
                    this.dropConstraintsFromSchedule();
                }
                ScheduleTime st = this.current.getRepeatTime();
                if (st != null) {
                    this.showSchedule();
                    this.schedulePane.setTime(st);
                }
                DispatchManagerPanel.this.conditionPanel.setSelectedDispatch(this.current);
                this.contactTypeCombo.setSelectedItem((Object)this.current.getContactTypeId());
                this.showMessagesButton.setEnabled(true);
                this.showMessagesButton.setSelected(false);
                this.showConditionsButton.setSelected(false);
                this.showStatisticButton.setSelected(false);
                DispatchManagerPanel.this.switchLayout.show(DispatchManagerPanel.this.mainPanel, DispatchManagerPanel.DISPATCH_PANEL);
                this.performActionOpen();
            });
            new AbstractBGUPanel.DefaultAction("ok", "OK"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    if (!DispatchManagerPanel.this.conditionPanel.validateConditions()) {
                        return;
                    }
                    DispatchManagerEditor.this.fillToCurrent(true);
                    ((DispatchService)((ClientContext)DispatchManagerEditor.this.getContext()).getPort(DispatchService.class)).updateDispatch(DispatchManagerEditor.this.current);
                    DispatchManagerEditor.this.performAction("close");
                    DispatchManagerPanel.this.performAction("refresh");
                }
            };
            new AbstractBGUPanel.DefaultAction("close", "\u041e\u0442\u043c\u0435\u043d\u0430"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    DispatchManagerPanel.this.switchLayout.show(DispatchManagerPanel.this.mainPanel, DispatchManagerPanel.DISPATCH_PANEL);
                    DispatchManagerPanel.this.editorContainer.setVisible(false);
                    DispatchManagerPanel.this.performAction("refresh");
                }
            };
            new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
                this.current = (Dispatch)DispatchManagerPanel.this.model.getSelectedRow();
                this.checkCurrent();
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438", 0) == 0) {
                    ((DispatchService)((ClientContext)this.getContext()).getPort(DispatchService.class)).deleteDispatch(this.current);
                    this.performActionClose();
                }
            });
        }

        private void checkCurrent() throws BGMessageException {
            if (this.current == null) {
                throw new BGMessageException("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
            }
            if (this.current.getId() <= 0) {
                throw new BGMessageException("\u0421\u043f\u0435\u0440\u0432\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u0435 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0443!");
            }
        }
    }
}

