/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class StringCache {
    private final int size;
    private final AtomicInteger count = new AtomicInteger();
    private final ConcurrentMap<String, String> cache;

    public StringCache(int size) {
        this.size = size;
        this.cache = new ConcurrentHashMap<String, String>(Math.max(8, size));
    }

    public StringCache(int size, String ... defaults) {
        this.size = size;
        this.cache = new ConcurrentHashMap<String, String>(Math.max(8, size));
        for (String def : defaults) {
            this.cache.put(def, def);
        }
    }

    public String intern(String string) {
        if (string == null) {
            return string;
        }
        String result = (String)this.cache.get(string);
        if (result != null) {
            return result;
        }
        if (this.count.get() < this.size) {
            result = this.cache.putIfAbsent(string, string);
            if (result == null) {
                this.count.incrementAndGet();
                result = string;
            }
            return result;
        }
        return string;
    }
}

