<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<c:if test="${not empty contact}">
	<div class="message confirm">Подтвердите удаление контакта</div>
	<div style="display: table; width: 100%;">
	<div class="param"><span class="name">Тип:</span><span class="bold">${contactType.title}</span></div>
	<div class="param"><span class="name">Значение:</span><span class="bold"><c:choose><c:when test="${not empty contact.value}">${contact.value}</c:when><c:otherwise>${contact.defaultValue}</c:otherwise></c:choose></span></div>
	</div>
</c:if>

<c:if test="${not empty status}">
	<c:choose>
		<c:when test="${status == 'ok'}"><div class="message ok">Контакт удален</div></c:when>
		<c:otherwise><div class="alert alert-danger" role="alert">${status}</div></c:otherwise>
	</c:choose>
</c:if>

<script>
{
	const dialog = jQuery("div#dispatchContactRemove").dialog({ autoOpen : false, modal: true, width: 500, dialogClass: "bgbilling-dialog bgbilling-dialog-user" });
	const dialogDestroy = () => dialog.dialog( "destroy" );

	let buttons = [
		<c:choose>
		<c:when test="${not empty contact}">
			{ text: "Отмена", click: dialogDestroy },
			{ text: "Удалить", click: () => { dialogDestroy(); showBlock( 'dispatchContactRemove', { operation: 'removeContact', id: ${contact.id}, remove: true }, dispatchQuery ); } }
		</c:when>
		<c:otherwise>
			{ text: "Закрыть", click: () => { dialogDestroy(); showBlock( 'dispatchRoot', 'execute', dispatchQuery ); } }
		</c:otherwise>
		</c:choose>
	];

	dialog.dialog( "option","buttons", buttons );
	dialog.dialog("open");
}
</script>