/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.option.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.PersonalTariffManager;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOptionData;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOptionActivateMode;
import ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionActivateManager;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.TariffOptionActivateModeDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.TariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.event.TariffOptionListAvailableEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService")
public class TariffOptionServiceImpl
extends AbstractService
implements TariffOptionService {
    private TariffOptionDao tariffOptionDao;
    private TariffOptionActivateModeDao tariffOptionActivateModeDao;
    private ContractTariffOptionDao contractTariffOptionDao;
    private PersonalTariffManager personalTariffManager;
    private ContractTariffOptionActivateManager contractTariffOptionActivateManager;
    private ContractLabelManager contractLabelManager;

    @PostConstruct
    protected void init() throws Exception {
        this.tariffOptionDao = new TariffOptionDao(this.getConnection());
        this.tariffOptionActivateModeDao = new TariffOptionActivateModeDao(this.getConnection());
        this.contractTariffOptionDao = new ContractTariffOptionDao(this.getConnection());
        this.personalTariffManager = new PersonalTariffManager(this.getConnection());
        this.contractTariffOptionActivateManager = new ContractTariffOptionActivateManager(this.getConnection());
        this.contractLabelManager = new ContractLabelManager(this.getConnection());
    }

    @Override
    public TariffOption tariffOptionGet(int id) throws Exception {
        return ((TariffOption)this.tariffOptionDao.get(id)).setActivateModeList(this.tariffOptionActivateModeDao.getOptionActivateModeList(id, null));
    }

    @Override
    public List<TariffOption> tariffOptionList() throws Exception {
        return this.tariffOptionDao.list((Date)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<TariffOption> tariffOptionListAvailable(int contractId, Date date, List<ContractTariffOption> currentContractOptionList, boolean onlyAvailable, boolean web) throws Exception {
        void var11_16;
        if (contractId <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (date == null) {
            date = new Date();
        }
        if (this.getSetup().getBoolean("tariffOption.dontCheckOnActivateAlreadyActivated", this.getSetup().getBoolean("allow.parallel.option.activate", false))) {
            currentContractOptionList = new ArrayList<ContractTariffOption>();
        } else if (currentContractOptionList == null) {
            currentContractOptionList = this.contractTariffOptionDao.list(contractId, date);
        }
        List<TariffOption> fullOptionList = this.tariffOptionDao.list(date);
        HashSet<TariffOption> currentOptionSet = new HashSet<TariffOption>();
        for (ContractTariffOption cto : currentContractOptionList) {
            currentOptionSet.add(TariffOption.builder().setId(cto.getOptionId()).build());
        }
        if (onlyAvailable) {
            fullOptionList.removeAll(currentOptionSet);
        }
        HashSet<Integer> tariffIds = new HashSet<Integer>();
        ContractTariffDao contractTariffDao = new ContractTariffDao(this.getConnection());
        for (ContractTariff contractTariff : contractTariffDao.list(contractId, TimeUtils.convertDateToLocalDate(date))) {
            tariffIds.add(contractTariff.getTariffPlanId());
        }
        tariffIds.addAll(this.personalTariffManager.getParentTreeTariffIds(contractId, date));
        List<Integer> labelsOnContract = this.contractLabelManager.getContractLabelIds(contractId);
        for (TariffOption option : fullOptionList) {
            boolean allowOptionForContract;
            if (CollectionUtils.intersection(option.getTariffIdSet(), tariffIds).size() == 0 || Utils.notEmptyCollection(labelsOnContract) && Utils.notEmptyCollection(option.getContractLabels()) && !(allowOptionForContract = option.getContractLabels().stream().filter(labelId -> labelsOnContract.stream().anyMatch(labelId::equals)).findAny().orElse(-1) > 0)) continue;
            if (web) {
                if (option.isHideForWeb()) continue;
                if (option.getHideForContractGroupsMode() == 0) {
                    boolean hideThisLabel;
                    boolean bl = hideThisLabel = option.getHideForContractLabels().stream().filter(labelId -> labelsOnContract.stream().anyMatch(labelId::equals)).findAny().orElse(-1) > 0;
                    if (hideThisLabel) {
                        continue;
                    }
                } else if (!labelsOnContract.containsAll(option.getHideForContractLabels())) continue;
            }
            option.setEnable(true);
        }
        try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
            Contract contract = (Contract)contractDao.get(contractId);
            TariffOptionListAvailableEvent availableListEvent = EventProcessor.getInstance().request(new TariffOptionListAvailableEvent(contractId, this.userId, date, contract, tariffIds, currentContractOptionList, onlyAvailable, web, fullOptionList));
            fullOptionList = availableListEvent.getTariffOptionList();
        }
        if (onlyAvailable) {
            ArrayList<TariffOption> arrayList = new ArrayList<TariffOption>();
            for (TariffOption option : fullOptionList) {
                if (!option.isEnable()) continue;
                arrayList.add(option);
            }
        } else {
            List<TariffOption> list = fullOptionList;
        }
        for (TariffOption o : var11_16) {
            o.setActivateModeList(this.tariffOptionActivateModeDao.getOptionActivateModeList(o.getId(), date));
        }
        return var11_16;
    }

    @Override
    public List<TariffOption> tariffOptionWebList(int contractId, Date date, List<TariffOption> fullOptionList) throws Exception {
        if (fullOptionList == null) {
            fullOptionList = this.tariffOptionDao.list(date);
        }
        List<Integer> labelsOnContract = this.contractLabelManager.getContractLabelIds(contractId);
        ArrayList<TariffOption> result = new ArrayList<TariffOption>();
        for (TariffOption option : fullOptionList) {
            if (option.isHideForWeb()) continue;
            if (option.getHideForContractGroupsMode() == 0) {
                boolean hideThisOption;
                boolean bl = hideThisOption = option.getHideForContractLabels().stream().filter(labelId -> labelsOnContract.stream().anyMatch(labelId::equals)).findAny().orElse(-1) > 0;
                if (hideThisOption) {
                    continue;
                }
            } else if (!labelsOnContract.containsAll(option.getHideForContractLabels())) continue;
            result.add(option);
        }
        return result;
    }

    @Override
    public void tariffOptionUpdate(TariffOption option) throws Exception {
        this.tariffOptionDao.update(option);
        this.tariffOptionActivateModeDao.updateTariffOptionActivateModeList(option.getId(), option.getActivateModeList());
    }

    @Override
    public void tariffOptionDelete(int id) throws Exception {
        List<TariffOptionActivateMode> modeList = Collections.emptyList();
        this.tariffOptionDao.delete(id);
        this.tariffOptionActivateModeDao.updateTariffOptionActivateModeList(id, modeList);
    }

    @Override
    public List<TariffOptionActivateMode> tariffOptionActivateModeList(int optionId, Date date) throws Exception {
        if (optionId <= 0) {
            throw new BGIllegalArgumentException();
        }
        return this.tariffOptionActivateModeDao.getOptionActivateModeList(optionId, date);
    }

    @Override
    public TariffOptionActivateMode tariffOptionActivateModeGet(int optionId, int modeId) throws Exception {
        TariffOption tariffOption = this.tariffOptionGet(optionId);
        List<TariffOptionActivateMode> list = tariffOption.getActivateModeList();
        TariffOptionActivateMode mode = null;
        for (TariffOptionActivateMode activateMode : list) {
            if (activateMode.getId() != modeId) continue;
            mode = activateMode;
            break;
        }
        return mode;
    }

    @Override
    public List<ContractTariffOption> contractTariffOptionList(int contractId, Date date) throws Exception {
        return this.contractTariffOptionDao.list(contractId, date);
    }

    @Override
    public List<ContractTariffOption> contractTariffOptionListWeb(int contractId, Date date, List<ContractTariffOption> list) throws Exception {
        if (list == null || list.size() == 0) {
            list = this.contractTariffOptionList(contractId, date);
        }
        List<TariffOption> visibleOptions = this.tariffOptionWebList(contractId, date, null);
        HashSet<Integer> visibleOptionIds = new HashSet<Integer>();
        for (TariffOption option : visibleOptions) {
            visibleOptionIds.add(option.getId());
        }
        ArrayList<ContractTariffOption> result = new ArrayList<ContractTariffOption>();
        for (ContractTariffOption option : list) {
            if (!visibleOptionIds.contains(option.getOptionId())) continue;
            result.add(option);
        }
        return result;
    }

    @Override
    public void contractTariffOptionActivate(ContractTariffOptionData contractTariffOptionData) throws Exception {
        this.contractTariffOptionActivateManager.activateOptionWhithSumAndPeriod(this, this.userId, contractTariffOptionData);
    }

    @Override
    public int contractTariffOptionActivateWhithSum(ContractTariffOptionData contractTariffOptionData) throws Exception {
        return this.contractTariffOptionActivateManager.activateOptionWhithSumAndPeriod(this, this.userId, contractTariffOptionData);
    }

    @Override
    public void contractTariffOptionDeactivate(int contractId, int contractOptionId) throws Exception {
        this.contractTariffOptionActivateManager.deactivateOption(this.userId, contractId, contractOptionId);
    }

    @Override
    public void contractTariffOptionReactivate(int contractId, int contractOptionId) throws Exception {
        this.contractTariffOptionActivateManager.reactivateOption(this.userId, contractId, contractOptionId);
    }

    @Override
    public List<ContractTariffOption> contractTariffOptionHistory(int contractId, Date date, boolean web) throws Exception {
        List<ContractTariffOption> result = this.contractTariffOptionDao.list(contractId, date, true, true);
        if (web) {
            result = this.contractTariffOptionListWeb(contractId, date, result);
        }
        return result;
    }

    @Override
    public void contractTariffOptionDelete(int contractId, int id, boolean customer) throws Exception {
        this.contractTariffOptionActivateManager.deleteOption(this.userId, contractId, id, customer);
    }

    @Override
    public String configOption() throws Exception {
        JSONArray array = new JSONArray();
        Setup moduleSetup = this.getSetup();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)"tariffOption.dontCheckOnActivateAlreadyActivated");
        jsonObject.put("value", moduleSetup.getBoolean("tariffOption.dontCheckOnActivateAlreadyActivated", false));
        array.put((Object)jsonObject);
        return array.toString();
    }
}

