/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rentsoft.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.modules.rentsoft.common.bean.RentsoftPayment;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

public class RentsoftPaymentManager
extends AbstractIdDao<RentsoftPayment> {
    private int serviceId = 0;

    public RentsoftPaymentManager(Connection con, int moduleId) throws SQLException {
        super(con, "rentsoft_payment", moduleId);
        this.setServiceId();
    }

    private void setServiceId() throws SQLException {
        String query = "SELECT id FROM service WHERE mid=? LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, this.moduleId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    this.serviceId = rs.getInt(1);
                }
            }
        }
    }

    public List<RentsoftPayment> getPaymentList(int productId, int cid) throws SQLException {
        return this.list("product_id=? AND cid=?", "date DESC", new Object[]{productId, cid});
    }

    protected void updateImpl(RentsoftPayment rentsoftPayment) throws SQLException {
        String querySet = "txid=?, date=?, cid=?, comment=?, amount=?, status=?, product_id=?";
        try (PreparedStatement ps = this.prepareStatement((Id)rentsoftPayment, querySet);){
            ps.setString(1, rentsoftPayment.getTxid());
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)rentsoftPayment.getDate()));
            ps.setInt(3, rentsoftPayment.getContractId());
            ps.setString(4, rentsoftPayment.getComment());
            ps.setBigDecimal(5, rentsoftPayment.getAmount());
            ps.setInt(6, rentsoftPayment.getStatus());
            ps.setInt(7, rentsoftPayment.getProductId());
            this.executeUpdate((Id)rentsoftPayment, this.serviceId, ps);
        }
    }

    protected RentsoftPayment getFromRS(ResultSet rs) throws SQLException {
        RentsoftPayment payment = new RentsoftPayment();
        payment.setAmount(rs.getBigDecimal("amount"));
        payment.setComment(rs.getString("comment"));
        payment.setContractId(rs.getInt("cid"));
        payment.setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("date")));
        payment.setId(rs.getInt("id"));
        payment.setProductId(rs.getInt("product_id"));
        payment.setStatus(rs.getInt("status"));
        payment.setTxid(rs.getString("txid"));
        return payment;
    }

    public RentsoftPayment getByTxid(String txid) throws SQLException {
        return (RentsoftPayment)this.get("txid=?", new Object[]{txid});
    }

    public boolean isTxidExists(String txid) throws SQLException {
        String query = "SELECT id FROM " + this.tableName + " WHERE txid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, txid);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public boolean checkCid(int contractId) throws SQLException {
        boolean result = false;
        String query = "SELECT c.id FROM contract AS c LEFT JOIN contract_module AS cm ON cm.cid=c.id WHERE c.id=? AND cm.mid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, this.moduleId);
            try (ResultSet rs = ps.executeQuery();){
                result = rs.next();
            }
        }
        return result;
    }

    public boolean isEnoughMoney(int contractId, BigDecimal amount) throws BGException {
        boolean isEnoughMoney;
        Contract contract = null;
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            contract = (Contract)contractDao.get(contractId);
            if (contract == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Contract is null [ID#" + contractId + "], return False");
                }
                boolean bl = false;
                return bl;
            }
        }
        byte contractStatus = contract.getStatus();
        boolean isModuleActiveStatus = StatusCache.getInstance().isModuleActiveStatus(this.moduleId, (int)contractStatus);
        if (!isModuleActiveStatus) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("contractStatus=" + contractStatus + "; moduleId=" + this.moduleId + "; isModuleActiveStatus=" + isModuleActiveStatus + ", return False");
            }
            return false;
        }
        BalanceUtils balanceUtils = new BalanceUtils(this.con);
        BigDecimal balance = balanceUtils.getBalance(LocalDate.now(), contractId);
        balanceUtils.close();
        byte balanceMode = contract.getBalanceMode();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Contract balance=" + balance.toPlainString());
            this.getLogger().debug("Contract balanceMode=" + balanceMode);
        }
        if (balanceMode == 1) {
            BigDecimal balanceLimit = contract.getBalanceLimit();
            balance = balance.subtract(balanceLimit);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Contract balanceLimit=" + String.valueOf(balanceLimit));
                this.getLogger().debug("Contract balance=" + balance.toPlainString());
            }
        }
        boolean bl = isEnoughMoney = balance.compareTo(amount) >= 0;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Amount=" + String.valueOf(amount));
            this.getLogger().debug("Contract isEnoughMoney=" + isEnoughMoney);
        }
        return isEnoughMoney;
    }

    public boolean billUser(RentsoftPayment payment, boolean revert) throws Exception {
        try (BalanceUtils bu = new BalanceUtils(this.con);){
            this.update(payment);
            bu.addContractAccount(payment.getContractId(), TimeUtils.convertDateToLocalDate((Date)payment.getDate()), this.serviceId, payment.getAmount().multiply(new BigDecimal(revert ? -1 : 1)));
            bu.updateBalance(payment.getDate(), payment.getContractId());
            boolean bl = true;
            return bl;
        }
    }

    public boolean recalculateUser(int contractId, Date date) throws BGException {
        boolean bl;
        StringBuilder sb = new StringBuilder().append("SELECT SUM(amount) FROM ").append(this.tableName).append(" WHERE cid=? AND YEAR(date) = YEAR(?) AND MONTH(date) = MONTH(?) GROUP BY cid");
        BalanceUtils bu = new BalanceUtils(this.con);
        try {
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ps.setInt(1, contractId);
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)date));
            ps.setTimestamp(3, TimeUtils.convertDateToTimestamp((Date)date));
            LocalDate localDate = TimeUtils.convertDateToLocalDate((Date)date);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                bu.setContractAccount(contractId, localDate, this.serviceId, rs.getBigDecimal(1));
            } else {
                bu.setContractAccount(contractId, localDate, this.serviceId, BigDecimal.ZERO);
            }
            rs.close();
            ps.close();
            bu.updateBalance(date, contractId);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bu.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
        bu.close();
        return bl;
    }

    public String getCurrentBalance(int contractId) {
        try (BalanceUtils bu = new BalanceUtils(this.con);){
            String string = new DecimalFormat("0").format(bu.getBalance(LocalDate.now(), contractId));
            return string;
        }
    }

    public String getTariffIds(int contractId) throws SQLException {
        String query = "SELECT tpid FROM contract_tariff WHERE cid=? AND ( date1 IS NULL OR date1 <= CURDATE() ) AND ( date2 IS NULL OR date2 >= CURDATE() )";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            Object ids = "";
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    ids = (String)("".equals(ids) ? "" : (String)ids + " ") + rs.getInt(1);
                }
            }
            String string = ids;
            return string;
        }
    }

    public boolean getIsJuridical(int contractId) throws BGException {
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            boolean bl = ((Contract)contractDao.get(contractId)).getPersonType() == 1;
            return bl;
        }
    }

    public boolean getIsPostpaid(int contractId) throws BGException {
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            boolean bl = ((Contract)contractDao.get(contractId)).getBalanceMode() == 1;
            return bl;
        }
    }

    public boolean areChargesAllowedToCid(int contractId) throws BGException {
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            Contract c = (Contract)contractDao.get(contractId);
            boolean bl = c != null && (c.getPersonType() == 0 || RentsoftPaymentManager.containsRentsoftName(c));
            return bl;
        }
    }

    public List<String> getUuidsByTariff(int tid) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        String query = "SELECT c.id FROM contract as c INNER JOIN contract_module AS cm ON c.id=cm.cid INNER JOIN contract_tariff AS ct ON c.id=ct.cid WHERE ct.tpid=? AND cm.mid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, tid);
            ps.setInt(2, this.moduleId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    ids.add(this.cidToUuid(rs.getInt(1)));
                }
            }
        }
        return ids;
    }

    public void deleteForContract(int contractId) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.executeUpdate();
        }
    }

    public int uuidToCid(String uuid) {
        Matcher m = Pattern.compile("(.*):juridical").matcher(uuid);
        return Utils.parseInt((String)(m.matches() ? m.group(1) : uuid));
    }

    public String cidToUuid(int ccontractId) throws BGException {
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            Contract c = (Contract)contractDao.get(ccontractId);
            if (c.getPersonType() == 1 && c.getSuperCid() != 0 && RentsoftPaymentManager.containsRentsoftName(c)) {
                c = (Contract)contractDao.get(c.getSuperCid());
            }
            String string = c.getPersonType() == 0 ? "" + c.getId() : c.getId() + ":juridical";
            return string;
        }
    }

    public int getCidToCharge(int parentContractId) throws BGException {
        int result;
        block8: {
            result = 0;
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                Contract parent = (Contract)contractDao.get(parentContractId);
                if (parent == null) {
                    result = 0;
                    break block8;
                }
                if (parent.getPersonType() == 0 || RentsoftPaymentManager.containsRentsoftName(parent)) {
                    result = parent.getId();
                    break block8;
                }
                List subContracts = contractDao.getSubContracts(parent.getId(), -1);
                for (Contract child : subContracts) {
                    if (!RentsoftPaymentManager.containsRentsoftName(child)) continue;
                    result = child.getId();
                    break;
                }
            }
        }
        return result;
    }

    private static boolean containsRentsoftName(Contract c) {
        return RentsoftPaymentManager.containsRentsoftName(c.getComment()) || RentsoftPaymentManager.containsRentsoftName(c.getTitle());
    }

    private static boolean containsRentsoftName(String text) {
        return text.matches("(?i).*(rentsoft|rensoft).*");
    }
}

