/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Date;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.Id;

public class IpResource
extends Id
implements GuiTitlable {
    private int categoryId;
    private byte[] addressFrom;
    private byte[] addressTo;
    private short prefixLength;
    private Date dateFrom;
    private Date dateTo;
    private String router;
    private String subnetMask;
    private String dns;
    private boolean reserveStart = false;
    private boolean reserveEnd = false;
    private String config;
    private String comment;

    @XmlAttribute
    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int categoryId) {
        this.categoryId = categoryId;
    }

    @XmlAttribute
    public byte[] getAddressFrom() {
        return this.addressFrom;
    }

    public void setAddressFrom(byte[] addressFrom) {
        this.addressFrom = addressFrom;
    }

    @XmlAttribute
    public byte[] getAddressTo() {
        return this.addressTo;
    }

    public void setAddressTo(byte[] addressTo) {
        this.addressTo = addressTo;
    }

    @XmlAttribute
    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    @XmlAttribute
    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    @XmlAttribute
    public String getRouter() {
        return this.router;
    }

    public void setRouter(String router) {
        this.router = router;
    }

    @XmlAttribute
    public String getSubnetMask() {
        return this.subnetMask;
    }

    public void setSubnetMask(String subnetMask) {
        this.subnetMask = subnetMask;
    }

    @XmlAttribute
    public String getDns() {
        return this.dns;
    }

    public void setDns(String dns) {
        this.dns = dns;
    }

    @XmlAttribute
    public boolean isReserveStart() {
        return this.reserveStart;
    }

    @XmlAttribute
    public boolean isReserveEnd() {
        return this.reserveEnd;
    }

    public void setReserveStart(boolean reserveStart) {
        this.reserveStart = reserveStart;
    }

    public void setReserveEnd(boolean reserveEnd) {
        this.reserveEnd = reserveEnd;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    @XmlElement
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String toString() {
        if (this.addressFrom.length == 16) {
            return IpNet.toRFCString(this.addressFrom, this.addressTo) + " (" + this.id + ")";
        }
        return IpAddress.toString(this.addressFrom) + "-" + IpAddress.toString(this.addressTo) + " (" + this.id + ")";
    }

    @Override
    @XmlTransient
    public String getGuiTitle() {
        return this.toString();
    }

    @XmlAttribute
    public short getPrefixLength() {
        return this.prefixLength;
    }

    public void setPrefixLength(short prefixLength) {
        this.prefixLength = prefixLength;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private IpResource ipResource = new IpResource();

        private Builder() {
        }

        public Builder setId(int id) {
            this.ipResource.id = id;
            return this;
        }

        public Builder setCategoryId(int categoryId) {
            this.ipResource.categoryId = categoryId;
            return this;
        }

        public Builder setAddressFrom(byte[] addressFrom) {
            this.ipResource.addressFrom = addressFrom;
            return this;
        }

        public Builder setAddressTo(byte[] addressTo) {
            this.ipResource.addressTo = addressTo;
            return this;
        }

        public Builder setPrefixLength(short prefixLength) {
            this.ipResource.prefixLength = prefixLength;
            return this;
        }

        public Builder setDateFrom(Date dateFrom) {
            this.ipResource.dateFrom = dateFrom;
            return this;
        }

        public Builder setDateTo(Date dateTo) {
            this.ipResource.dateTo = dateTo;
            return this;
        }

        public Builder setRouter(String router) {
            this.ipResource.router = router;
            return this;
        }

        public Builder setDns(String dns) {
            this.ipResource.dns = dns;
            return this;
        }

        public Builder setSubnetMask(String subnetMask) {
            this.ipResource.subnetMask = subnetMask;
            return this;
        }

        public Builder setConfig(String config) {
            this.ipResource.config = config;
            return this;
        }

        public Builder setComment(String comment) {
            this.ipResource.comment = comment;
            return this;
        }

        public Builder setReserveStart(boolean reserveStart) {
            this.ipResource.reserveStart = reserveStart;
            return this;
        }

        public Builder setReserveEnd(boolean reserveEnd) {
            this.ipResource.reserveEnd = reserveEnd;
            return this;
        }

        public IpResource build() {
            try {
                IpResource ipResource = this.ipResource;
                return ipResource;
            }
            finally {
                this.ipResource = null;
            }
        }
    }
}

