/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.tv.access.om;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.apps.tv.access.TvAccess;
import ru.bitel.bgbilling.apps.tv.access.om.AbstractOrderEvent;
import ru.bitel.bgbilling.apps.tv.access.om.ProductEntry;
import ru.bitel.bgbilling.apps.tv.access.om.ServiceEntry;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccountSpec;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductRuntimeList;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.ServiceRuntimeList;
import ru.bitel.bgbilling.modules.tv.server.runtime.ServiceSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.ServiceSpecRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.common.model.ContractIdable;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.server.ProductPeriodRuntimeList;
import ru.bitel.oss.systems.inventory.service.common.bean.Service;
import ru.bitel.oss.systems.inventory.service.common.bean.ServiceSpec;

public class ProductOrderEvent
extends AbstractOrderEvent
implements ContractIdable {
    public static final int EVENT_TYPE_PRODUCT_MODIFY = 2;
    final TvAccount tvAccount;
    final List<ProductEntry> productEntryList;

    public ProductOrderEvent(TvAccess tvAccess, Event event, int deviceId, TvAccountRuntime tvAccountRuntime, int eventType, int tvAccountId, TvAccountSpec tvAccountSpec, TvAccount tvAccount, List<ProductEntry> productEntryList, Set<Integer> oldDeviceOptionIds, Set<Integer> newDeviceOptionIds, int accessCode) {
        super(tvAccess, event, deviceId, tvAccountRuntime, eventType, tvAccountId, tvAccountSpec, oldDeviceOptionIds, newDeviceOptionIds);
        this.tvAccount = tvAccount;
        this.productEntryList = productEntryList;
    }

    @Override
    public int getContractId() {
        return this.contractId;
    }

    @Override
    public int getTvAccountId() {
        return this.tvAccountId;
    }

    public TvAccount getTvAccount() {
        return this.tvAccount;
    }

    public List<ProductEntry> getProductEntryList() {
        return this.productEntryList;
    }

    public Set<ProductSpecRuntime> getProductSpecRuntimeSetToAdd() {
        HashSet<ProductSpecRuntime> result = new HashSet<ProductSpecRuntime>();
        for (ProductEntry e : this.productEntryList) {
            if (e.getNewState() == e.getOldState() || e.getNewState() != 1) continue;
            result.add(e.productSpecRuntime);
        }
        return result;
    }

    public Set<ProductSpecRuntime> getProductSpecRuntimeSetToRemove() {
        HashSet<ProductSpecRuntime> result = new HashSet<ProductSpecRuntime>();
        for (ProductEntry e : this.productEntryList) {
            if (e.getNewState() == e.getOldState() || e.getOldState() != 1) continue;
            result.add(e.productSpecRuntime);
        }
        return result;
    }

    public Set<ProductSpec> getProductSpecSetToAdd() {
        HashSet<ProductSpec> result = new HashSet<ProductSpec>();
        for (ProductEntry e : this.productEntryList) {
            if (e.getNewState() == e.getOldState() || e.getNewState() != 1) continue;
            result.add(e.productSpec);
        }
        return result;
    }

    public Set<ProductSpec> getProductSpecSetToRemove() {
        HashSet<ProductSpec> result = new HashSet<ProductSpec>();
        for (ProductEntry e : this.productEntryList) {
            if (e.getNewState() == e.getOldState() || e.getOldState() != 1) continue;
            result.add(e.productSpec);
        }
        return result;
    }

    public Set<ServiceSpecRuntime> getServiceSpecRuntimeSetToAdd() {
        HashSet<ServiceSpecRuntime> result = new HashSet<ServiceSpecRuntime>();
        for (ProductEntry e : this.productEntryList) {
            if (e.getNewState() == e.getOldState() || e.getNewState() != 1) continue;
            for (ServiceEntry se : e.serviceEntryList) {
                if (se.getNewState() == se.getOldState() || se.getNewState() != Service.STATE_ENABLED) continue;
                result.add(se.serviceSpecRuntime);
            }
        }
        return result;
    }

    public Set<ServiceSpecRuntime> getServiceSpecRuntimeSetToRemove() {
        HashSet<ServiceSpecRuntime> result = new HashSet<ServiceSpecRuntime>();
        for (ProductEntry e : this.productEntryList) {
            if (e.getNewState() == e.getOldState() || e.getOldState() != 1) continue;
            for (ServiceEntry se : e.serviceEntryList) {
                if (se.getNewState() == se.getOldState() || se.getOldState() != 1) continue;
                result.add(se.serviceSpecRuntime);
            }
        }
        return result;
    }

    public Set<ServiceSpec> getServiceSpecSetToAdd() {
        HashSet<ServiceSpec> result = new HashSet<ServiceSpec>();
        for (ProductEntry e : this.productEntryList) {
            if (e.getNewState() == e.getOldState() || e.getNewState() != 1) continue;
            for (ServiceEntry se : e.serviceEntryList) {
                if (se.getNewState() == se.getOldState() || se.getNewState() != Service.STATE_ENABLED) continue;
                result.add(se.serviceSpec);
            }
        }
        return result;
    }

    public Set<ServiceSpec> getServiceSpecSetToRemove() {
        HashSet<ServiceSpec> result = new HashSet<ServiceSpec>();
        for (ProductEntry e : this.productEntryList) {
            if (e.getNewState() == e.getOldState() || e.getOldState() != 1) continue;
            for (ServiceEntry se : e.serviceEntryList) {
                if (se.getNewState() == se.getOldState() || se.getOldState() != 1) continue;
                result.add(se.serviceSpec);
            }
        }
        return result;
    }

    @Override
    protected Map<Integer, ProductSpecRuntime> getFullProductSpecRuntimeMapToEnable() throws BGException {
        HashMap<Integer, ProductSpecRuntime> result = new HashMap<Integer, ProductSpecRuntime>();
        HashSet<Integer> productSpecIds = new HashSet<Integer>();
        ProductRuntimeList productRuntimeList = this.tvAccountRuntime.getProductRuntimeList();
        int size = productRuntimeList.size();
        for (int i = 0; i < size; ++i) {
            ProductRuntimeList.ProductItem productItem = (ProductRuntimeList.ProductItem)productRuntimeList.get(i);
            if (productItem.deviceState != 1) continue;
            productSpecIds.add(productItem.id);
        }
        for (ProductEntry e : this.productEntryList) {
            productSpecIds.remove(e.productSpec.getId());
            if (e.newProduct == null || e.newState != 1) continue;
            result.put(e.productSpec.getId(), e.productSpecRuntime);
        }
        ProductSpecRuntimeMap productSpecRuntimeMap = this.tvAccess.productSpecRuntimeMap;
        for (Integer productSpecId : productSpecIds) {
            ProductSpecRuntime productSpecRuntime = (ProductSpecRuntime)productSpecRuntimeMap.get(productSpecId);
            if (productSpecRuntime == null) continue;
            result.put(productSpecId, productSpecRuntime);
        }
        return result;
    }

    @Override
    public List<ProductEntry> getFullProductEntryListToEnable() throws BGException {
        ArrayList<ProductEntry> result = new ArrayList<ProductEntry>();
        HashSet<Integer> productIds = new HashSet<Integer>();
        for (ProductEntry e : this.productEntryList) {
            if (e.newProduct != null) {
                productIds.add(e.newProduct.getId());
            } else {
                productIds.add(e.oldProduct.getId());
            }
            if (e.newState != 1) continue;
            result.add(e);
        }
        ProductSpecRuntimeMap productSpecRuntimeMap = this.tvAccess.productSpecRuntimeMap;
        ServiceSpecRuntimeMap serviceSpecRuntimeMap = this.tvAccess.serviceSpecRuntimeMap;
        ProductRuntimeList productRuntimeList = this.tvAccountRuntime.getProductRuntimeList();
        ServiceRuntimeList serviceRuntimeList = this.tvAccountRuntime.getServiceRuntimeList();
        ProductPeriodRuntimeList productPeriodRuntimeList = this.tvAccountRuntime.getProductPeriodRuntimeList();
        int size = productRuntimeList.size();
        for (int i = 0; i < size; ++i) {
            int moduleId;
            ProductSpecRuntime productSpecRuntime;
            ProductRuntimeList.ProductItem productItem = (ProductRuntimeList.ProductItem)productRuntimeList.get(i);
            if (productItem.deviceState != 1 || productIds.contains(productItem.productId) || (productSpecRuntime = (ProductSpecRuntime)productSpecRuntimeMap.get(productItem.id)) == null || (moduleId = productSpecRuntime.getProductSpec().getModuleId()) != this.tvAccess.moduleId) continue;
            List<ServiceRuntimeList.ServiceItem> serviceItemList = serviceRuntimeList.listByProductId(productItem.productId);
            ArrayList<ServiceEntry> serviceEntryList = new ArrayList<ServiceEntry>();
            for (ServiceRuntimeList.ServiceItem serviceItem : serviceItemList) {
                ServiceSpecRuntime serviceSpecRuntime = (ServiceSpecRuntime)serviceSpecRuntimeMap.get(serviceItem.serviceSpecId);
                if (serviceSpecRuntime == null) continue;
                Service service = serviceItem.toService(this.contractId, this.tvAccountId);
                serviceEntryList.add(new ServiceEntry(serviceSpecRuntime, service, service, serviceItem.deviceState, serviceItem.deviceState));
            }
            Product product = productItem.toProduct(this.contractId, this.tvAccountId);
            ProductPeriodRuntimeList.ProductPeriodItem productPeriodItem = productPeriodRuntimeList.getLast(productItem.productId);
            if (productPeriodItem != null) {
                product.setSubscriptionTimeFrom(productPeriodItem.prolongationTime != 0L ? new Date(productPeriodItem.prolongationTime) : new Date(productPeriodItem.timeFrom));
                product.setSubscriptionTimeTo(new Date(productPeriodItem.timeTo));
            }
            result.add(new ProductEntry(productSpecRuntime, product, product, productItem.deviceState, productItem.deviceState, serviceEntryList));
        }
        return result;
    }
}

