/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.servlet;

import bitel.billing.server.contract.logon.ContractLogonLast;
import bitel.billing.server.contract.logon.ContractLogonLockCache;
import bitel.billing.server.contract.logon.LogonManager;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.annotation.WebInitParam;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.auth.AuthModes;
import ru.bitel.bgbilling.kernel.auth.ModuleUser;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerContract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerLink;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.CustomerDao;
import ru.bitel.bgbilling.kernel.contract.function.server.PasswordManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ContractWebLoginEvent;
import ru.bitel.bgbilling.kernel.pc.server.BGPCFilter;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;

@BGPCFilter
@WebFilter(filterName="BGAuthFilter", urlPatterns={"/webexecuter/*"}, initParams={@WebInitParam(name="sort", value="2")})
public class BGAuthFilter
implements Filter {
    private static Logger log = LogManager.getLogger();
    private Setup _setup;
    private String authPage = "/pubexecuter?module=admin&action=Login";
    private ContractLogonLockCache logonLockCache;
    private ServletContext servletContext;
    private Map<Integer, List<Integer>> authModes = new HashMap<Integer, List<Integer>>();
    private boolean saveAllError = false;
    private long setupInitDate = 0L;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._setup = Setup.getSetup();
        this.logonLockCache = new ContractLogonLockCache();
        this.servletContext = filterConfig.getServletContext();
        this.servletContext.setAttribute("logonLockCache", (Object)this.logonLockCache);
        this.saveAllError = this._setup.getInt("web.error.all", 0) != 0;
        log.debug("init filter " + filterConfig.getFilterName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.setupInitDate = AuthModes.loadConfig(this._setup, this.setupInitDate, this.authModes);
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpSession session = request.getSession();
        Integer clid = (Integer)session.getAttribute("clientid");
        log.trace("clid={}", (Object)clid);
        if (clid != null && !this.checkContractId(request)) {
            session.invalidate();
            clid = null;
            session = request.getSession();
        }
        if (clid == null) {
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            User user = this.getLoginAndPassword(request);
            if (user == null) {
                this.error("userNull", request, response);
                return;
            }
            this.checkPasswordOnce(user);
            if (log.isDebugEnabled()) {
                log.debug("user = [{}]; midAuth={}", (Object)user.toString(), (Object)request.getParameter("midAuth"));
            }
            if (user.name == null) {
                this.error("userNameNull", request, response);
                return;
            }
            request.setAttribute("user", (Object)user);
            request.setAttribute("userName", (Object)user.name);
            Date lockTime = this.logonLockCache.checkLogonLock(user.name);
            if (lockTime != null) {
                request.setAttribute("lockTime", (Object)lockTime);
                this.error("accountLock", request, response);
                return;
            }
            ModuleUser moduleUser = AuthModes.findModuleUserUserByLogin(user.name, request.getParameter("midAuth"), this.authModes);
            if (moduleUser == null) {
                if (this.saveAllError) {
                    this.saveContractLogonError(-1, ServletUtils.getIpFromHeader(request, this._setup), request);
                }
                this.error("loginNotFound", request, response);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("moduleUser = [{}]", (Object)moduleUser.toString());
            }
            int contractId = moduleUser.getContractId();
            this.logonLockCache.updateLogonLock(contractId, user.name);
            lockTime = this.logonLockCache.checkLogonLock(user.name);
            if (lockTime != null) {
                request.setAttribute("lockTime", (Object)lockTime);
                this.error("accountLock", request, response);
                return;
            }
            String userPasswordDigest = Utils.getDigest((String)user.password, (String)"utf-8");
            String passwordType = null;
            if (user.passwordOnce != null) {
                passwordType = "p";
            } else if (userPasswordDigest.equals(this._setup.get("web.admin.password", ""))) {
                passwordType = "a";
            } else if (moduleUser.getPassword().equals(user.password) || moduleUser.getPassword().equals(userPasswordDigest)) {
                passwordType = "c";
            }
            String remoteAddr = ServletUtils.getIpFromHeader(request, this._setup);
            if (passwordType == null) {
                this.updateContractLogonLast(contractId, 1, remoteAddr);
                this.saveContractLogonError(contractId, remoteAddr, request);
                this.logonLockCache.updateLogonLock(contractId, user.name);
                lockTime = this.logonLockCache.checkLogonLock(user.name);
                request.setAttribute("lockTime", (Object)lockTime);
                this.error("passwordInvalid", request, response);
                return;
            }
            if (!this.logon(contractId, request, response, session, remoteAddr, passwordType)) {
                return;
            }
            ServerContext context = new ServerContext(this._setup, ConnectionSet.newInstance((DefaultServerSetup)this._setup, (boolean)false), 0, 0);
            ThreadContext parentContext = ThreadContext.push((ThreadContext)context);
            try {
                EventProcessor.getInstance().request(new ContractWebLoginEvent(request, contractId));
                context.commit();
            }
            catch (BGException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                ThreadContext.pop((ThreadContext)context, (ThreadContext)parentContext);
            }
            String reference = (String)session.getAttribute("reference");
            if (reference != null) {
                response.sendRedirect(reference);
                session.removeAttribute("reference");
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean logon(int contractId, HttpServletRequest request, HttpServletResponse response, HttpSession session, String remoteAddr, String passwordType) throws IOException {
        try (Connection con = this._setup.getDBSlaveConnectionFromPool();
             ContractDao contractDao = new ContractDao(con, 0);){
            Contract contract = (Contract)contractDao.get(contractId);
            List denyStatuses = Utils.toIntegerList((String)this._setup.get("web.auth.deny.statuses", null));
            boolean periodCloseFlag = this._setup.getBoolean("web.auth.deny.periodClose", false);
            boolean err = denyStatuses.contains(contract.getStatus());
            if (err || periodCloseFlag && TimeUtils.dateBefore((Date)contract.getDateTo(), (Date)new Date())) {
                this.error(err ? "denyStatus" : "denyClosedPeriod", request, response);
                boolean bl = false;
                return bl;
            }
            this.updateContractLogonLast(contractId, -1, remoteAddr);
            this.saveContractLogonOk(contractId, remoteAddr, request.getSession().getId(), passwordType);
            session.setAttribute("clientid", (Object)contractId);
            session.setAttribute("userName", (Object)contract.getTitle());
            session.setAttribute("contract_current", (Object)contract);
            if (contract.isIndependSub()) {
                session.setAttribute("contract_general", (Object)contract);
            } else if (contract.isSuper()) {
                session.setAttribute("contract_general", (Object)contract);
                session.setAttribute("contract_sublist", contractDao.getSubContracts(contract.getId()));
            } else {
                session.setAttribute("contract_general", (Object)contractDao.get(contract.getSuperCid()));
                session.setAttribute("contract_sublist", contractDao.getSubContracts(contract.getSuperCid()));
            }
            try {
                CustomerDao customerDao = new CustomerDao(con);
                Optional<CustomerLink> optional = customerDao.getCustomerLink(contractId, LocalDateTime.now());
                if (!optional.isPresent()) return true;
                ArrayList<Contract> list = new ArrayList<Contract>();
                Iterator<CustomerContract> iterator = customerDao.getCustomerContracts(optional.get().getCustomerId(), LocalDateTime.now()).iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        session.setAttribute("customer_contracts", list);
                        return true;
                    }
                    CustomerContract customerContract = iterator.next();
                    list.add((Contract)contractDao.get(customerContract.getContractId()));
                }
            }
            catch (Exception ex) {
                log.error((Object)ex);
                return true;
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        return true;
    }

    private boolean checkContractId(HttpServletRequest request) {
        boolean result;
        HttpSession session = request.getSession();
        int contractId = Utils.parseInt((String)request.getParameter("contractId"), (int)-1);
        boolean bl = result = contractId < 1;
        if (!result) {
            Contract contract = (Contract)((Object)session.getAttribute("contract_current"));
            boolean bl2 = result = contract.getId() == contractId;
            if (!result) {
                contract = (Contract)((Object)session.getAttribute("contract_general"));
                boolean bl3 = result = contract.getId() == contractId;
                if (!result) {
                    contract = this.checkContractInList((List)session.getAttribute("contract_sublist"), contractId);
                    boolean bl4 = result = contract != null;
                }
                if (!result) {
                    contract = this.checkContractInList((List)session.getAttribute("customer_contracts"), contractId);
                    boolean bl5 = result = contract != null;
                }
                if (result) {
                    session.setAttribute("contract_current", (Object)contract);
                    session.setAttribute("clientid", (Object)contract.getId());
                }
            }
        }
        return result;
    }

    private Contract checkContractInList(List<?> contracts, int contractId) {
        if (contracts != null) {
            for (Object object : contracts) {
                Contract testContract;
                if (!(object instanceof Contract) || (testContract = (Contract)((Object)object)).getId() != contractId) continue;
                return testContract;
            }
        }
        return null;
    }

    public void destroy() {
    }

    private User getLoginAndPassword(HttpServletRequest request) {
        User user = null;
        String userName = request.getParameter("user");
        String userIp = request.getParameter("userIp");
        String userPassword = request.getParameter("pswd");
        String userPasswordOnce = request.getParameter("passwordOnce");
        if (userName != null && userPassword != null) {
            user = new User(this);
            user.name = userName;
            user.password = userPassword;
        } else if (userIp != null) {
            user = new User(this);
            user.name = ServletUtils.getIpFromHeader(request, this._setup);
            user.password = AuthModes.passwordless();
        } else if (userPasswordOnce != null) {
            user = new User(this);
            user.passwordOnce = userPasswordOnce;
        }
        return user;
    }

    private void error(String error, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("error: {}", (Object)error);
        }
        String page = this.authPage;
        request.setAttribute("error", (Object)error);
        Optional.ofNullable(request.getSession()).ifPresent(e -> e.invalidate());
        String ct = request.getParameter("ct");
        if (ct == null) {
            ct = request.getParameter("contentType");
        }
        if (ct == null) {
            ct = "jsp";
        }
        if ("json".equals(ct)) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("status", "error");
            dataMap.put("errorCode", request.getAttribute("error"));
            dataMap.put("lockTime", request.getAttribute("lockTime"));
            dataMap.put("user", request.getAttribute("user"));
            dataMap.put("userName", request.getAttribute("userName"));
            JSONObject jsonObject = new JSONObject(dataMap);
            String type = request.getHeader("Content-Type");
            String contentType = "application/json";
            if (type != null && type.startsWith("multipart/form-data")) {
                contentType = "text/plain";
            }
            response.setContentType(contentType + "; charset=UTF-8");
            try (PrintWriter out = response.getWriter();){
                out.print(jsonObject.toString());
                out.flush();
            }
        }
        if (request.getParameter("user") != null) {
            page = "/pubexecuter?module=admin&action=authError";
            RequestDispatcher dispatcher = request.getRequestDispatcher(page);
            try {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException ex) {
                log.error((Object)ex);
                response.sendRedirect(page + "&error=" + error);
            }
            return;
        }
        if (request.getQueryString() != null) {
            StringBuilder sb = new StringBuilder().append(request.getRequestURL().toString()).append("?").append(request.getQueryString());
            request.getSession().setAttribute("reference", (Object)sb.toString());
        }
        request.setAttribute("error", (Object)"parameterLoginAndPasswordNotFound");
        if ("XMLHttpRequest".equals(request.getHeader("X-Requested-With"))) {
            response.setHeader("bg-redirect-to", this.servletContext.getContextPath() + page);
        } else {
            response.sendRedirect(this.servletContext.getContextPath() + page);
        }
    }

    private void saveContractLogonOk(int contractId, String remoteAddr, String sessionId, String user) {
        try (Connection con = this._setup.getDBConnectionFromPool();){
            new LogonManager(con).saveLogonOk(contractId, remoteAddr, sessionId, user);
        }
        catch (Exception e) {
            log.error("error save contract logon ok", (Throwable)e);
        }
    }

    private void saveContractLogonError(int contractId, String remoteAddr, HttpServletRequest request) {
        try (Connection con = this._setup.getDBConnectionFromPool();){
            new LogonManager(con).saveLogonError(contractId, remoteAddr, request);
        }
        catch (Exception e) {
            log.error("error save contract logon error", (Throwable)e);
        }
    }

    private void updateContractLogonLast(int contractId, int n, String remoteAddr) {
        if (contractId > 0) {
            try (Connection con = this._setup.getDBConnectionFromPool();){
                LogonManager logonManager = new LogonManager(con);
                ContractLogonLast contractLogonLast = logonManager.getContractLogonLast(contractId);
                if (contractLogonLast != null && contractLogonLast.getDateTime().getTime() < System.currentTimeMillis() - 86400000L) {
                    int logonLogRecord = this._setup.getInt("logon.log.record", 100);
                    int logonLogPeriod = this._setup.getInt("logon.log.period", 100);
                    logonManager.clearLogonOkLog(contractId, logonLogRecord, logonLogPeriod);
                    logonManager.clearLogonErrorLog(contractId, logonLogRecord, logonLogPeriod);
                }
                logonManager.updateContractLogonLast(contractId, n, remoteAddr);
            }
            catch (Exception e) {
                log.error("error update contract logon last", (Throwable)e);
            }
        }
    }

    private void checkPasswordOnce(User user) {
        if (user != null && user.name == null && user.passwordOnce != null) {
            try (Connection con = this._setup.getDBConnectionFromPool();){
                PasswordManager passwordManager = new PasswordManager(con);
                user.name = passwordManager.findContractTitle(user.passwordOnce);
                passwordManager.deleteContractTitle(user.passwordOnce);
            }
            catch (Exception ex) {
                log.error("error check password once", (Throwable)ex);
            }
        }
    }

    class User {
        public String name = null;
        public String password = null;
        public String passwordOnce = null;

        User(BGAuthFilter this$0) {
        }

        public String toString() {
            return "name=" + this.name + "; password=" + "*".repeat(this.password != null ? this.password.length() : 0) + "; passwordOnce=" + this.passwordOnce;
        }
    }
}

