/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean;

import java.sql.Connection;
import java.time.LocalDate;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter.ContractParameterGroupAttrDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.util.MacrosFormat;

public class BGMacrosFormat
extends MacrosFormat {
    private final Connection con;
    private final int contractId;
    private Contract contract;
    private BalanceUtils balanceUtils;
    private ContractDao contractDao;
    private List<ContractParameterGroupAttr> prefs;

    public List<ContractParameterGroupAttr> getContractParameterPref() {
        if (this.prefs == null) {
            try (ContractParameterGroupAttrDao dao = new ContractParameterGroupAttrDao(this.con);){
                this.prefs = dao.list();
            }
            catch (BGException e) {
                e.printStackTrace();
            }
        }
        return this.prefs;
    }

    public BalanceUtils getBalanceUtils() {
        if (this.balanceUtils == null) {
            this.balanceUtils = new BalanceUtils(this.con);
        }
        return this.balanceUtils;
    }

    public ContractDao getContractDao() {
        if (this.contractDao == null) {
            this.contractDao = new ContractDao(this.con, 0);
        }
        return this.contractDao;
    }

    public Contract getContract(int contractId) throws Exception {
        if (this.contract == null || this.contract.getId() != contractId) {
            this.contract = (Contract)this.getContractDao().get(contractId);
        }
        return this.contract;
    }

    public Optional<Contract> optContract(int contractId) {
        try {
            return Optional.ofNullable(this.getContract(contractId));
        }
        catch (Exception ex) {
            this.logError(ex);
            return Optional.empty();
        }
    }

    public BGMacrosFormat(Connection con, int contractId) {
        this.con = con;
        this.contractId = contractId;
    }

    public BGMacrosFormat(Connection con, Contract contract) {
        this.con = con;
        this.contractId = contract != null ? contract.getId() : 0;
        this.contract = contract;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object invoke(String macros, Object[] args) {
        if ("contract_param".equals(macros)) {
            if (args.length <= 0) return null;
            int parameterId = this.getInt(args, 0, 0);
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                ContractParameterGroupAttr pref;
                Iterator<ContractParameterGroupAttr> iterator = this.getContractParameterPref().iterator();
                do {
                    if (!iterator.hasNext()) return null;
                } while ((pref = iterator.next()).getId() != parameterId);
                switch (pref.getType()) {
                    case 1: {
                        String string = contractDao.optContractParameterTextAsString(this.contractId, parameterId).orElse("");
                        return string;
                    }
                    case 8: {
                        String string = contractDao.getContractParameterAddressAsString(this.contractId, parameterId).orElse("");
                        return string;
                    }
                }
                return null;
            }
            catch (Exception ex) {
                LogManager.getLogger().error((Object)ex);
                return null;
            }
        }
        if ("contract_balance".equals(macros)) {
            return this.getBalanceUtils().getBalance(LocalDate.now(), this.contractId);
        }
        if ("contract_title".equals(macros)) {
            return this.optContract(this.contractId).map(IdTitle::getTitle).orElse(null);
        }
        if (!"contract_comment".equals(macros)) return null;
        return this.optContract(this.contractId).map(Contract::getComment).orElse("");
    }
}

