/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin.bgsecure;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.CheckTree;
import bitel.billing.module.common.ModTreeNode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSAction;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ActionsPanel
extends BGPanel {
    private CheckTree tree;
    private ModTreeNode rootNode;
    private BGTextField searchField = new BGTextField();
    private JRadioButton radioStart = new JRadioButton("\u041d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f", false);
    private JRadioButton radioConteint = new JRadioButton("\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u0442", true);

    public ActionsPanel() {
        this.rootNode = new ModTreeNode();
        this.rootNode.setAttribute("id", "0");
        this.rootNode.setAttribute("type", "1");
        this.rootNode.setText("\u0412\u0441\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f");
        this.tree = new CheckTree(this.rootNode);
        this.jbInit();
    }

    private void jbInit() {
        this.searchField.setPromptText("\u041f\u043e\u0438\u0441\u043a( \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u043a\u043e\u043b-\u0432\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432 > 2 )", true, true);
        ButtonGroup radioGroup = new ButtonGroup();
        radioGroup.add(this.radioConteint);
        radioGroup.add(this.radioStart);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.tree), new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.searchField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.radioStart, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.radioConteint, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ActionsPanel.this.search(e.getDocument());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ActionsPanel.this.search(e.getDocument());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ActionsPanel.this.search(e.getDocument());
            }
        });
        ActionListener radioListener = e -> this.tree.search(this.searchField.getText(), this.radioConteint.isSelected());
        this.radioConteint.addActionListener(radioListener);
        this.radioStart.addActionListener(radioListener);
    }

    private void search(Document doc) {
        try {
            String text = doc.getText(0, doc.getLength());
            String string = text = text.length() < 3 ? "" : text;
            if (this.searchField.isNotPromtText()) {
                this.tree.search(text, this.radioConteint.isSelected());
            }
        }
        catch (BadLocationException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public void setData() {
        this.rootNode.removeAllChildren();
        final ModTreeNode loadTreeNode = new ModTreeNode();
        loadTreeNode.setText("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430");
        this.tree.setTreeTopNode(loadTreeNode);
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (loadTreeNode.getText().length() > 15) {
                    loadTreeNode.setText("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430");
                }
                loadTreeNode.setText(loadTreeNode.getText() + ".");
                ((DefaultTreeModel)ActionsPanel.this.tree.getModel()).reload();
            }
        }, 0L, 500L);
        try {
            this.buildActionsTree(this.getModuleActions());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        timer.cancel();
        this.tree.setTreeTopNode(this.rootNode);
        this.repaintTree();
    }

    public void repaintTree() {
        this.tree.revalidate();
        this.tree.repaint();
        this.tree.expandPath(new TreePath(this.rootNode.getPath()));
        this.revalidate();
        this.repaint();
    }

    private void buildActionsTree(org.w3c.dom.Document document) throws Exception {
        for (Element elem : XMLUtils.selectElements(document, "//actions")) {
            ModTreeNode moduleNode = new ModTreeNode();
            moduleNode.setAttribute("id", "0");
            moduleNode.setText(elem.getAttribute("title"));
            this.rootNode.add(moduleNode);
            this.loadChilds(elem.getAttribute("id"), elem, moduleNode);
        }
    }

    private void loadChilds(String mid, Element node, ModTreeNode treeNode) throws Exception {
        if (node != null && treeNode != null) {
            for (Element groupNode : XMLUtils.selectElements(node, "group")) {
                ModTreeNode groupTreeNode = new ModTreeNode();
                groupTreeNode.setAttribute("id", "0");
                groupTreeNode.setText(groupNode.getAttribute("title"));
                treeNode.add(groupTreeNode);
                this.loadChilds(mid, groupNode, groupTreeNode);
            }
            HashSet<CallSite> keySet = new HashSet<CallSite>();
            for (Element actionNode : XMLUtils.selectElements(node, "*[name()='action' or name()='service']")) {
                String key;
                String title = actionNode.getAttribute("title");
                if (!Utils.notEmptyString(title) || !keySet.add((CallSite)((Object)(key = mid + "_" + actionNode.getAttribute("id"))))) continue;
                ModTreeNode actionTreeNode = new ModTreeNode();
                actionTreeNode.setAttribute("id", key);
                actionTreeNode.setText(title);
                actionTreeNode.setEn(true);
                treeNode.add(actionTreeNode);
            }
        }
    }

    private org.w3c.dom.Document getModuleActions() throws Exception {
        Request request = new Request();
        request.setModule("admin.bgsecure");
        request.setAction("GetAllModuleActions");
        return XMLUtils.parseDocument(TransferManager.getBytes(request));
    }

    public void setActions(String actions) {
        this.tree.setCodes(actions);
    }

    public void setSelectedActions(List<BGSAction> actions) {
        if (Utils.isEmptyCollection(actions)) {
            this.tree.setCodes("");
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (BGSAction action : actions) {
            sb.append(action.mid).append("_").append(action.actionID).append(",");
        }
        String result = sb.toString();
        if (result.endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        this.tree.setCodes(result);
    }

    public void setDisabledActions(String actions) {
        this.tree.setDisabledNode(actions);
    }

    public String getActions() {
        return this.tree.getCodes();
    }

    public List<BGSAction> getSelectedActions() {
        String[] mas;
        ArrayList<BGSAction> actions = new ArrayList<BGSAction>();
        String codes = this.tree.getCodes();
        if (Utils.isBlankString(codes)) {
            return actions;
        }
        for (String actionLine : mas = codes.split(",")) {
            String[] action = actionLine.split("_");
            if (action.length <= 1) continue;
            String mid = action[0];
            BGSAction bgsAction = new BGSAction();
            bgsAction.mid = mid;
            bgsAction.actionID = action[1];
            actions.add(bgsAction);
        }
        return actions;
    }
}

