/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.tasks;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Set;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskRecalculator;
import ru.bitel.bgbilling.modules.megogo.server.tasks.Calculator;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class MegogoRecalculator
extends RunTaskRecalculator<Calculator> {
    private Set<Integer> contracts = null;
    private String comment;

    public MegogoRecalculator(int mid, Calendar dt, Set<Integer> contracts) {
        super(mid, dt, null);
        this.contracts = contracts;
        GregorianCalendar now = new GregorianCalendar();
        if (TimeUtils.monthsDelta((Calendar)dt, (Calendar)now) == 0) {
            this.dt = now;
        } else {
            Calendar endDay = (Calendar)dt.clone();
            endDay.set(5, endDay.getActualMaximum(5));
            this.dt = endDay;
        }
        this.dt.set(11, 23);
        this.comment = "\u041f\u0435\u0440\u0435\u0441\u0447\u0435\u0442 \u0437\u0430 " + TimeUtils.monthNames[dt.get(2)];
    }

    public void executeTask() {
        try {
            long start = System.currentTimeMillis();
            this.getLogger().info("Megogo Recalculator time: " + TimeUtils.format((Calendar)this.dt, (String)"dd.MM.yyyy HH"));
            Calculator calculator = this.createTask();
            calculator.startTask();
            long end = System.currentTimeMillis();
            this.getLogger().info("Duration of recalculating: " + TimeUtils.formatDeltaTime((long)((end - start) / 1000L)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected Calculator createTask() {
        Calculator calculator = new Calculator();
        calculator.setExecutingTime(this.dt);
        calculator.initTask(Setup.getSetup(), 0, "mid=" + this.mid + "\ncomment=" + this.comment);
        calculator.setCids(this.contracts == null ? null : Utils.toString(this.contracts));
        return calculator;
    }
}

