/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.organizer.server.bean;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.organizer.server.bean.JournalEntry;
import ru.bitel.bgbilling.plugins.organizer.server.bean.OrganizerCounter;
import ru.bitel.bgbilling.plugins.organizer.server.bean.OrganizerRecord;
import ru.bitel.bgbilling.plugins.organizer.server.bean.RecordFilter;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class OrganizerManager {
    public int RecordsTotal = 0;
    private Connection con;

    public OrganizerManager(Connection conn) {
        this.con = conn;
    }

    private void createRecordsTable() throws SQLException {
        String query = "CREATE TABLE organizer_records ( `id` INTEGER  AUTO_INCREMENT,  `cid` INTEGER ,  `uid` INTEGER ,  `created` DATE ,  `title` VARCHAR(70) ,  `comment` TEXT ,  `date_from` DATE ,  `date_to` DATE ,  `done` TINYINT(2) ,  `todo_uid` INTEGER ,  `todo_gid` INTEGER ,  `completed_uid` INTEGER ,  `completed_date` DATE ,  PRIMARY KEY (`id`) )";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.executeUpdate();
        ps.close();
    }

    private void createJournalTable() throws SQLException {
        String query = "CREATE TABLE organizer_journal ( `id` INTEGER  AUTO_INCREMENT,  `rid` INTEGER ,  `uid` INTEGER ,  `message` TEXT ,  `jdate` DATE ,  PRIMARY KEY (`id`) )";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.executeUpdate();
        ps.close();
    }

    public List<OrganizerRecord> getRecords(RecordFilter filter) throws SQLException {
        ArrayList<OrganizerRecord> records = new ArrayList<OrganizerRecord>();
        Object query = "";
        if (!ServerUtils.tableExists((Connection)this.con, (String)"organizer_records")) {
            this.createRecordsTable();
            return records;
        }
        if (filter.getRid() > 0) {
            query = "SELECT * FROM organizer_records WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement((String)query);
            ps.setInt(1, filter.getRid());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                OrganizerRecord rec = this.getRecordsFromRS(rs);
                records.add(rec);
            }
            return records;
        }
        query = "SELECT * FROM organizer_records WHERE ( (date_from>=? AND date_from<=?) OR  (date_to>=? AND date_to<=?) )";
        if (filter.getContains() != null && !"".equals(filter.getContains())) {
            query = (String)query + " AND (title LIKE ? OR comment LIKE ?)";
        }
        if (filter.getTodoGid() > 0) {
            query = (String)query + " AND todo_gid=? ";
        }
        if (filter.getTodoUid() > 0) {
            query = (String)query + " AND todo_uid=? ";
        }
        if (filter.isOnlydone()) {
            query = (String)query + " AND done=1 ";
            if (filter.getCompletedUid() > 0) {
                query = (String)query + " AND completed_uid=? ";
            }
            if (filter.getDonePeriod() != null) {
                query = (String)query + " AND completed_date>=? AND completed_date <= ? ";
            }
        }
        query = (String)query + " ORDER BY ID " + filter.getPage().sqlLimit();
        PreparedStatement ps = this.con.prepareStatement((String)query);
        int i = 5;
        if (filter.getContains() != null && !"".equals(filter.getContains())) {
            ps.setString(i++, "%" + filter.getContains() + "%");
            ps.setString(i++, "%" + filter.getContains() + "%");
        }
        if (filter.getTodoGid() > 0) {
            ps.setInt(i++, filter.getTodoGid());
        }
        if (filter.getTodoUid() > 0) {
            ps.setInt(i++, filter.getTodoUid());
        }
        if (filter.isOnlydone()) {
            if (filter.getCompletedUid() > 0) {
                ps.setInt(i++, filter.getCompletedUid());
            }
            if (filter.getDonePeriod() != null) {
                ps.setDate(i++, TimeUtils.convertDateToSqlDate((java.util.Date)filter.getDonePeriod().getDateFrom()));
                ps.setDate(i++, TimeUtils.convertDateToSqlDate((java.util.Date)filter.getDonePeriod().getDateTo()));
            }
        }
        ps.setDate(1, TimeUtils.convertDateToSqlDate((java.util.Date)filter.getTodoPeriod().getDateFrom()));
        ps.setDate(2, TimeUtils.convertDateToSqlDate((java.util.Date)filter.getTodoPeriod().getDateTo()));
        ps.setDate(3, TimeUtils.convertDateToSqlDate((java.util.Date)filter.getTodoPeriod().getDateFrom()));
        ps.setDate(4, TimeUtils.convertDateToSqlDate((java.util.Date)filter.getTodoPeriod().getDateTo()));
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            OrganizerRecord rec = this.getRecordsFromRS(rs);
            records.add(rec);
        }
        return records;
    }

    public int countTotalRecords(RecordFilter filter) throws SQLException {
        Object query = "";
        if (filter.getRid() > 0) {
            query = "SELECT id FROM organizer_records WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement((String)query);
            ps.setInt(1, filter.getRid());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return 1;
            }
            return 0;
        }
        query = " SELECT count(*) FROM organizer_records WHERE ( (date_from>=? AND date_from<=?) OR  (date_to>=? AND date_to<=?) )";
        if (filter.getContains() != null && !"".equals(filter.getContains())) {
            query = (String)query + " AND (title LIKE ? OR comment LIKE ?)";
        }
        if (filter.getTodoGid() > 0) {
            query = (String)query + " AND todo_gid=? ";
        }
        if (filter.getTodoUid() > 0) {
            query = (String)query + " AND todo_uid=? ";
        }
        if (filter.isOnlydone()) {
            query = (String)query + " AND done=1 ";
            if (filter.getCompletedUid() > 0) {
                query = (String)query + " AND completed_uid=? ";
            }
            if (filter.getDonePeriod() != null) {
                query = (String)query + " AND completed_date>=? AND completed_date <= ? ";
            }
        }
        PreparedStatement ps = this.con.prepareStatement((String)query);
        int i = 5;
        if (filter.getContains() != null && !"".equals(filter.getContains())) {
            ps.setString(i++, "%" + filter.getContains() + "%");
            ps.setString(i++, "%" + filter.getContains() + "%");
        }
        if (filter.getTodoGid() > 0) {
            ps.setInt(i++, filter.getTodoGid());
        }
        if (filter.getTodoUid() > 0) {
            ps.setInt(i++, filter.getTodoUid());
        }
        if (filter.isOnlydone()) {
            if (filter.getCompletedUid() > 0) {
                ps.setInt(i++, filter.getCompletedUid());
            }
            if (filter.getDonePeriod() != null) {
                ps.setDate(i++, TimeUtils.convertDateToSqlDate((java.util.Date)filter.getDonePeriod().getDateFrom()));
                ps.setDate(i++, TimeUtils.convertDateToSqlDate((java.util.Date)filter.getDonePeriod().getDateTo()));
            }
        }
        ps.setDate(1, TimeUtils.convertDateToSqlDate((java.util.Date)filter.getTodoPeriod().getDateFrom()));
        ps.setDate(2, TimeUtils.convertDateToSqlDate((java.util.Date)filter.getTodoPeriod().getDateTo()));
        ps.setDate(3, TimeUtils.convertDateToSqlDate((java.util.Date)filter.getTodoPeriod().getDateFrom()));
        ps.setDate(4, TimeUtils.convertDateToSqlDate((java.util.Date)filter.getTodoPeriod().getDateTo()));
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    private OrganizerRecord getRecordsFromRS(ResultSet rs) throws SQLException {
        OrganizerRecord rec = new OrganizerRecord();
        rec.setCid(rs.getInt("cid"));
        rec.setContractTitle(this.getContractTitle(rec.getCid()));
        rec.setComment(rs.getString("comment"));
        rec.setCreationDate(TimeUtils.convertSqlDateToDate((Date)rs.getDate("created")));
        Period period = new Period();
        period.setDateFrom((java.util.Date)rs.getDate("date_from"));
        period.setDateTo((java.util.Date)rs.getDate("date_to"));
        rec.setPeriod(period);
        rec.setDone(rs.getBoolean("done"));
        rec.setTitle(rs.getString("title"));
        rec.setTodoGid(rs.getInt("todo_gid"));
        rec.setTodoGroup(this.getTodoGroupName(rec.getTodoGid()));
        rec.setTodoUid(rs.getInt("todo_uid"));
        rec.setTodoUserName(this.getUserName(rec.getTodoUid()));
        rec.setId(rs.getInt("id"));
        rec.setUid(rs.getInt("uid"));
        rec.setUserName(this.getUserName(rec.getUid()));
        rec.setCompleteUid(rs.getInt("completed_uid"));
        rec.setWhoCompleted(this.getUserName(rec.getCompleteUid()));
        rec.setCompleteDate(TimeUtils.convertSqlDateToDate((Date)rs.getDate("completed_date")));
        try {
            rec.setStatus(rs.getInt("Status") >= 0 ? "\u041a \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044e" : "\u041f\u0420\u041e\u0421\u0420\u041e\u0427\u0415\u041d\u041e");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rec;
    }

    private String getUserName(int uid) throws SQLException {
        String username = "";
        if (uid <= 0) {
            return username;
        }
        String query = "SELECT name FROM user WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, uid);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            username = rs.getString(1);
        }
        rs.close();
        ps.close();
        return username;
    }

    private String getTodoGroupName(int gid) throws SQLException {
        String groupname = "";
        if (gid <= 0) {
            return groupname;
        }
        String query = "SELECT title FROM bgs_group WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, gid);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            groupname = rs.getString(1);
        }
        rs.close();
        ps.close();
        return groupname;
    }

    private String getContractTitle(int cid) throws SQLException {
        Object title = "";
        if (cid <= 0) {
            return title;
        }
        String query = "SELECT title, comment FROM contract WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, cid);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            title = rs.getString(1);
            String comm = rs.getString(2);
            if (!comm.isEmpty()) {
                title = (String)title + "[" + comm + "]";
            }
        }
        rs.close();
        ps.close();
        return title;
    }

    public OrganizerRecord getRecordById(int rid) throws SQLException {
        OrganizerRecord rec = null;
        String query = "SELECT * FROM organizer_records WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, rid);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            rec = this.getRecordsFromRS(rs);
        }
        rs.close();
        ps.close();
        return rec;
    }

    public void updateRecord(OrganizerRecord rec) throws SQLException {
        String query = "";
        PreparedStatement ps = null;
        if (rec.getId() == 0) {
            query = "INSERT INTO organizer_records (cid,uid,created,title,comment,date_from,date_to,done,todo_uid,todo_gid,completed_uid,completed_date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            ps = this.con.prepareStatement(query, 1);
        } else {
            query = "UPDATE organizer_records SET cid=?, uid=?, created=?,title=?,comment=?,date_from=?,date_to=?,done=?,todo_uid=?,todo_gid=?,completed_uid=?,completed_date=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(13, rec.getId());
        }
        ps.setInt(1, rec.getCid());
        ps.setInt(2, rec.getUid());
        ps.setDate(3, TimeUtils.convertDateToSqlDate((java.util.Date)rec.getCreationDate()));
        ps.setString(4, rec.getTitle());
        ps.setString(5, rec.getComment());
        ps.setDate(6, TimeUtils.convertDateToSqlDate((java.util.Date)rec.getPeriod().getDateFrom()));
        ps.setDate(7, TimeUtils.convertDateToSqlDate((java.util.Date)rec.getPeriod().getDateTo()));
        ps.setBoolean(8, rec.isDone());
        ps.setInt(9, rec.getTodoUid());
        ps.setInt(10, rec.getTodoGid());
        ps.setInt(11, rec.getCompleteUid());
        ps.setDate(12, TimeUtils.convertDateToSqlDate((java.util.Date)rec.getCompleteDate()));
        ps.executeUpdate();
        if (rec.getId() <= 0) {
            rec.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
    }

    public String getUserGroups(int uid) throws SQLException {
        StringBuilder result = new StringBuilder();
        if (uid > 0 && ServerUtils.tableExists((Connection)this.con, (String)"bgs_user_group")) {
            PreparedStatement ps = this.con.prepareStatement("SELECT gid FROM bgs_user_group WHERE uid=?");
            ps.setInt(1, uid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(rs.getString(1));
            }
            rs.close();
            ps.close();
        }
        return result.toString();
    }

    public void searchTodoRecords(SearchResult<OrganizerRecord> searchResult, int uid, int status) throws BGException {
        try {
            Page page = searchResult.getPage();
            if (!ServerUtils.tableExists((Connection)this.con, (String)"organizer_records")) {
                this.createRecordsTable();
                page.setRecordCount(0);
                return;
            }
            List list = searchResult.getList();
            StringBuilder query = new StringBuilder(" FROM organizer_records WHERE done = 0 AND date_from <= curDate() ");
            if (uid > 0) {
                String groups = this.getUserGroups(uid);
                query.append(" AND (todo_uid = ").append(uid).append((String)(!groups.isEmpty() ? " OR todo_gid IN (" + groups + ") ) " : ")"));
            }
            if (status > 0) {
                if (status == 1) {
                    query.append(" AND (date_to - curDate()) >= 0");
                } else if (status == 2) {
                    query.append(" AND (date_to - curDate()) < 0");
                }
            }
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(new StringBuffer("SELECT *, (date_to - curDate()) as Status").append((CharSequence)query).append(" ORDER BY Status").append(page.sqlLimit()).toString());
            while (rs.next()) {
                list.add(this.getRecordsFromRS(rs));
            }
            rs.close();
            st.close();
            st = this.con.createStatement();
            rs = st.executeQuery(new StringBuffer("SELECT COUNT(*)").append((CharSequence)query).toString());
            while (rs.next()) {
                page.setRecordCount(rs.getInt(1));
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    @Deprecated
    public List<OrganizerRecord> getTodoRecords(int uid, int status) throws BGException {
        SearchResult searchResult = new SearchResult(new Page(0, 0));
        this.searchTodoRecords((SearchResult<OrganizerRecord>)searchResult, uid, status);
        return searchResult.getList();
    }

    public OrganizerCounter countRecords(int uid) throws SQLException {
        String where;
        OrganizerCounter counter = new OrganizerCounter();
        Object query = "SELECT count(*) FROM organizer_records WHERE done = 0 AND date_from <= curDate() ";
        String groups = this.getUserGroups(uid);
        PreparedStatement ps = this.con.prepareStatement((String)(query = (String)query + " AND (todo_uid=" + uid + (String)(groups.isEmpty() ? ")" : " OR todo_gid IN (" + groups + ") )")) + (where = " AND (date_to - curDate()) >= 0 "));
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            counter.todoCount = rs.getInt(1);
        }
        rs.close();
        ps.close();
        where = " AND (date_to - curDate()) < 0 ";
        ps = this.con.prepareStatement((String)query + where);
        rs = ps.executeQuery();
        if (rs.next()) {
            counter.outofdateCount = rs.getInt(1);
        }
        rs.close();
        ps.close();
        return counter;
    }

    public void addToJournal(int rid, int userID, String messageType) throws SQLException {
        Object message = "";
        if (messageType.equals("marked_changed")) {
            message = (String)message + "\u0417\u0430\u0434\u0430\u043d\u0438\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e";
        } else if (messageType.equals("marked_done")) {
            message = (String)message + "\u0417\u0430\u0434\u0430\u043d\u0438\u0435 \u043e\u0442\u043c\u0435\u0447\u0435\u043d\u043e \u0412\u042b\u041f\u041e\u041b\u041d\u0415\u041d\u041d\u042b\u041c";
        } else if (messageType.equals("marked_undone")) {
            message = (String)message + "\u0417\u0430\u0434\u0430\u043d\u0438\u0435 \u043e\u0442\u043c\u0435\u0447\u0435\u043d\u043e \u041d\u0415\u0412\u042b\u041f\u041e\u041b\u041d\u0415\u041d\u041d\u042b\u041c!";
        } else if (messageType.equals("created")) {
            message = (String)message + "\u0417\u0430\u0434\u0430\u043d\u0438\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u043e";
        } else if (messageType.equals("deleted")) {
            message = (String)message + "\u0417\u0430\u0434\u0430\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u043e";
        } else {
            message = (String)message + "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043d\u0430\u0434 \u0437\u0430\u043f\u0438\u0441\u044c\u044e.";
            message = (String)message + rid;
        }
        if (!ServerUtils.tableExists((Connection)this.con, (String)"organizer_journal")) {
            this.createJournalTable();
        }
        String query = "INSERT INTO organizer_journal (rid,uid,message,jdate)  VALUES (?, ?, ?, ?)";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, rid);
        ps.setInt(2, userID);
        ps.setString(3, (String)message);
        ps.setDate(4, TimeUtils.convertCalendarToSqlDate((Calendar)new GregorianCalendar()));
        ps.executeUpdate();
        ps.close();
    }

    public void deleteRecordById(int rid) throws SQLException {
        String query = "DELETE FROM organizer_records WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, rid);
        ps.executeUpdate();
        ps.close();
    }

    @Deprecated
    public void deleteRecordByID(int rid) throws SQLException {
        this.deleteRecordById(rid);
    }

    public List<JournalEntry> getJournalList(Page page, Period period, int uid) throws SQLException {
        ArrayList<JournalEntry> list = new ArrayList<JournalEntry>();
        if (!ServerUtils.tableExists((Connection)this.con, (String)"organizer_journal")) {
            this.createJournalTable();
            return list;
        }
        Object query = "SELECT * FROM organizer_journal WHERE jdate>=? AND jdate<=? ";
        if (uid > 0) {
            query = (String)query + " AND uid=?";
        }
        query = (String)query + " ORDER BY jdate " + page.sqlLimit();
        PreparedStatement ps = this.con.prepareStatement((String)query);
        ps.setDate(1, TimeUtils.convertDateToSqlDate((java.util.Date)period.getDateFrom()));
        ps.setDate(2, TimeUtils.convertDateToSqlDate((java.util.Date)period.getDateTo()));
        if (uid > 0) {
            ps.setInt(3, uid);
        }
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            JournalEntry entry = new JournalEntry();
            entry.setDate(TimeUtils.convertSqlDateToDate((Date)rs.getDate("jdate")));
            entry.setId(rs.getInt("id"));
            entry.setMessage(rs.getString("message"));
            entry.setUid(rs.getInt("uid"));
            entry.setName(this.getUserName(entry.getUid()));
            entry.setRid(rs.getInt("rid"));
            list.add(entry);
        }
        rs.close();
        ps.close();
        return list;
    }

    public int countJournalList(Page page, Period per, int uid) throws SQLException {
        ResultSet rs;
        Object query = "SELECT count(*) FROM organizer_journal WHERE jdate>=? AND jdate<=? ";
        if (uid > 0) {
            query = (String)query + " AND uid=?";
        }
        query = (String)query + " ORDER BY jdate";
        PreparedStatement ps = this.con.prepareStatement((String)query);
        ps.setDate(1, TimeUtils.convertDateToSqlDate((java.util.Date)per.getDateFrom()));
        ps.setDate(2, TimeUtils.convertDateToSqlDate((java.util.Date)per.getDateTo()));
        if (uid > 0) {
            ps.setInt(3, uid);
        }
        if ((rs = ps.executeQuery()).next()) {
            return rs.getInt(1);
        }
        rs.close();
        ps.close();
        return 0;
    }
}

