/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItem;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttribute;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeValue;
import ru.bitel.bgbilling.plugins.shop.server.dao.StockItemAttributeDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class StockItemAttributeValueDao
extends AbstractIdDao<StockItemAttributeValue> {
    private final StockItemAttributeDao stockItemAttributeDao;

    public StockItemAttributeValueDao(Connection con, int moduleId, StockItemAttributeDao stockItemAttributeDao) {
        super(con, "stock_item_attribute_value", moduleId);
        this.stockItemAttributeDao = stockItemAttributeDao;
    }

    protected StockItemAttributeValue getFromRS(ResultSet rs) throws SQLException, BGException {
        StockItemAttributeValue value = new StockItemAttributeValue();
        value.setId(rs.getInt("id"));
        value.setStockItemId(rs.getInt("stock_item_id"));
        value.setValue(rs.getString("value"));
        value.setAttribute((StockItemAttribute)this.stockItemAttributeDao.get(rs.getInt("attribute_id")));
        return value;
    }

    protected void updateImpl(StockItemAttributeValue stockItemAttributeValue) throws BGException, SQLException {
        boolean isNew = stockItemAttributeValue.getId() <= 0;
        String prefix = isNew ? "INSERT INTO " : "UPDATE ";
        String query = prefix + this.tableName + " SET value=?, attribute_id=?, stock_item_id=?" + (isNew ? "" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setString(1, stockItemAttributeValue.getValue());
            ps.setInt(2, stockItemAttributeValue.getAttribute().getId());
            ps.setInt(3, stockItemAttributeValue.getStockItemId());
            if (!isNew) {
                ps.setInt(3, stockItemAttributeValue.getId());
            }
            ps.executeUpdate();
            if (isNew) {
                stockItemAttributeValue.setId(ServerUtils.lastInsertId((Connection)this.con));
            }
        }
    }

    public List<StockItemAttributeValue> getValuesByStockItem(int stockItemId) throws BGException {
        ArrayList<StockItemAttributeValue> result = new ArrayList<StockItemAttributeValue>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE stock_item_id=?");){
            ps.setInt(1, stockItemId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public void updateValuesByStockItem(StockItem stockItem) throws Exception {
        if (Utils.isEmptyCollection((Collection)stockItem.getAttributeValues())) {
            return;
        }
        for (StockItemAttributeValue attributeValue : stockItem.getAttributeValues()) {
            attributeValue.setStockItemId(stockItem.getId());
            this.update(attributeValue);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkUniqueValueByAttribute(StockItemAttributeValue attributeValue) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("SELECT id FROM " + this.tableName + " WHERE attribute_id=? AND value=?");){
            ps.setInt(1, attributeValue.getAttribute().getId());
            ps.setString(2, attributeValue.getValue().trim());
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return true;
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

