/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.common.model;

import bitel.billing.common.ModelItem;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCall;
import ru.bitel.common.model.ListItem;

public class RegisterProblem
extends ModelItem
implements ListItem {
    private static final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    public static final String FIELD_ID = "id";
    public static final String FIELD_STATUS = "status";
    public static final String FIELD_URGENCY = "urgency";
    public static final String FIELD_COMMENT = "comment";
    public static final String FIELD_GROUP_ID = "group_id";
    public static final String FIELD_RESOLUTION = "resolution";
    public static final String FIELD_CATEGORY_ID = "category_id";
    public static final String FIELD_OBJECT_ID = "object_id";
    public static final String FIELD_OPEN_TIME = "open_time";
    public static final String FIELD_OPEN_USER_ID = "open_user_iD";
    public static final String FIELD_STATUS_TIME = "accept_time";
    public static final String FIELD_STATUS_USER_ID = "accept_user_id";
    public static final String FIELD_CLOSE_TIME = "close_time";
    public static final String FIELD_CLOSE_USER_ID = "close_user_id";
    public static final String STATUS_LIST = "0:\u043e\u0442\u043a\u0440\u044b\u0442\u0430;1:\u043f\u0440\u0438\u043d\u044f\u0442\u0430;2:\u0437\u0430\u043a\u0440\u044b\u0442\u0430";
    private List<String> executors;
    private List<RegisterCall> calls;
    private List<String> tasks;

    public RegisterProblem() {
        super("register_problem");
        this.keys.add(FIELD_ID);
        this.setValue(FIELD_ID, -1);
        this.keys.add(FIELD_OBJECT_ID);
        this.keys.add(FIELD_OPEN_TIME);
        this.keys.add(FIELD_OPEN_USER_ID);
        this.setValue(FIELD_OPEN_USER_ID, -10);
        this.keys.add(FIELD_STATUS_TIME);
        this.keys.add(FIELD_STATUS_USER_ID);
        this.setValue(FIELD_STATUS_USER_ID, -10);
        this.keys.add(FIELD_CLOSE_TIME);
        this.keys.add(FIELD_CLOSE_USER_ID);
        this.setValue(FIELD_CLOSE_USER_ID, -10);
        this.keys.add(FIELD_STATUS);
        this.keys.add(FIELD_URGENCY);
        this.keys.add(FIELD_COMMENT);
        this.setValue(FIELD_COMMENT, "");
        this.keys.add(FIELD_GROUP_ID);
        this.keys.add(FIELD_RESOLUTION);
        this.setValue(FIELD_RESOLUTION, "");
    }

    public int getId() {
        return this.getIntValue(FIELD_ID);
    }

    public void setId(int id) {
        this.setValue(FIELD_ID, id);
    }

    public void setOpenUserId(int openUserId) {
        this.setValue(FIELD_OPEN_USER_ID, openUserId);
    }

    public void setCloseUserId(int closeUserId) {
        this.setValue(FIELD_CLOSE_USER_ID, closeUserId);
    }

    public void setStatus(int status) {
        this.setValue(FIELD_STATUS, status);
    }

    public void setUrgency(int urgency) {
        this.setValue(FIELD_URGENCY, urgency);
    }

    public void setComment(String comment) {
        this.setValue(FIELD_COMMENT, comment);
    }

    public void setGroupId(int groupId) {
        this.setValue(FIELD_GROUP_ID, groupId);
    }

    public void setResolution(String resolution) {
        this.setValue(FIELD_RESOLUTION, resolution);
    }

    public void setStatusUserId(int userId) {
        this.setValue(FIELD_STATUS_USER_ID, userId);
    }

    public void setExecutors(List<String> executors) {
        this.executors = executors;
    }

    public void setCategoryId(int categoryId) {
        this.setValue(FIELD_CATEGORY_ID, categoryId);
    }

    public void setCalls(List<RegisterCall> calls) {
        this.calls = calls;
    }

    public void setOpenTime(Date date) {
        this.setValue(FIELD_OPEN_TIME, date);
    }

    public void setCloseTime(Date date) {
        this.setValue(FIELD_CLOSE_TIME, date);
    }

    public void setStatusTime(Date date) {
        this.setValue(FIELD_STATUS_TIME, date);
    }

    public void setTasks(List<String> tasks) {
        this.tasks = tasks;
    }

    public int getOpenUserId() {
        return this.getIntValue(FIELD_OPEN_USER_ID);
    }

    public int getCloseUserId() {
        return this.getIntValue(FIELD_CLOSE_USER_ID);
    }

    public int getStatus() {
        return this.getIntValue(FIELD_STATUS);
    }

    public int getUrgency() {
        return this.getIntValue(FIELD_URGENCY);
    }

    public String getComment() {
        return this.getValue(FIELD_COMMENT);
    }

    public int getGroupId() {
        return this.getIntValue(FIELD_GROUP_ID);
    }

    public String getResolution() {
        return this.getValue(FIELD_RESOLUTION);
    }

    public int getStatusUserId() {
        return this.getIntValue(FIELD_STATUS_USER_ID);
    }

    public List<String> getExecutors() {
        return this.executors;
    }

    public int getCategoryId() {
        return this.getIntValue(FIELD_CATEGORY_ID);
    }

    public List<RegisterCall> getCalls() {
        return this.calls;
    }

    public Date getOpenTime() {
        return this.getDateValue(FIELD_OPEN_TIME);
    }

    public String getOpenTimeAsString() {
        return this.getValue(FIELD_OPEN_TIME);
    }

    public Date getCloseTime() {
        return this.getDateValue(FIELD_CLOSE_TIME);
    }

    public String getCloseTimeAsString() {
        return this.getValue(FIELD_CLOSE_TIME);
    }

    public Date getStatusTime() {
        return this.getDateValue(FIELD_STATUS_TIME);
    }

    public String getStatusTimeAsString() {
        return this.getValue(FIELD_STATUS_TIME);
    }

    public List<String> getTasks() {
        return this.tasks;
    }

    public boolean equals(Object obj) {
        return obj instanceof RegisterProblem && ((RegisterProblem)((Object)obj)).getId() == this.getId();
    }

    public int getObjectId() {
        return this.getIntValue(FIELD_OBJECT_ID);
    }

    public void setObjectId(int objectId) {
        this.setValue(FIELD_OBJECT_ID, objectId);
    }

    public String getTitle() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.getId());
        builder.append(") ");
        builder.append(this.getComment());
        return builder.toString();
    }

    public void setValue(String key, Date value) {
        if (value != null) {
            this.setValue(key, dateFormat.format(value));
        }
    }

    public Date getDateValue(String key) {
        Date date = null;
        String stringDate = this.getValue(key);
        if (stringDate != null && !stringDate.equals("00.00.0000") && !stringDate.equals("")) {
            try {
                date = dateFormat.parse(stringDate);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private RegisterProblem registerProblem = new RegisterProblem();

        private Builder() {
        }

        public Builder setObjectId(int objectId) {
            this.registerProblem.setValue(RegisterProblem.FIELD_OBJECT_ID, objectId);
            return this;
        }

        public Builder setOpenTime(Date date) {
            this.registerProblem.setValue(RegisterProblem.FIELD_OPEN_TIME, date);
            return this;
        }

        public Builder setOpenUserId(int openUserId) {
            this.registerProblem.setValue(RegisterProblem.FIELD_OPEN_USER_ID, openUserId);
            return this;
        }

        public Builder setStatusTime(Date date) {
            this.registerProblem.setValue(RegisterProblem.FIELD_STATUS_TIME, date);
            return this;
        }

        public Builder setStatusUserId(int userId) {
            this.registerProblem.setValue(RegisterProblem.FIELD_STATUS_USER_ID, userId);
            return this;
        }

        public Builder setComment(String comment) {
            this.registerProblem.setValue(RegisterProblem.FIELD_COMMENT, comment);
            return this;
        }

        public Builder setGroupId(int groupId) {
            this.registerProblem.setValue(RegisterProblem.FIELD_GROUP_ID, groupId);
            return this;
        }

        public RegisterProblem build() {
            return this.registerProblem;
        }
    }
}

