<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" encoding="UTF-8" indent="yes"/>

<xsl:template match="/data">
<html>
<head>
 <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
 </head>
<body>
    <center>
    	<h2>Отчет по журналу проблем</h2>
    	<xsl:call-template name="table"/><br/>
    	<xsl:call-template name="sums"/><br/>
     </center>    
</body>
</html>
</xsl:template>

<xsl:template name="table">
<table width="100%" border="1" cellspacing="0" cellpadding="3">
     <tr bgcolor="#f0f0f0">
         <td>Код</td>
         <td>Срочность</td>
         <td>Группа</td>
         <td>Комментарий</td>
         <td>Статус</td>
         <td>Время</td>
         <td>Решение</td>
     </tr>
     <xsl:for-each select="/data/table/data/row">
         <tr bgcolor="#ffffff">
             <td>&#160;<xsl:value-of select="@id"/></td>
             <td>&#160;<xsl:value-of select="substring-after(@urgency,';')"/></td>
             <td>&#160;<xsl:value-of select="@group"/></td>
             <td>&#160;<xsl:value-of select="@comment"/></td>
             <td>&#160;<xsl:value-of select="@status"/></td>
             <td>&#160;<xsl:value-of select="@status_time"/></td>
             <td>&#160;<xsl:value-of select="@resolution"/></td>
         </tr>
     </xsl:for-each>         
</table>
</xsl:template>

<xsl:template name="sums">
	<br />
	Итого проблем:&#160;
	<xsl:value-of select="count(/data/table/data/row)" />
	&#160;Отчет&#160;сформировал(а):&#160;
	<xsl:value-of select="/data/@userName" />
</xsl:template>

</xsl:stylesheet>
