/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client.table;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.AbstractBGTableModel;
import ru.bitel.common.client.table.AbstractBGUTable;
import ru.bitel.common.client.table.BGTableModelColumn;
import ru.bitel.common.client.table.Column;

public abstract class BasicBGTableModel<K>
extends AbstractBGTableModel {
    List<BGTableModelColumn<K>> columns = new ArrayList<BGTableModelColumn<K>>();
    protected AbstractBGUTable<?> table;
    protected final Class<K> clazz;

    public BasicBGTableModel(String name) {
        this(name, null);
    }

    public BasicBGTableModel(String name, Class<K> clazz) {
        super(name);
        this.clazz = clazz == null && this.getClass().getGenericSuperclass() instanceof ParameterizedType && ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0] instanceof Class ? (Class<Object>)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0] : clazz;
        this.initColumns();
    }

    public String getIdentifier(int columnIndex) {
        return columnIndex > -1 && columnIndex < this.columns.size() ? this.columns.get((int)columnIndex).name : null;
    }

    public TableCellRenderer getTableCellRenderer(int columnIndex) {
        return columnIndex > -1 && columnIndex < this.columns.size() ? this.columns.get(columnIndex).getTableCellRenderer() : null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex > -1 && columnIndex < this.columns.size() ? this.columns.get((int)columnIndex).clazz : null;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnIndex > -1 && columnIndex < this.columns.size() ? this.columns.get((int)columnIndex).title : null;
    }

    @Override
    public boolean isColumnSortable(int columnIndex) {
        return columnIndex > -1 && columnIndex < this.columns.size() ? Boolean.valueOf(this.columns.get((int)columnIndex).sortable) : null;
    }

    @Override
    public int getColumnPrefferedWidth(int columnIndex) {
        return columnIndex > -1 && columnIndex < this.columns.size() ? this.columns.get((int)columnIndex).prefferedWidth : 0;
    }

    @Override
    public int getColumnMinWidth(int columnIndex) {
        return columnIndex > -1 && columnIndex < this.columns.size() ? this.columns.get((int)columnIndex).minWidth : 0;
    }

    @Override
    public int getColumnMaxWidth(int columnIndex) {
        return columnIndex > -1 && columnIndex < this.columns.size() ? this.columns.get((int)columnIndex).maxWidth : 0;
    }

    @Override
    public boolean isColumnHidden(int columnIndex) {
        return columnIndex > -1 && columnIndex < this.columns.size() ? this.columns.get((int)columnIndex).hidden : false;
    }

    @Override
    public boolean isColumnVisible(int columnIndex) {
        return columnIndex > -1 && columnIndex < this.columns.size() ? this.columns.get((int)columnIndex).visible : true;
    }

    @Override
    public void setColumnVisible(int columnIndex, boolean value) {
        if (columnIndex > -1 && columnIndex < this.columns.size()) {
            this.columns.get((int)columnIndex).visible = value;
        }
    }

    public Object getValue(K val, int columnIndex) throws Exception {
        return this.columns.isEmpty() || columnIndex < 0 && columnIndex >= this.columns.size() ? null : (val != null ? this.columns.get(columnIndex).getValue(val) : null);
    }

    public Object getValueAt(K val, int column) throws Exception {
        return this.getValue(val, column);
    }

    protected void setValue(K e, int column, Object val) {
        this.columns.get(column).setValue(e, val);
    }

    protected abstract void initColumns();

    protected void reinitColumns() {
        this.columns.clear();
        this.initColumns();
    }

    protected BGTableModelColumnRef addColumnId() {
        return this.addColumnId(true);
    }

    protected BGTableModelColumnRef addColumnId(boolean sortable) {
        return this.addColumn("ID", 80, 80, 80, "id", sortable, DecimalTableCellRenderer.INTEGER());
    }

    protected BGTableModelColumnRef addColumn(String title, String name, boolean sortable) {
        return this.addColumn(title, null, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, name, sortable, false, null);
    }

    protected BGTableModelColumnRef addColumn(String title, Class<?> clazz, boolean sortable) {
        return this.addColumn(title, clazz, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, sortable, false, null);
    }

    protected BGTableModelColumnRef addColumn(String title, int minWidth, int prefferedWidth, int maxWidth, String name) {
        return this.addColumn(title, null, minWidth, prefferedWidth, maxWidth, name, false, false, null);
    }

    protected BGTableModelColumnRef addColumn(String title, int minWidth, int prefferedWidth, int maxWidth, String name, boolean sortable) {
        return this.addColumn(title, null, minWidth, prefferedWidth, maxWidth, name, sortable, false, null);
    }

    protected BGTableModelColumnRef addColumn(String title, int minWidth, int prefferedWidth, int maxWidth, String name, boolean sortable, TableCellRenderer tableCellRenderer) {
        return this.addColumn(title, null, minWidth, prefferedWidth, maxWidth, name, sortable, false, true, tableCellRenderer);
    }

    protected BGTableModelColumnRef addColumn(String title, Class<?> fieldClazz, int minWidth, int prefferedWidth, int maxWidth, String name, boolean sortable, TableCellRenderer tableCellRenderer) {
        return this.addColumn(title, fieldClazz, minWidth, prefferedWidth, maxWidth, name, sortable, false, true, tableCellRenderer);
    }

    protected BGTableModelColumnRef addColumn(String title, Class<?> fieldClazz, int minWidth, int prefferedWidth, int maxWidth, String name, boolean sortable) {
        return this.addColumn(title, fieldClazz, minWidth, prefferedWidth, maxWidth, name, sortable, false, null);
    }

    protected BGTableModelColumnRef addColumn(String title, int minWidth, int prefferedWidth, int maxWidth, String name, boolean sortable, boolean defaultVisible) {
        return this.addColumn(title, null, minWidth, prefferedWidth, maxWidth, name, sortable, false, defaultVisible, null);
    }

    protected BGTableModelColumnRef addColumn(String title, Class<?> fieldClazz, int minWidth, int prefferedWidth, int maxWidth, String name, boolean sortable, boolean editable, TableCellRenderer tableCellRenderer) {
        return this.addColumn(title, fieldClazz, minWidth, prefferedWidth, maxWidth, name, sortable, editable, true, tableCellRenderer);
    }

    protected BGTableModelColumnRef addColumn(String title, Class<?> fieldClazz, int minWidth, int prefferedWidth, int maxWidth, String name, boolean sortable, boolean editable, boolean defaultVisible, TableCellRenderer tableCellRenderer) {
        Method getter = null;
        Method setter = null;
        if (Utils.notEmptyString(name)) {
            String methodName = name.substring(0, 1).toUpperCase() + name.substring(1);
            if (this.clazz != null) {
                try {
                    setter = this.clazz.getMethod("set" + methodName, fieldClazz);
                }
                catch (Exception e1) {
                    try {
                        setter = this.clazz.getMethod(name, fieldClazz);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    getter = this.clazz.getMethod("get" + methodName, new Class[0]);
                }
                catch (Exception e1) {
                    try {
                        getter = this.clazz.getMethod("is" + methodName, new Class[0]);
                    }
                    catch (Exception e2) {
                        try {
                            getter = this.clazz.getMethod(name, new Class[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (fieldClazz == null && getter != null) {
            fieldClazz = getter.getReturnType();
            if (fieldClazz == Boolean.TYPE) {
                fieldClazz = Boolean.class;
            } else if (fieldClazz == Integer.TYPE) {
                fieldClazz = Integer.class;
            } else if (fieldClazz == Long.TYPE) {
                fieldClazz = Long.class;
            }
        }
        if (fieldClazz != null && minWidth < -1 && prefferedWidth < -1 && maxWidth < -1) {
            if (Number.class.isAssignableFrom(fieldClazz) || fieldClazz.isPrimitive()) {
                minWidth = -1;
                prefferedWidth = 150;
                maxWidth = 180;
            } else if (Date.class.isAssignableFrom(fieldClazz) || Calendar.class.isAssignableFrom(fieldClazz) || Column.DateTime.class.isAssignableFrom(fieldClazz) || Column.Date.class.isAssignableFrom(fieldClazz) || Column.DateHour.class.isAssignableFrom(fieldClazz)) {
                minWidth = -1;
                prefferedWidth = 150;
                maxWidth = 180;
            } else {
                minWidth = -1;
                prefferedWidth = -1;
                maxWidth = -1;
            }
        }
        if (fieldClazz == null) {
            fieldClazz = Object.class;
        }
        if (!defaultVisible) {
            minWidth = 0;
            prefferedWidth = 0;
            maxWidth = 0;
        }
        BGTableModelColumnRef columnRef = new BGTableModelColumnRef(name, title, fieldClazz, getter, setter, minWidth, prefferedWidth, maxWidth, sortable, editable, defaultVisible);
        this.columns.add(columnRef);
        if (tableCellRenderer != null) {
            columnRef.setTableCellRenderer(tableCellRenderer);
        }
        return columnRef;
    }

    public abstract List<K> getSelectedRows();

    public abstract K getSelectedRow();

    public Optional<K> optSelectedRow() {
        return Optional.ofNullable(this.getSelectedRow());
    }

    @Override
    public void hideColumns() {
        if (this.table == null) {
            return;
        }
        for (int column = 0; column < this.columns.size(); ++column) {
            if (this.columns.get((int)column).visible) continue;
            TableColumn col = this.table.getColumnModel().getColumn(column);
            col.setMinWidth(0);
            col.setPreferredWidth(0);
            col.setMaxWidth(0);
        }
    }

    public List<KeyValue> getColumns() {
        return this.columns.stream().map(a -> new KeyValue(a.name, a.title)).toList();
    }

    public class BGTableModelColumnRef
    extends BGTableModelColumn<K> {
        final Method getter;
        final Method setter;

        public BGTableModelColumnRef(String name, String title, Class<?> clazz, Method getter, Method setter, int minWidth, int prefferedWidth, int maxWidth, boolean sortable, boolean editable) {
            this(name, title, clazz, getter, setter, minWidth, prefferedWidth, maxWidth, sortable, editable, true);
        }

        public BGTableModelColumnRef(String name, String title, Class<?> clazz, Method getter, Method setter, int minWidth, int prefferedWidth, int maxWidth, boolean sortable, boolean editable, boolean defaultVisible) {
            super(name, title, clazz, minWidth, prefferedWidth, maxWidth, sortable, editable, false, defaultVisible);
            this.getter = getter;
            this.setter = setter;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object getValue(K val) {
            String result = null;
            if (val instanceof String[][]) {
                String[][] stringArray = (String[][])val;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] value = stringArray[n2];
                    if (value != null && value.length == 2 && this.name.equals(value[0])) {
                        return value[1];
                    }
                    ++n2;
                }
                return result;
            }
            if (val instanceof Map) {
                return (String)((Map)val).get(this.name);
            }
            if (val instanceof Element) {
                return ((Element)val).getAttribute(this.name);
            }
            try {
                if (this.getter == null) return result;
                if (val == null) return result;
                return this.getter.invoke(val, new Object[0]);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            return result;
        }

        @Override
        public void setValue(K entry, Object val) {
            if (entry instanceof HashMap) {
                ((HashMap)entry).put(this.name, val);
            } else if (entry instanceof String[][]) {
                for (String[] pair : (String[][])entry) {
                    if (!pair[0].equals(this.name)) continue;
                    pair[1] = val.toString();
                    break;
                }
            } else if (entry instanceof Element) {
                ((Element)entry).setAttribute(this.name, val.toString());
                BasicBGTableModel.this.fireTableDataChanged();
            } else {
                try {
                    this.setter.invoke(entry, val);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        }
    }
}

