/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.call.action;

import bitel.billing.server.call.action.base.ActionBase;
import bitel.billing.server.call.bean.ReportUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public abstract class ActionLoginSessions
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        String xsl;
        String output = this.getParameter("output");
        int unit = this.getIntParameter("unit", 1);
        Object xslConfName = "xslt.1";
        String defaultXslt = this.getDefaultXslt();
        if (output != null && output.equals("csv")) {
            xslConfName = (String)xslConfName + ".csv";
            defaultXslt = this.getDefaultXsltCsv();
        }
        if ((xsl = this.moduleSetup.get((String)xslConfName, defaultXslt)) != null) {
            this.rootNode.setAttribute("xslt", xsl);
        }
        List ids = Utils.toIntegerList((String)this.getParameter("id", ""));
        Period period = this.getPeriod();
        ReportUtils lu = this.getReportUtils();
        lu.setUnit(unit);
        Element table = this.createElement(this.rootNode, "table");
        this.addReportParams(period, lu, ids, table);
        Element data = this.createElement(table, "data");
        Page page = this.getPage();
        int show_all = this.getIntParameter("show_all", -1);
        String filter = this.getFilter();
        if (show_all < 0) {
            int col = lu.addSums(data, ids, period, filter);
            page.setRecordCount(col);
            this.setPageAttribute(table, page);
        } else {
            lu.addSums(data, ids, period, filter);
        }
        lu.addSessions(data, ids, period, show_all < 0, page, " * ", filter);
        String reportTitle = this.moduleSetup.get("reportTitle.1", "\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0441\u0435\u0441\u0441\u0438\u044f\u043c");
        table.setAttribute("reportTitle", reportTitle);
        ServerUtils.prepareElementToSerialize(this.rootNode);
    }

    public void sessions(Period period, int lid) throws SQLException {
        Page page = new Page();
        String xsl = this.moduleSetup.get("xslt.1", this.getDefaultXslt());
        if (xsl != null) {
            this.rootNode.setAttribute("xslt", xsl);
        }
        ReportUtils lu = this.getReportUtils();
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        page.setPageIndex(0);
        page.setPageSize(0);
        this.addReportParams(period, lu, lid, table);
        ArrayList<Integer> lids = new ArrayList<Integer>();
        lids.add(lid);
        lu.addSums(data, lids, period, null);
        lu.addSessions(data, lids, period, false, page, " * ", null);
        String reportTitle = this.moduleSetup.get("reportTitle.1", "\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0441\u0435\u0441\u0441\u0438\u044f\u043c");
        table.setAttribute("reportTitle", reportTitle);
        ServerUtils.prepareElementToSerialize(this.rootNode);
    }

    public void sessions(Calendar now, int loginId) throws SQLException {
        Period period = new Period(now.get(1), now.get(2), 1, now.getActualMaximum(5));
        this.sessions(period, loginId);
    }

    protected String getFilter() {
        return null;
    }

    protected abstract String getDefaultXslt();

    protected abstract String getDefaultXsltCsv();
}

