/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.im.server;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterGroup;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.packet.DelayInformation;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.im.common.IMConstants;
import ru.bitel.bgbilling.plugins.im.common.IMMessage;
import ru.bitel.bgbilling.plugins.im.common.IMService;
import ru.bitel.bgbilling.plugins.im.common.IMUtils;
import ru.bitel.bgbilling.plugins.im.common.IRosterEntryContains;
import ru.bitel.bgbilling.plugins.im.common.ProcessCheckStatus;
import ru.bitel.bgbilling.plugins.im.common.RosterChange;
import ru.bitel.bgbilling.plugins.im.common.RosterEntryItem;
import ru.bitel.bgbilling.plugins.im.common.RosterGroupItem;
import ru.bitel.bgbilling.plugins.im.common.RosterRootItem;
import ru.bitel.bgbilling.plugins.im.server.bean.MessageManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.im.common.IMService")
public class IMServiceImpl
extends AbstractService
implements IMService {
    protected static final String CONFIG_SERVER_PARAM = "plugin.im.server";
    protected static final String CONFIG_LOGIN_PARAM = "plugin.im.login";
    protected static final String CONFIG_PASSWORD_PARAM = "plugin.im.password";
    protected static final String CONFIG_RESOURCE_PARAM = "plugin.im.resource";
    private static final Map<String, Integer> jid2userMap = new HashMap<String, Integer>();
    protected BGPluginServer plugin;
    protected Setup setup = null;
    protected MessageManager messageManager;
    private static final Map<Integer, XMPPConnection> userConnections = new HashMap<Integer, XMPPConnection>();
    private static final Map<Integer, List<IMMessage>> userMessages = new HashMap<Integer, List<IMMessage>>();
    private static final Map<Integer, List<RosterListenerItem>> userRosterListenerItemMap = new HashMap<Integer, List<RosterListenerItem>>();

    @PostConstruct
    public void init() {
        this.plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.im");
        this.setup = this.getSetup();
        this.messageManager = new MessageManager(this.getConnection(), this.plugin);
    }

    protected Account isAccountInputed() {
        Account account = new Account();
        account.accServ = this.getUserConfig().get(CONFIG_SERVER_PARAM, null);
        account.accJid = this.getUserConfig().get(CONFIG_LOGIN_PARAM, null);
        account.accPass = this.getUserConfig().get(CONFIG_PASSWORD_PARAM, null);
        account.accReso = this.getUserConfig().get(CONFIG_RESOURCE_PARAM, "BGBilling");
        if (account.accJid == null || account.accPass == null) {
            return null;
        }
        int pi = account.accJid.indexOf("@");
        if (pi == -1) {
            return null;
        }
        if (account.accServ == null) {
            account.accServ = account.accJid.substring(pi + 1);
        }
        account.accLogi = account.accJid.substring(0, pi);
        return account;
    }

    protected XMPPConnection getXMPPConnection() {
        XMPPConnection connection = userConnections.get(this.userId);
        return connection;
    }

    private static void _waitLoadRoster(XMPPConnection connection) {
        Roster roster = connection.getRoster();
        String me = connection.getUser();
        while (roster.getPresenceResource(me).getType() == Presence.Type.unavailable) {
        }
    }

    private void sendStatus(XMPPConnection connection, IMConstants.STATUS status) {
        Presence pres = connection.getRoster().getPresenceResource(connection.getUser());
        switch (status) {
            case ONLINE: {
                pres.setType(Presence.Type.available);
                pres.setMode(null);
                break;
            }
            case AWAY: {
                pres.setType(Presence.Type.available);
                pres.setMode(Presence.Mode.away);
                break;
            }
            case DND: {
                pres.setType(Presence.Type.available);
                pres.setMode(Presence.Mode.dnd);
            }
        }
        connection.sendPacket((Packet)pres);
    }

    protected void connect(IMConstants.STATUS status) throws Exception {
        XMPPConnection connection = userConnections.get(this.userId);
        if (connection == null) {
            if (status == IMConstants.STATUS.OFFLINE) {
                return;
            }
            Account account = this.isAccountInputed();
            if (account == null) {
                throw new Exception("\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d IM-\u0430\u043a\u043a\u0430\u0443\u043d\u0442: \u043b\u043e\u0433\u0438\u043d, \u043f\u0430\u0440\u043e\u043b\u044c");
            }
            try {
                connection = new XMPPConnection(account.accServ);
                connection.connect();
                connection.login(account.accLogi, account.accPass, account.accReso);
            }
            catch (Exception e) {
                if (connection != null) {
                    connection.disconnect();
                }
                throw new Exception("\u041e\u0448\u0438\u0431\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u0430: " + e.getMessage());
            }
            userConnections.put(this.userId, connection);
            jid2userMap.put(account.accJid, this.userId);
            connection.getChatManager().addChatListener(new ChatManagerListener(){

                public void chatCreated(Chat chat, boolean createdLocally) {
                    chat.addMessageListener(new MessageListener(){

                        public void processMessage(Chat chat, Message message) {
                            try {
                                IMServiceImpl.this.putIncomingMessage(message);
                            }
                            catch (BGException e) {
                                IMServiceImpl.this.getLogger().error("error process xmpp message", (Throwable)e);
                            }
                        }
                    });
                }
            });
            IMServiceImpl._waitLoadRoster(connection);
            this.sendStatus(connection, status);
            connection.getRoster().addRosterListener(new RosterListener(){

                public void entriesAdded(Collection<String> addresses) {
                    List<RosterListenerItem> rosterListenerItemList = IMServiceImpl.this.getRosterListenerItemList();
                    for (String entrie : addresses) {
                        IMServiceImpl.this.getLogger().debug("RosterListener::entriesAdded:" + entrie);
                        rosterListenerItemList.add(new RosterListenerItem(IMServiceImpl.this, IMConstants.RosterListenerMode.CHANGE, entrie));
                    }
                }

                public void entriesDeleted(Collection<String> addresses) {
                    List<RosterListenerItem> rosterListenerItemList = IMServiceImpl.this.getRosterListenerItemList();
                    for (String entrie : addresses) {
                        IMServiceImpl.this.getLogger().debug("RosterListener::entriesDeleted:" + entrie);
                        rosterListenerItemList.add(new RosterListenerItem(IMServiceImpl.this, IMConstants.RosterListenerMode.DELETE, entrie));
                    }
                }

                public void entriesUpdated(Collection<String> addresses) {
                    List<RosterListenerItem> rosterListenerItemList = IMServiceImpl.this.getRosterListenerItemList();
                    for (String entrie : addresses) {
                        IMServiceImpl.this.getLogger().debug("RosterListener::entriesUpdated:" + entrie);
                        rosterListenerItemList.add(new RosterListenerItem(IMServiceImpl.this, IMConstants.RosterListenerMode.CHANGE, entrie));
                    }
                }

                public void presenceChanged(Presence presence) {
                    IMServiceImpl.this.getLogger().debug("RosterListener::presenceChanged:" + presence.getFrom());
                    List<RosterListenerItem> rosterListenerItemList = IMServiceImpl.this.getRosterListenerItemList();
                    rosterListenerItemList.add(new RosterListenerItem(IMServiceImpl.this, IMConstants.RosterListenerMode.CHANGE, IMUtils.getPureJID((String)presence.getFrom())));
                }
            });
        } else if (status == IMConstants.STATUS.OFFLINE) {
            connection.disconnect();
            userConnections.put(this.userId, null);
        } else {
            this.sendStatus(connection, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putIncomingMessage(Message message) throws BGException {
        long sentTime = 0L;
        String messageBody = message.getBody();
        DelayInformation inf = (DelayInformation)message.getExtension("x", "jabber:x:delay");
        if (inf != null) {
            sentTime = inf.getStamp().getTime();
            messageBody = "(Offline) " + messageBody;
        } else {
            sentTime = System.currentTimeMillis();
        }
        Connection con1 = this.setup.getDBConnectionFromPool();
        try {
            this.putMessage(con1, message.getFrom(), message.getTo(), messageBody, true, sentTime);
        }
        finally {
            ServerUtils.closeConnection((Connection)con1);
        }
    }

    protected void putMessage(Connection con, String from, String to, String messageBody, boolean incoming, long sentTime) throws BGException {
        if (incoming) {
            this.getLogger().debug("putMessage(in):" + to + "<=" + from + ":" + messageBody);
        } else {
            this.getLogger().debug("putMessage(out):" + from + "=>" + to + ":" + messageBody);
        }
        MessageManager messageManager = new MessageManager(con, this.plugin);
        IMMessage message = new IMMessage();
        message.setTime(sentTime);
        message.setFrom(IMUtils.getPureJID((String)from));
        message.setTo(IMUtils.getPureJID((String)to));
        message.setText(messageBody);
        message.setUserId(this.userId);
        message.setIncoming(incoming);
        messageManager.addMessage(message);
        Integer uid = null;
        uid = incoming ? jid2userMap.get(message.getTo()) : jid2userMap.get(message.getFrom());
        List<IMMessage> imMessageList = this.getUserMessageList(uid);
        message.setFrom(from);
        message.setTo(to);
        imMessageList.add(message);
    }

    protected List<IMMessage> getUserMessageList(Integer uId) {
        List<IMMessage> messages = userMessages.get(uId);
        if (messages == null) {
            messages = new ArrayList<IMMessage>();
            userMessages.put(uId, messages);
        }
        return messages;
    }

    protected int makeEntryXml(RosterEntry entry, IRosterEntryContains elgroup, Roster roster) {
        int availableContactCount = 0;
        Iterator presences = roster.getPresences(entry.getUser());
        while (presences.hasNext()) {
            Presence presence = (Presence)presences.next();
            RosterEntryItem elentry = new RosterEntryItem();
            elgroup.addEntry(elentry);
            if (entry.getName() != null) {
                elentry.name = entry.getName();
            }
            elentry.subscr = String.valueOf(entry.getType()) + (String)(entry.getStatus() != null ? "," + String.valueOf(entry.getStatus()) : "");
            this.makePresenceXml(presence, elentry);
            if (!presence.isAvailable()) continue;
            ++availableContactCount;
        }
        return availableContactCount;
    }

    protected void makePresenceXml(Presence presence, RosterEntryItem elentry) {
        elentry.from = presence.getFrom();
        if (presence.isAvailable()) {
            elentry.priority = presence.getPriority();
        }
        if (presence.getStatus() != null) {
            elentry.statusmessage = presence.getStatus();
        }
        IMConstants.STATUS status = null;
        if (!presence.isAvailable()) {
            status = IMConstants.STATUS.OFFLINE;
        } else if (!presence.isAway()) {
            status = IMConstants.STATUS.ONLINE;
        } else {
            status = IMConstants.STATUS.AWAY;
            if (presence.getMode() != null && presence.getMode() == Presence.Mode.dnd) {
                status = IMConstants.STATUS.DND;
            }
        }
        elentry.status = status;
    }

    protected List<RosterListenerItem> getRosterListenerItemList() {
        List<RosterListenerItem> rosterListenerItemList = userRosterListenerItemMap.get(this.userId);
        if (rosterListenerItemList == null) {
            rosterListenerItemList = new ArrayList<RosterListenerItem>();
            userRosterListenerItemMap.put(this.userId, rosterListenerItemList);
        }
        return rosterListenerItemList;
    }

    protected ProcessCheckStatus buildProcessCheckStatus(XMPPConnection connection) {
        ProcessCheckStatus result = new ProcessCheckStatus();
        List messageList = IMUtils.cloneListAndClear(this.getUserMessageList(this.userId));
        if (messageList.size() > 0) {
            result.setMessageList(messageList);
        }
        List<RosterListenerItem> rosterListenerItemListOrig = this.getRosterListenerItemList();
        ArrayList<RosterListenerItem> rosterListenerItemListCopy = new ArrayList<RosterListenerItem>();
        rosterListenerItemListCopy.addAll(rosterListenerItemListOrig);
        rosterListenerItemListOrig.clear();
        ArrayList<RosterListenerItem> rlnew = new ArrayList<RosterListenerItem>();
        for (RosterListenerItem item : rosterListenerItemListCopy) {
            int io = rlnew.indexOf(item);
            if (io == -1) {
                rlnew.add(item);
                continue;
            }
            RosterListenerItem oo = (RosterListenerItem)rlnew.get(io);
            if (oo.getMode() == IMConstants.RosterListenerMode.DELETE && item.getMode() == IMConstants.RosterListenerMode.CHANGE) {
                oo.setMode(IMConstants.RosterListenerMode.CHANGE);
            }
            if (oo.getMode() != IMConstants.RosterListenerMode.CHANGE || item.getMode() != IMConstants.RosterListenerMode.DELETE) continue;
            oo.setMode(IMConstants.RosterListenerMode.DELETE);
        }
        for (RosterListenerItem item : rlnew) {
            RosterChange elRosterChanges = new RosterChange();
            result.addRosterChanges(elRosterChanges);
            elRosterChanges.mode = item.getMode();
            elRosterChanges.user = item.getJid();
            if (item.getMode() != IMConstants.RosterListenerMode.CHANGE) continue;
            Roster roster = connection.getRoster();
            RosterEntry entry = roster.getEntry(item.getJid());
            this.makeEntryXml(entry, (IRosterEntryContains)elRosterChanges, roster);
        }
        return result;
    }

    public ProcessCheckStatus checkStatus() throws BGException {
        XMPPConnection connection = this.getXMPPConnection();
        if (connection == null) {
            throw new BGMessageException("\u041d\u0435\u0442 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u0430");
        }
        return this.buildProcessCheckStatus(connection);
    }

    public Result<IMMessage> getHistory(String jidfrom, IMConstants.GETHISTORYMODE getHistoryMode, Long datefrom, Long dateto, Page page) throws BGException {
        switch (getHistoryMode) {
            case PERIOD: {
                break;
            }
            case WEEK: {
                datefrom = System.currentTimeMillis() - 604800000L;
                dateto = null;
                break;
            }
            case DAY: {
                datefrom = System.currentTimeMillis() - 86400000L;
                dateto = null;
                break;
            }
            case HOUR: {
                datefrom = System.currentTimeMillis() - 3600000L;
                dateto = null;
            }
        }
        String jidto = this.getUserConfig().get(CONFIG_LOGIN_PARAM, null);
        List<IMMessage> messageList = this.messageManager.getMessageList(this.userId, jidfrom, jidto, datefrom, dateto, page);
        page.setRecordCount(this.messageManager.getMessageCount(this.userId, jidfrom, jidto, datefrom, dateto));
        return new Result(messageList, page);
    }

    public RosterRootItem getRoster() throws BGException {
        String selfEntryName;
        int availableContactCount = 0;
        int totalAvailableEntryCount = 0;
        int totalEntryCount = 0;
        XMPPConnection connection = this.getXMPPConnection();
        if (connection == null) {
            throw new BGMessageException("\u041d\u0435\u0442 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u0430");
        }
        Roster roster = connection.getRoster();
        RosterRootItem elroster = new RosterRootItem();
        Collection groups = roster.getGroups();
        for (RosterGroup group : groups) {
            RosterGroupItem elgroup = new RosterGroupItem();
            elroster.addGroup(elgroup);
            elgroup.name = group.getName();
            elgroup.EntryCount = group.getEntryCount();
            totalEntryCount += group.getEntryCount();
            availableContactCount = 0;
            Collection entrys = group.getEntries();
            for (RosterEntry entry : entrys) {
                availableContactCount += this.makeEntryXml(entry, (IRosterEntryContains)elgroup, roster);
            }
            elgroup.AvailableEntryCount = availableContactCount;
            totalAvailableEntryCount += availableContactCount;
        }
        if (roster.getUnfiledEntryCount() > 0) {
            RosterGroupItem elgroup = new RosterGroupItem();
            elroster.addGroup(elgroup);
            elgroup.name = "General";
            elgroup.EntryCount = roster.getUnfiledEntryCount();
            totalEntryCount += roster.getUnfiledEntryCount();
            availableContactCount = 0;
            Collection entrys = roster.getUnfiledEntries();
            for (RosterEntry entry : entrys) {
                availableContactCount += this.makeEntryXml(entry, (IRosterEntryContains)elgroup, roster);
            }
            elgroup.AvailableEntryCount = availableContactCount;
            totalAvailableEntryCount += availableContactCount;
        }
        elroster.user = connection.getUser();
        elroster.name = selfEntryName = IMUtils.getLoginFromJID((String)connection.getUser());
        elroster.EntryCount = totalEntryCount;
        elroster.AvailableEntryCount = totalAvailableEntryCount;
        Iterator presences = roster.getPresences(connection.getUser());
        availableContactCount = 0;
        int contactCount = 0;
        RosterGroupItem elgroup = new RosterGroupItem();
        elroster.addGroup(elgroup);
        elgroup.name = "Self";
        while (presences.hasNext()) {
            Presence presence = (Presence)presences.next();
            RosterEntryItem elentry = new RosterEntryItem();
            elgroup.addEntry(elentry);
            this.makePresenceXml(presence, elentry);
            elentry.name = selfEntryName;
            if (presence.isAvailable()) {
                ++availableContactCount;
            }
            ++contactCount;
        }
        elgroup.AvailableEntryCount = availableContactCount;
        elgroup.EntryCount = contactCount;
        List<RosterListenerItem> rosterListenerItemListOrig = this.getRosterListenerItemList();
        rosterListenerItemListOrig.clear();
        return elroster;
    }

    public ProcessCheckStatus rosterAddContact(String jid, String name, String group) throws BGException {
        XMPPConnection connection = this.getXMPPConnection();
        if (connection == null) {
            throw new BGMessageException("\u041d\u0435\u0442 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u0430");
        }
        Roster roster = connection.getRoster();
        String[] groups = new String[]{group};
        try {
            roster.createEntry(jid, name, groups);
        }
        catch (XMPPException e) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430: " + String.valueOf((Object)e));
        }
        return this.buildProcessCheckStatus(connection);
    }

    public ProcessCheckStatus rosterMoveContact(String jid, String groupName) throws BGException {
        XMPPConnection connection = this.getXMPPConnection();
        if (connection == null) {
            throw new BGMessageException("\u041d\u0435\u0442 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u0430");
        }
        Roster roster = connection.getRoster();
        RosterEntry rosterEntry = roster.getEntry(jid);
        if (rosterEntry != null) {
            try {
                RosterGroup rosterGroup = roster.getGroup(groupName);
                if (rosterGroup == null) {
                    rosterGroup = roster.createGroup(groupName);
                }
                for (RosterGroup g : rosterEntry.getGroups()) {
                    g.removeEntry(rosterEntry);
                }
                rosterGroup.addEntry(rosterEntry);
            }
            catch (XMPPException e) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430: " + String.valueOf((Object)e));
            }
        } else {
            throw new BGMessageException("\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u0430 \u0441 jid '" + jid + "' \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        return this.buildProcessCheckStatus(connection);
    }

    public ProcessCheckStatus rosterRemoveContact(String jid) throws BGException {
        XMPPConnection connection = this.getXMPPConnection();
        if (connection == null) {
            throw new BGMessageException("\u041d\u0435\u0442 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u0430");
        }
        Roster roster = connection.getRoster();
        RosterEntry rosterEntry = roster.getEntry(jid);
        if (rosterEntry != null) {
            try {
                roster.removeEntry(rosterEntry);
            }
            catch (XMPPException e) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430: " + String.valueOf((Object)e));
            }
        } else {
            throw new BGMessageException("\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u0430 \u0441 jid '" + jid + "' \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        return this.buildProcessCheckStatus(connection);
    }

    public void rosterRemoveGroup(String name) throws BGException {
        XMPPConnection connection = this.getXMPPConnection();
        if (connection == null) {
            throw new BGMessageException("\u041d\u0435\u0442 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u0430");
        }
        Roster roster = connection.getRoster();
        RosterGroup group = roster.getGroup(name);
        if (group != null) {
            try {
                for (RosterEntry entry : group.getEntries()) {
                    group.removeEntry(entry);
                }
            }
            catch (XMPPException e) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430: " + String.valueOf((Object)e));
            }
        } else {
            throw new BGMessageException("\u0413\u0440\u0443\u043f\u043f\u044b \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '" + name + "' \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
        }
    }

    public ProcessCheckStatus rosterRenameContact(String jid, String newName) throws BGException {
        XMPPConnection connection = this.getXMPPConnection();
        if (connection == null) {
            throw new BGMessageException("\u041d\u0435\u0442 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u0430");
        }
        Roster roster = connection.getRoster();
        RosterEntry rosterEntry = roster.getEntry(jid);
        if (rosterEntry == null) {
            throw new BGMessageException("\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u0430 \u0441 jid '" + jid + "' \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        rosterEntry.setName(newName);
        return this.buildProcessCheckStatus(connection);
    }

    public void rosterRenameGroup(String name, String newName) throws BGException {
        XMPPConnection connection = this.getXMPPConnection();
        if (connection == null) {
            throw new BGMessageException("\u041d\u0435\u0442 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u0430");
        }
        Roster roster = connection.getRoster();
        RosterGroup group = roster.getGroup(name);
        if (group == null) {
            throw new BGMessageException("\u0413\u0440\u0443\u043f\u043f\u044b \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '" + name + "' \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        group.setName(newName);
    }

    public ProcessCheckStatus sendMessage(String userto, String text) throws BGException {
        XMPPConnection connection = this.getXMPPConnection();
        if (connection == null) {
            throw new BGMessageException("\u041d\u0435\u0442 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u0430");
        }
        try {
            Message msg = new Message();
            msg.setBody(text);
            msg.setTo(userto);
            msg.setType(Message.Type.chat);
            connection.sendPacket((Packet)msg);
            String jidfrom = connection.getUser();
            this.putMessage(this.getConnection(), jidfrom, userto, text, false, System.currentTimeMillis());
            return this.buildProcessCheckStatus(connection);
        }
        catch (Exception e) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage());
        }
    }

    public void setStatus(IMConstants.STATUS status) throws BGException {
        try {
            this.connect(status);
        }
        catch (Exception e) {
            throw new BGException(e.getMessage());
        }
    }

    private static class Account {
        private String accServ = null;
        private String accJid = null;
        private String accLogi = null;
        private String accPass = null;
        private String accReso = null;

        private Account() {
        }
    }

    protected class RosterListenerItem {
        private IMConstants.RosterListenerMode mode;
        private String jid;

        public RosterListenerItem(IMServiceImpl this$0, IMConstants.RosterListenerMode mode, String jid) {
            this.mode = mode;
            this.jid = jid;
        }

        public IMConstants.RosterListenerMode getMode() {
            return this.mode;
        }

        public void setMode(IMConstants.RosterListenerMode mode) {
            this.mode = mode;
        }

        public String getJid() {
            return this.jid;
        }

        public void setJid(String jid) {
            this.jid = jid;
        }

        public boolean equals(Object obj) {
            return this.jid.equals(((RosterListenerItem)obj).getJid());
        }

        public int hashCode() {
            return this.jid.hashCode();
        }

        public String toString() {
            return super.toString() + "@" + this.jid + "@" + String.valueOf(this.mode);
        }
    }
}

