/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tinkoff.server;

import bitel.billing.server.BGPaymentModule;
import bitel.billing.server.ModuleBase;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.BGTransactionType;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMethod;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.tinkoff.common.bean.Transaction;
import ru.bitel.bgbilling.modules.tinkoff.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.tinkoff.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.tinkoff.server.event.TinkoffAutopaymentEvent;
import ru.bitel.bgbilling.modules.tinkoff.server.event.TinkoffCheckEvent;
import ru.bitel.bgbilling.modules.tinkoff.server.event.worker.TinkoffAutopaymentEventWorker;
import ru.bitel.bgbilling.modules.tinkoff.server.event.worker.TinkoffCheckEventWorker;
import ru.bitel.bgbilling.modules.tinkoff.server.service.TinkoffServiceImpl;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.jmx.MBeanPaymentModule;

@BGPaymentModule
public class Module
extends ModuleBase
implements MBeanPaymentModule {
    final String[] loggerName = new String[]{Module.class.getName(), TransactionManager.class.getName(), TinkoffServiceImpl.class.getName()};

    public String[] getServerPackages() {
        return new String[]{"ru.bitel.bgbilling.modules.tinkoff.server"};
    }

    public void start(Connection con, BGModule module) throws BGException {
        this.registerMBean(module);
        if (Setup.getSetup().getModuleSetup(Integer.valueOf(module.getId())).getBoolean("tinkoff.event.worker", true)) {
            new TinkoffCheckEventWorker(Setup.getSetup(), module.getId());
            new TinkoffAutopaymentEventWorker(Setup.getSetup(), module.getId());
        } else {
            this.addListeners(module);
        }
    }

    @Deprecated
    private void addListeners(final BGModule module) throws BGException {
        EventProcessor.getInstance().addListener((EventListener)new EventListener<TinkoffCheckEvent>(){

            public void notify(TinkoffCheckEvent event, EventListenerContext ctx) throws Exception {
                new TransactionManager(ctx.getConnection(), module.getId()).doCheckRequest(event.getContractId(), event.isAutopaymentTransaction());
            }
        }, TinkoffCheckEvent.class, module.getId(), null);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<TinkoffAutopaymentEvent>(){

            public void notify(TinkoffAutopaymentEvent event, EventListenerContext ctx) throws Exception {
                Contract contract;
                int moduleId = module.getId();
                int contractId = event.getContractId();
                Connection con = ctx.getConnection();
                AutopaymentManager autopaymentManager = new AutopaymentManager(con, moduleId);
                Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
                BigDecimal sum = event.getSum();
                if (sum == null) {
                    sum = autopayment.getSum();
                }
                if (autopayment != null && autopayment.getMode().getCode() == event.getMode() && (contract = ContractDao.getContract((Connection)con, (int)contractId)) != null) {
                    String customerAddress = ContractUtils.getCustomerAddress((Connection)con, (int)moduleId, (int)contractId);
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    TransactionManager transactionManager = new TransactionManager(con, moduleId);
                    String paymentPhone = ContractUtils.getPaymentPhone((Connection)con, (int)moduleId, (int)contractId);
                    Transaction transaction = transactionManager.registerOrder(contractId, contract.getTitle(), customerAddress, sum, dataMap, true, false, BGTransactionType.CARD, paymentPhone);
                    transactionManager.doCharge(transaction, autopayment);
                }
            }
        }, TinkoffAutopaymentEvent.class, module.getId(), null);
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        super.moduleAction(serverContext, moduleId, event);
        int contractId = event.getContractId();
        try {
            ContractDeleteEvent contractDeleteEvent;
            Connection con = serverContext.getConnection();
            if (event instanceof ContractCreateEvent) {
                ContractCreateEvent contractCreateEvent = (ContractCreateEvent)event;
                if (!contractCreateEvent.isCheck()) {
                    this.enableAutopayment(contractCreateEvent.getPattern().getData(), "tinkoff", moduleId, contractId, con, serverContext.getUserId());
                }
            } else if (event instanceof ContractDeleteEvent && !(contractDeleteEvent = (ContractDeleteEvent)event).isCheck()) {
                this.removeAutopayment(moduleId, contractId, con);
            }
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    public List<PaymentMethod> getPaymentMethods(int moduleId) {
        ArrayList<PaymentMethod> methods = new ArrayList<PaymentMethod>();
        if (Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId)).getBoolean("tinkoff.sbp.enable", false)) {
            methods.add(PaymentMethod.SBP);
        }
        methods.add(PaymentMethod.CARD);
        return methods;
    }

    public String[] getLoggerNames() {
        return this.loggerName;
    }
}

