/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttribute;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeKit;
import ru.bitel.bgbilling.plugins.shop.server.dao.StockItemAttributeDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

public class AttributeLinkKitDao {
    private static final String ATTRIBUTE_KIT_LINK_TABLE_NAME = "stock_item_attribute_link_kit";
    private final Connection connection;

    public AttributeLinkKitDao(Connection connection) {
        this.connection = connection;
    }

    public List<StockItemAttribute> getAttributesByKitId(int kitId, StockItemAttributeDao attributeDao) throws BGException {
        ArrayList<StockItemAttribute> result = new ArrayList<StockItemAttribute>();
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT attr.* FROM stock_item_attribute_link_kit AS linkTable LEFT JOIN stock_item_attribute AS attr ON linkTable.attribute_id=attr.id WHERE linkTable.attribute_kit_id=?");){
            ps.setInt(1, kitId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(attributeDao.getFromRS(rs));
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public void updateAttributesByKitId(StockItemAttributeKit attributeKit) throws BGException {
        try (Statement statement = this.connection.createStatement();){
            statement.executeUpdate("DELETE FROM stock_item_attribute_link_kit WHERE attribute_kit_id=" + attributeKit.getId());
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        if (Utils.isEmptyCollection((Collection)attributeKit.getAttributes())) {
            return;
        }
        List<Integer> attributesIds = attributeKit.getAttributes().stream().mapToInt(Id::getId).boxed().toList();
        try (PreparedStatement ps = this.connection.prepareStatement("INSERT INTO stock_item_attribute_link_kit SET attribute_kit_id=?, attribute_id=?");){
            for (Integer attributeId : attributesIds) {
                ps.setInt(1, attributeKit.getId());
                ps.setInt(2, attributeId);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

