/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.sqleditor.client;

import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.sqleditor.client.QueryInfo;
import ru.bitel.bgbilling.plugins.sqleditor.client.SQLEditor;
import ru.bitel.bgbilling.plugins.sqleditor.client.SQLList;
import ru.bitel.bgbilling.plugins.sqleditor.common.bean.SqlHistoryRequest;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class SQLHistoryList
extends SQLList {
    public SQLHistoryList(SQLEditor sqlEditor, List<String> buttons) {
        super(sqlEditor, buttons);
    }

    public void addHistoryEntry(QueryInfo queryInfo) {
        SqlHistoryRequest historyRequest = new SqlHistoryRequest();
        historyRequest.setRequest(queryInfo.getQuery());
        historyRequest.setCreateDate(new Date());
        this.sqlEditor.getSQLHistoryPanel().saveHistoryRequest(historyRequest);
        this.sqlEditor.getSQLHistoryPanel().reloadList();
    }

    public void setData(List<SqlHistoryRequest> requestList) {
        if (Utils.isEmptyCollection(requestList)) {
            return;
        }
        this.getListModel().clear();
        this.getListModel().addAll(requestList.stream().map(req -> new QueryInfo(QueryInfo.DATE_FORMAT.format(req.getCreateDate()), req.getRequest())).collect(Collectors.toList()));
    }

    @Override
    protected void deleteHistoryEntry() {
        try {
            QueryInfo queryInfo = (QueryInfo)this.getSelectedValue();
            Date requestDate = TimeUtils.parseDate((String)queryInfo.getTitle(), (DateFormat)QueryInfo.DATE_FORMAT);
            this.sqlEditor.getSQLHistoryPanel().getSqlHistoryService().deleteByQueryInfo(requestDate, queryInfo.getQuery());
            this.sqlEditor.getSQLHistoryPanel().reloadList();
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }
}

