/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.reports.common.bean.ReportAccessRule;
import ru.bitel.common.Utils;

public class ReportAccessRuleDao
extends AbstarctDaoConstant {
    public ReportAccessRuleDao(Connection con, int moduleId) {
        super(con, "report_access_rule", moduleId);
    }

    public ReportAccessRule getAccessRulesByReportId(String reportId) throws BGException {
        if (Utils.isBlankString((String)reportId)) {
            throw new IllegalArgumentException("ReportId is null");
        }
        ReportAccessRule reportAccessRule = new ReportAccessRule(reportId);
        String query = "SELECT * FROM " + this.tableName + " WHERE report_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, reportId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int userId = rs.getInt("user_id");
                    int roleId = rs.getInt("role_id");
                    if (userId > 0) {
                        reportAccessRule.addAllowedUserId(userId);
                        continue;
                    }
                    if (roleId <= 0) continue;
                    reportAccessRule.addAllowedRoleId(roleId);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return reportAccessRule;
    }

    public void updateAccessRule(ReportAccessRule reportAccessRule) throws SQLException {
        this.deleteRulesByReportId(reportAccessRule.getReportId());
        String query = "INSERT INTO " + this.tableName + " SET report_id=?,user_id=?,role_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            try (Statement statement = this.con.createStatement();){
                statement.executeUpdate("SET FOREIGN_KEY_CHECKS=0");
            }
            String reportId = reportAccessRule.getReportId();
            for (Integer roleId : reportAccessRule.getAllowedRoleIds()) {
                ps.setString(1, reportId);
                ps.setInt(2, 0);
                ps.setInt(3, roleId);
                ps.addBatch();
            }
            for (Integer userId : reportAccessRule.getAllowedUserIds()) {
                ps.setString(1, reportId);
                ps.setInt(2, userId);
                ps.setInt(3, 0);
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }

    public void deleteRulesByReportId(String reportId) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE report_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, reportId);
            ps.executeUpdate();
        }
    }
}

