/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttribute;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class StockItemAttributeDao
extends AbstractIdDao<StockItemAttribute> {
    public StockItemAttributeDao(Connection con, int moduleId) {
        super(con, "stock_item_attribute", moduleId);
    }

    protected StockItemAttribute getFromRS(ResultSet rs) throws SQLException, BGException {
        StockItemAttribute attribute = new StockItemAttribute();
        attribute.setId(rs.getInt("id"));
        attribute.setTitle(rs.getString("title"));
        attribute.setRequired(rs.getInt("required") == 1);
        attribute.setUnique(rs.getInt("unique_attr") == 1);
        attribute.setAttributeType(StockItemAttributeType.getType((int)rs.getInt("type")));
        return attribute;
    }

    protected void updateImpl(StockItemAttribute attribute) throws BGException, SQLException {
        boolean isNew = attribute.getId() <= 0;
        String prefix = isNew ? "INSERT INTO " : "UPDATE ";
        String query = prefix + this.tableName + " SET title=?, type=?, required=?, unique_attr=?" + (isNew ? "" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setString(1, attribute.getTitle());
            ps.setInt(2, attribute.getAttributeType().ordinal());
            ps.setInt(3, attribute.isRequired() ? 1 : 0);
            ps.setInt(4, attribute.isUnique() ? 1 : 0);
            if (!isNew) {
                ps.setInt(5, attribute.getId());
            }
            ps.executeUpdate();
            if (isNew) {
                attribute.setId(ServerUtils.lastInsertId((Connection)this.con));
            }
        }
    }

    public List<StockItemAttribute> getList() throws BGException {
        ArrayList<StockItemAttribute> list = new ArrayList<StockItemAttribute>();
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery("SELECT * FROM " + this.tableName);){
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return list;
    }
}

