/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cloudpayments.server.event.worker;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.cloudpayments.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.cloudpayments.server.event.CloudPaymentsCheckEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class CloudPaymentsCheckEventWorker
extends EventWorker {
    private TransactionManager transactionManager;

    public CloudPaymentsCheckEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), CloudPaymentsCheckEvent.class, moduleId, -1, null);
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 10000L;
        this.getLogger().info("Starting CloudPaymentsCheckEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "cloudpayments-check-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        return this.doTasks();
    }

    public Object doTask(Object task) throws BGException {
        try {
            CloudPaymentsCheckEvent event = (CloudPaymentsCheckEvent)((Object)task);
            this.transactionManager.doCheckRequest(event.getContractId(), event.isAutopaymentTransaction());
            return null;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

